/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.hdfs.server.federation.store.records.QueryResult;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class StateStoreBaseImpl
extends StateStoreDriver {
    @Override
    public <T extends BaseRecord> T get(Class<T> clazz, Query<T> query) throws IOException {
        List<T> records = this.getMultiple(clazz, query);
        if (records.size() > 1) {
            throw new IOException("Found more than one object in collection");
        }
        if (records.size() == 1) {
            return (T)((BaseRecord)records.get(0));
        }
        return null;
    }

    @Override
    public <T extends BaseRecord> List<T> getMultiple(Class<T> clazz, Query<T> query) throws IOException {
        QueryResult<T> result = this.get(clazz);
        List<T> records = result.getRecords();
        List<T> ret = StateStoreUtils.filterMultiple(query, records);
        if (ret == null) {
            throw new IOException("Cannot fetch records from the store");
        }
        return ret;
    }

    @Override
    public <T extends BaseRecord> boolean put(T record, boolean allowUpdate, boolean errorIfExists) throws IOException {
        ArrayList<T> singletonList = new ArrayList<T>();
        singletonList.add(record);
        return this.putAll(singletonList, allowUpdate, errorIfExists).isOperationSuccessful();
    }

    @Override
    public <T extends BaseRecord> boolean remove(T record) throws IOException {
        Query<T> query = new Query<T>(record);
        Class<?> clazz = record.getClass();
        Class<BaseRecord> recordClass = StateStoreUtils.getRecordClass(clazz);
        return this.remove(recordClass, query) == 1;
    }

    @Override
    public <T extends BaseRecord> Map<T, Boolean> removeMultiple(List<T> records) throws IOException {
        assert (!records.isEmpty());
        Class<?> expectedClazz = ((BaseRecord)records.get(0)).getClass();
        if (!records.stream().allMatch(x -> x.getClass() == expectedClazz)) {
            HashMap<BaseRecord, Boolean> result = new HashMap<BaseRecord, Boolean>();
            for (BaseRecord record : records) {
                result.put(record, this.remove(record));
            }
            return result;
        }
        ArrayList<Query<T>> queries = new ArrayList<Query<T>>();
        for (BaseRecord record : records) {
            queries.add(new Query<BaseRecord>(record));
        }
        Class<BaseRecord> recordClass = StateStoreUtils.getRecordClass(expectedClazz);
        Map<Query<BaseRecord>, Integer> result = this.remove(recordClass, queries);
        return result.entrySet().stream().collect(Collectors.toMap(e -> ((Query)e.getKey()).getPartial(), e -> (Integer)e.getValue() == 1));
    }

    @Override
    public <T extends BaseRecord> Map<Query<T>, Integer> remove(Class<T> clazz, List<Query<T>> queries) throws IOException {
        HashMap<Query<T>, Integer> result = new HashMap<Query<T>, Integer>();
        for (Query<T> query : queries) {
            result.put(query, this.remove(clazz, query));
        }
        return result;
    }
}

