/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.StateStoreMetrics;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreRecordOperations;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class StateStoreDriver
implements StateStoreRecordOperations {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreDriver.class);
    private Configuration conf;
    private String identifier;
    private StateStoreMetrics metrics;
    private ThreadPoolExecutor executor = null;

    public boolean init(Configuration config, String id, Collection<Class<? extends BaseRecord>> records, StateStoreMetrics stateStoreMetrics) {
        boolean success;
        this.conf = config;
        this.identifier = id;
        this.metrics = stateStoreMetrics;
        if (this.identifier == null) {
            LOG.warn("The identifier for the State Store connection is not set");
        }
        if (!(success = this.initDriver())) {
            LOG.error("Cannot initialize driver for {}", (Object)this.getDriverName());
            return false;
        }
        for (Class<? extends BaseRecord> cls : records) {
            String recordString = StateStoreUtils.getRecordName(cls);
            if (this.initRecordStorage(recordString, cls)) continue;
            LOG.error("Cannot initialize record store for {}", (Object)cls.getSimpleName());
            return false;
        }
        int nThreads = this.conf.getInt("dfs.federation.router.store.driver.async.override.max.threads", -1);
        if (nThreads > 0) {
            this.executor = new ThreadPoolExecutor(nThreads, nThreads, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
            this.executor.allowCoreThreadTimeOut(true);
            LOG.info("Init StateStoreDriver in async mode with {} threads.", (Object)nThreads);
        } else {
            LOG.info("Init StateStoreDriver in sync mode.");
        }
        return true;
    }

    protected Configuration getConf() {
        return this.conf;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public StateStoreMetrics getMetrics() {
        return this.metrics;
    }

    public abstract boolean initDriver();

    public abstract <T extends BaseRecord> boolean initRecordStorage(String var1, Class<T> var2);

    public abstract boolean isDriverReady();

    public void verifyDriverReady() throws StateStoreUnavailableException {
        if (!this.isDriverReady()) {
            String driverName = this.getDriverName();
            String hostname = this.getHostname();
            throw new StateStoreUnavailableException("State Store driver " + driverName + " in " + hostname + " is not ready.");
        }
    }

    public void close() throws Exception {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    public long getTime() {
        return Time.now();
    }

    private String getDriverName() {
        return this.getClass().getSimpleName();
    }

    private String getHostname() {
        String hostname = "Unknown";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            LOG.error("Cannot get local address", (Throwable)e);
        }
        return hostname;
    }

    public <R extends BaseRecord> List<R> handleOverwriteAndDelete(List<R> commitRecords, List<R> deleteRecords) throws IOException {
        ArrayList<BaseRecord> result = null;
        try {
            if (commitRecords != null && !commitRecords.isEmpty()) {
                Runnable overwriteCallable = () -> {
                    try {
                        this.putAll(commitRecords, true, false);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                };
                if (this.executor != null) {
                    this.executor.execute(overwriteCallable);
                } else {
                    overwriteCallable.run();
                }
            }
            if (deleteRecords != null && !deleteRecords.isEmpty()) {
                HashMap removedRecords = new HashMap();
                Runnable deletionCallable = () -> {
                    try {
                        removedRecords.putAll(this.removeMultiple(deleteRecords));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                };
                if (this.executor != null) {
                    this.executor.execute(deletionCallable);
                } else {
                    result = new ArrayList<BaseRecord>();
                    deletionCallable.run();
                    for (Map.Entry entry : removedRecords.entrySet()) {
                        if (!((Boolean)entry.getValue()).booleanValue()) continue;
                        result.add((BaseRecord)entry.getKey());
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return result;
    }
}

