/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async.utils;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.Async;

@FunctionalInterface
public interface CatchFunction<R, E extends Throwable>
extends Async<R> {
    public R apply(R var1, E var2) throws IOException;

    default public CompletableFuture<R> apply(CompletableFuture<R> in, Class<E> eClazz) {
        return in.handle((r, e) -> {
            if (e == null) {
                return r;
            }
            Throwable readException = Async.unWarpCompletionException(e);
            if (eClazz.isInstance(readException)) {
                try {
                    return this.apply(r, readException);
                }
                catch (IOException ioe) {
                    throw Async.warpCompletionException(ioe);
                }
            }
            throw Async.warpCompletionException(e);
        });
    }
}

