/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.ApplyFunction;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.Async;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncApplyFunction;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncBiFunction;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncForEachRun;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncRun;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.CatchFunction;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.FinallyFunction;

public final class AsyncUtil {
    private static final Boolean BOOLEAN_RESULT = false;
    private static final Long LONG_RESULT = -1L;
    private static final Integer INT_RESULT = -1;
    private static final Object NULL_RESULT = null;

    private AsyncUtil() {
    }

    public static <R> R asyncReturn(Class<R> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return (R)BOOLEAN_RESULT;
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return (R)LONG_RESULT;
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return (R)INT_RESULT;
        }
        return (R)NULL_RESULT;
    }

    public static <R> R syncReturn(Class<R> clazz) throws Exception {
        CompletableFuture<Object> completableFuture = Async.CUR_COMPLETABLE_FUTURE.get();
        assert (completableFuture != null);
        try {
            return (R)completableFuture.get();
        }
        catch (ExecutionException e) {
            throw (Exception)e.getCause();
        }
    }

    public static <R> void asyncComplete(R value) {
        Async.CUR_COMPLETABLE_FUTURE.set(CompletableFuture.completedFuture(value));
    }

    public static <R> void asyncCompleteWith(CompletableFuture<R> completableFuture) {
        Async.CUR_COMPLETABLE_FUTURE.set(completableFuture);
    }

    public static CompletableFuture<Object> getAsyncUtilCompletableFuture() {
        assert (Async.CUR_COMPLETABLE_FUTURE.get() != null);
        return Async.CUR_COMPLETABLE_FUTURE.get();
    }

    public static void asyncThrowException(Throwable e) {
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(Async.warpCompletionException(e));
        Async.CUR_COMPLETABLE_FUTURE.set(result);
    }

    public static <T, R> void asyncApply(ApplyFunction<T, R> function) {
        CompletableFuture<Object> completableFuture = Async.CUR_COMPLETABLE_FUTURE.get();
        assert (completableFuture != null);
        CompletableFuture<R> result = function.apply(completableFuture);
        Async.CUR_COMPLETABLE_FUTURE.set(result);
    }

    public static <T, R> void asyncApplyUseExecutor(ApplyFunction<T, R> function, Executor executor) {
        CompletableFuture<Object> completableFuture = Async.CUR_COMPLETABLE_FUTURE.get();
        assert (completableFuture != null);
        CompletableFuture<R> result = function.apply(completableFuture, executor);
        Async.CUR_COMPLETABLE_FUTURE.set(result);
    }

    public static <R> void asyncTry(AsyncRun<R> asyncRun) {
        try {
            CompletableFuture<R> result = asyncRun.async();
            Async.CUR_COMPLETABLE_FUTURE.set(result);
        }
        catch (Throwable e) {
            AsyncUtil.asyncThrowException(e);
        }
    }

    public static <R, E extends Throwable> void asyncCatch(CatchFunction<R, E> function, Class<E> eClass) {
        CompletableFuture<Object> completableFuture = Async.CUR_COMPLETABLE_FUTURE.get();
        assert (completableFuture != null);
        CompletableFuture<Object> result = function.apply(completableFuture, eClass);
        Async.CUR_COMPLETABLE_FUTURE.set(result);
    }

    public static <R> void asyncFinally(FinallyFunction<R> function) {
        CompletableFuture<Object> completableFuture = Async.CUR_COMPLETABLE_FUTURE.get();
        assert (completableFuture != null);
        CompletableFuture<Object> result = function.apply(completableFuture);
        Async.CUR_COMPLETABLE_FUTURE.set(result);
    }

    public static <I, R> void asyncForEach(Iterator<I> forEach, AsyncBiFunction<AsyncForEachRun<I, R>, I, R> asyncDo) {
        AsyncForEachRun asyncForEachRun = new AsyncForEachRun();
        asyncForEachRun.forEach(forEach).asyncDo(asyncDo).run();
    }

    public static <I, R, P> void asyncCurrent(Collection<I> collection, AsyncApplyFunction<I, R> asyncDo, Function<CompletableFuture<R>[], P> then) {
        CompletableFuture[] completableFutures = new CompletableFuture[collection.size()];
        int i = 0;
        for (I entry : collection) {
            CompletableFuture<Object> future = null;
            try {
                future = asyncDo.async(entry);
            }
            catch (IOException e) {
                future = new CompletableFuture();
                future.completeExceptionally(Async.warpCompletionException(e));
            }
            completableFutures[i++] = future;
        }
        CompletionStage result = CompletableFuture.allOf(completableFutures).handle((unused, throwable) -> then.apply(completableFutures));
        Async.CUR_COMPLETABLE_FUTURE.set((CompletableFuture<Object>)result);
    }

    public static CompletableFuture<Object> getCompletableFuture() {
        return Async.CUR_COMPLETABLE_FUTURE.get();
    }
}

