/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async.utils;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.Async;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncBiFunction;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncRun;

public class AsyncForEachRun<I, R>
implements AsyncRun<R> {
    private boolean shouldBreak = false;
    private Iterator<I> iterator;
    private AsyncBiFunction<AsyncForEachRun<I, R>, I, R> asyncDoOnce;

    @Override
    public void run() {
        CompletableFuture<Object> result;
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.setCurCompletableFuture(CompletableFuture.completedFuture(null));
            return;
        }
        try {
            result = this.doOnce(this.iterator.next());
        }
        catch (IOException ioe) {
            result = new CompletableFuture();
            result.completeExceptionally(Async.warpCompletionException(ioe));
        }
        this.setCurCompletableFuture(result);
    }

    private CompletableFuture<R> doOnce(I element) throws IOException {
        CompletableFuture<R> completableFuture = this.asyncDoOnce.async(this, element);
        return completableFuture.thenCompose(res -> {
            if (this.shouldBreak || !this.iterator.hasNext()) {
                return completableFuture;
            }
            try {
                return this.doOnce(this.iterator.next());
            }
            catch (IOException e) {
                throw Async.warpCompletionException(e);
            }
        });
    }

    public void breakNow() {
        this.shouldBreak = true;
    }

    public AsyncForEachRun<I, R> forEach(Iterator<I> forEach) {
        this.iterator = forEach;
        return this;
    }

    public AsyncForEachRun<I, R> asyncDo(AsyncBiFunction<AsyncForEachRun<I, R>, I, R> asyncDo) {
        this.asyncDoOnce = asyncDo;
        return this;
    }
}

