/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async.utils;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.Async;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.CatchFunction;

@FunctionalInterface
public interface AsyncCatchFunction<R, E extends Throwable>
extends CatchFunction<R, E> {
    public void applyAsync(R var1, E var2) throws IOException;

    @Override
    default public R apply(R r, E e) throws IOException {
        this.applyAsync(r, e);
        return this.result();
    }

    default public CompletableFuture<R> async(R r, E e) throws IOException {
        this.applyAsync(r, e);
        CompletableFuture completableFuture = this.getCurCompletableFuture();
        if (!1.$assertionsDisabled && completableFuture == null) {
            throw new AssertionError();
        }
        return completableFuture;
    }

    @Override
    default public CompletableFuture<R> apply(CompletableFuture<R> in, Class<E> eClazz) {
        return ((CompletableFuture)in.handle((r, e) -> {
            if (e == null) {
                return in;
            }
            Throwable readException = Async.unWarpCompletionException(e);
            if (eClazz.isInstance(readException)) {
                try {
                    return this.async(r, readException);
                }
                catch (IOException ex) {
                    throw Async.warpCompletionException(ex);
                }
            }
            throw Async.warpCompletionException(e);
        })).thenCompose(result -> result);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

