/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async.utils;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.ApplyFunction;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.Async;

@FunctionalInterface
public interface AsyncApplyFunction<T, R>
extends ApplyFunction<T, R> {
    public void applyAsync(T var1) throws IOException;

    @Override
    default public R apply(T t) throws IOException {
        this.applyAsync(t);
        return this.result();
    }

    default public CompletableFuture<R> async(T t) throws IOException {
        this.applyAsync(t);
        CompletableFuture completableFuture = this.getCurCompletableFuture();
        if (!1.$assertionsDisabled && completableFuture == null) {
            throw new AssertionError();
        }
        return completableFuture;
    }

    @Override
    default public CompletableFuture<R> apply(CompletableFuture<T> in) {
        return in.thenCompose(t -> {
            try {
                return this.async(t);
            }
            catch (IOException e) {
                throw Async.warpCompletionException(e);
            }
        });
    }

    @Override
    default public CompletableFuture<R> apply(CompletableFuture<T> in, Executor executor) {
        return in.thenComposeAsync(t -> {
            try {
                return this.async(t);
            }
            catch (IOException e) {
                throw Async.warpCompletionException(e);
            }
        }, executor);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

