/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async.utils;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;

public interface Async<R> {
    public static final ThreadLocal<CompletableFuture<Object>> CUR_COMPLETABLE_FUTURE;

    default public <T> void setCurCompletableFuture(CompletableFuture<T> completableFuture) {
        CUR_COMPLETABLE_FUTURE.set(completableFuture);
    }

    default public CompletableFuture<R> getCurCompletableFuture() {
        return CUR_COMPLETABLE_FUTURE.get();
    }

    default public R result() throws IOException {
        try {
            CompletableFuture<Object> completableFuture = CUR_COMPLETABLE_FUTURE.get();
            if (!1.$assertionsDisabled && completableFuture == null) {
                throw new AssertionError();
            }
            return (R)completableFuture.get();
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(e);
        }
    }

    public static Throwable unWarpCompletionException(Throwable e) {
        if (e instanceof CompletionException && e.getCause() != null) {
            return e.getCause();
        }
        return e;
    }

    public static CompletionException warpCompletionException(Throwable e) {
        if (e instanceof CompletionException) {
            return (CompletionException)e;
        }
        return new CompletionException(e);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        CUR_COMPLETABLE_FUTURE = new ThreadLocal();
    }
}

