/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async.utils;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.Async;

@FunctionalInterface
public interface ApplyFunction<T, R>
extends Async<R> {
    public R apply(T var1) throws IOException;

    default public CompletableFuture<R> apply(CompletableFuture<T> in) {
        return in.thenApply(t -> {
            try {
                return this.apply(t);
            }
            catch (IOException e) {
                throw Async.warpCompletionException(e);
            }
        });
    }

    default public CompletableFuture<R> apply(CompletableFuture<T> in, Executor executor) {
        return in.thenApplyAsync(t -> {
            try {
                return this.apply(t);
            }
            catch (IOException e) {
                throw Async.warpCompletionException(e);
            }
        }, executor);
    }
}

