/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterStoragePolicy;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class RouterAsyncStoragePolicy
extends RouterStoragePolicy {
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;

    public RouterAsyncStoragePolicy(RouterRpcServer server) {
        super(server);
        this.rpcServer = server;
        this.rpcClient = this.rpcServer.getRPCClient();
    }

    @Override
    public BlockStoragePolicy getStoragePolicy(String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, true);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path, false, false);
        RemoteMethod method = new RemoteMethod("getStoragePolicy", new Class[]{String.class}, new RemoteParam());
        this.rpcClient.invokeSequential(locations, method);
        return AsyncUtil.asyncReturn(BlockStoragePolicy.class);
    }

    @Override
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getStoragePolicies");
        this.rpcServer.invokeAtAvailableNsAsync(method, BlockStoragePolicy[].class);
        return AsyncUtil.asyncReturn(BlockStoragePolicy[].class);
    }
}

