/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshotStatus;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.RouterSnapshot;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class RouterAsyncSnapshot
extends RouterSnapshot {
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;
    private final ActiveNamenodeResolver namenodeResolver;

    public RouterAsyncSnapshot(RouterRpcServer server) {
        super(server);
        this.rpcServer = server;
        this.rpcClient = this.rpcServer.getRPCClient();
        this.namenodeResolver = this.rpcServer.getNamenodeResolver();
    }

    @Override
    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(snapshotRoot, true, false);
        RemoteMethod method = new RemoteMethod("createSnapshot", new Class[]{String.class, String.class}, new RemoteParam(), snapshotName);
        if (this.rpcServer.isInvokeConcurrent(snapshotRoot)) {
            this.rpcClient.invokeConcurrent(locations, method, String.class);
            AsyncUtil.asyncApply(results -> {
                Map.Entry firstelement = results.entrySet().iterator().next();
                RemoteLocation loc = (RemoteLocation)firstelement.getKey();
                String result = (String)firstelement.getValue();
                return result.replaceFirst(loc.getDest(), loc.getSrc());
            });
        } else {
            this.rpcClient.invokeSequential(method, locations, String.class, null);
            AsyncUtil.asyncApply(response -> {
                RemoteLocation loc = (RemoteLocation)response.getLocation();
                String invokedResult = (String)response.getResult();
                return invokedResult.replaceFirst(loc.getDest(), loc.getSrc());
            });
        }
        return AsyncUtil.asyncReturn(String.class);
    }

    @Override
    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getSnapshottableDirListing");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, SnapshottableDirectoryStatus[].class);
        AsyncUtil.asyncApply(ret -> RouterRpcServer.merge(ret, SnapshottableDirectoryStatus.class));
        return AsyncUtil.asyncReturn(SnapshottableDirectoryStatus[].class);
    }

    @Override
    public SnapshotStatus[] getSnapshotListing(String snapshotRoot) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(snapshotRoot, true, false);
        RemoteMethod remoteMethod = new RemoteMethod("getSnapshotListing", new Class[]{String.class}, new RemoteParam());
        if (this.rpcServer.isInvokeConcurrent(snapshotRoot)) {
            this.rpcClient.invokeConcurrent(locations, remoteMethod, true, false, SnapshotStatus[].class);
            AsyncUtil.asyncApply(ret -> {
                SnapshotStatus[] response = (SnapshotStatus[])ret.values().iterator().next();
                String src = ((RemoteLocation)ret.keySet().iterator().next()).getSrc();
                String dst = ((RemoteLocation)ret.keySet().iterator().next()).getDest();
                for (SnapshotStatus s : response) {
                    String mountPath = DFSUtil.bytes2String((byte[])s.getParentFullPath()).replaceFirst(src, dst);
                    s.setParentFullPath(DFSUtil.string2Bytes((String)mountPath));
                }
                return response;
            });
        } else {
            this.rpcClient.invokeSequential(remoteMethod, locations, SnapshotStatus[].class, null);
            AsyncUtil.asyncApply(invokedResponse -> {
                SnapshotStatus[] response;
                RemoteLocation loc = (RemoteLocation)invokedResponse.getLocation();
                for (SnapshotStatus s : response = (SnapshotStatus[])invokedResponse.getResult()) {
                    String mountPath = DFSUtil.bytes2String((byte[])s.getParentFullPath()).replaceFirst(loc.getDest(), loc.getSrc());
                    s.setParentFullPath(DFSUtil.string2Bytes((String)mountPath));
                }
                return response;
            });
        }
        return AsyncUtil.asyncReturn(SnapshotStatus[].class);
    }

    @Override
    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(snapshotRoot, true, false);
        RemoteMethod remoteMethod = new RemoteMethod("getSnapshotDiffReport", new Class[]{String.class, String.class, String.class}, new RemoteParam(), earlierSnapshotName, laterSnapshotName);
        if (this.rpcServer.isInvokeConcurrent(snapshotRoot)) {
            this.rpcClient.invokeConcurrent(locations, remoteMethod, true, false, SnapshotDiffReport.class);
            AsyncUtil.asyncApply(ret -> (SnapshotDiffReport)ret.values().iterator().next());
            return AsyncUtil.asyncReturn(SnapshotDiffReport.class);
        }
        return this.rpcClient.invokeSequential(locations, remoteMethod, SnapshotDiffReport.class, null);
    }

    @Override
    public SnapshotDiffReportListing getSnapshotDiffReportListing(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName, byte[] startPath, int index) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(snapshotRoot, true, false);
        Class[] params = new Class[]{String.class, String.class, String.class, byte[].class, Integer.TYPE};
        RemoteMethod remoteMethod = new RemoteMethod("getSnapshotDiffReportListing", params, new RemoteParam(), earlierSnapshotName, laterSnapshotName, startPath, index);
        if (this.rpcServer.isInvokeConcurrent(snapshotRoot)) {
            this.rpcClient.invokeConcurrent(locations, remoteMethod, false, false, SnapshotDiffReportListing.class);
            AsyncUtil.asyncApply(ret -> {
                Collection listings = ret.values();
                SnapshotDiffReportListing listing0 = (SnapshotDiffReportListing)listings.iterator().next();
                return listing0;
            });
            return AsyncUtil.asyncReturn(SnapshotDiffReportListing.class);
        }
        return this.rpcClient.invokeSequential(locations, remoteMethod, SnapshotDiffReportListing.class, null);
    }
}

