/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RouterNamenodeProtocol;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;

public class RouterAsyncNamenodeProtocol
extends RouterNamenodeProtocol {
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;

    public RouterAsyncNamenodeProtocol(RouterRpcServer server) {
        super(server);
        this.rpcServer = server;
        this.rpcClient = this.rpcServer.getRPCClient();
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size, long minBlockSize, long hotBlockTimeInterval, StorageType storageType) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        this.rpcServer.getDatanodeStorageReportMapAsync(HdfsConstants.DatanodeReportType.ALL);
        AsyncUtil.asyncApply(map -> {
            String nsId = null;
            for (Map.Entry entry : map.entrySet()) {
                DatanodeStorageReport[] dns;
                for (DatanodeStorageReport dn : dns = (DatanodeStorageReport[])entry.getValue()) {
                    DatanodeInfo dnInfo = dn.getDatanodeInfo();
                    if (!dnInfo.getDatanodeUuid().equals(datanode.getDatanodeUuid())) continue;
                    nsId = (String)entry.getKey();
                    break;
                }
                if (nsId == null) continue;
                break;
            }
            if (nsId != null) {
                RemoteMethod method = new RemoteMethod(NamenodeProtocol.class, "getBlocks", new Class[]{DatanodeInfo.class, Long.TYPE, Long.TYPE, Long.TYPE, StorageType.class}, datanode, size, minBlockSize, hotBlockTimeInterval, storageType);
                this.rpcClient.invokeSingle(nsId, method, BlocksWithLocations.class);
            } else {
                AsyncUtil.asyncComplete(null);
            }
        });
        return AsyncUtil.asyncReturn(BlocksWithLocations.class);
    }

    @Override
    public ExportedBlockKeys getBlockKeys() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod(NamenodeProtocol.class, "getBlockKeys");
        this.rpcServer.invokeAtAvailableNsAsync(method, ExportedBlockKeys.class);
        return AsyncUtil.asyncReturn(ExportedBlockKeys.class);
    }

    @Override
    public long getTransactionID() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod(NamenodeProtocol.class, "getTransactionID");
        this.rpcServer.invokeAtAvailableNsAsync(method, Long.TYPE);
        return AsyncUtil.asyncReturn(Long.class);
    }

    @Override
    public long getMostRecentCheckpointTxId() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod(NamenodeProtocol.class, "getMostRecentCheckpointTxId");
        this.rpcServer.invokeAtAvailableNsAsync(method, Long.TYPE);
        return AsyncUtil.asyncReturn(Long.class);
    }

    @Override
    public long getMostRecentNameNodeFileTxId(NNStorage.NameNodeFile nnf) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod(NamenodeProtocol.class, "getMostRecentNameNodeFileTxId", new Class[]{NNStorage.NameNodeFile.class}, nnf);
        this.rpcServer.invokeAtAvailableNsAsync(method, Long.TYPE);
        return AsyncUtil.asyncReturn(Long.class);
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod(NamenodeProtocol.class, "versionRequest");
        this.rpcServer.invokeAtAvailableNsAsync(method, NamespaceInfo.class);
        return AsyncUtil.asyncReturn(NamespaceInfo.class);
    }
}

