/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.ReplicatedBlockStats;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.RouterResolveException;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.NoLocationException;
import org.apache.hadoop.hdfs.server.federation.router.RemoteLocationContext;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.RemoteResult;
import org.apache.hadoop.hdfs.server.federation.router.RouterClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.RouterFederationRename;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterAsyncClientProtocol
extends RouterClientProtocol {
    private static final Logger LOG = LoggerFactory.getLogger((String)RouterAsyncClientProtocol.class.getName());
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;
    private final RouterFederationRename rbfRename;
    private final FileSubclusterResolver subclusterResolver;
    private final ActiveNamenodeResolver namenodeResolver;
    private final boolean allowPartialList;
    private long mountStatusTimeOut;
    private final boolean defaultNameServiceEnabled;
    private String superUser;
    private final String superGroup;
    private volatile FsServerDefaults serverDefaults;

    public RouterAsyncClientProtocol(Configuration conf, RouterRpcServer rpcServer) {
        super(conf, rpcServer);
        this.rpcServer = rpcServer;
        this.rpcClient = rpcServer.getRPCClient();
        this.rbfRename = this.getRbfRename();
        this.subclusterResolver = this.getSubclusterResolver();
        this.namenodeResolver = this.getNamenodeResolver();
        this.allowPartialList = this.isAllowPartialList();
        this.mountStatusTimeOut = this.getMountStatusTimeOut();
        this.superUser = this.getSuperUser();
        this.superGroup = this.getSuperGroup();
        this.defaultNameServiceEnabled = conf.getBoolean("dfs.federation.router.default.nameservice.enable", true);
    }

    @Override
    public FsServerDefaults getServerDefaults() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        long now = Time.monotonicNow();
        if (this.serverDefaults == null || now - this.getServerDefaultsLastUpdate() > this.getServerDefaultsValidityPeriod()) {
            RemoteMethod method = new RemoteMethod("getServerDefaults");
            this.rpcServer.invokeAtAvailableNsAsync(method, FsServerDefaults.class);
            AsyncUtil.asyncApply(o -> {
                this.serverDefaults = (FsServerDefaults)o;
                this.setServerDefaultsLastUpdate(now);
                return this.serverDefaults;
            });
        } else {
            AsyncUtil.asyncComplete(this.serverDefaults);
        }
        return AsyncUtil.asyncReturn(FsServerDefaults.class);
    }

    @Override
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions, String ecPolicyName, String storagePolicy) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        if (createParent && this.rpcServer.isPathAll(src)) {
            int index = src.lastIndexOf("/");
            String parent = src.substring(0, index);
            LOG.debug("Creating {} requires creating parent {}", (Object)src, (Object)parent);
            FsPermission parentPermissions = RouterAsyncClientProtocol.getParentPermission(masked);
            this.mkdirs(parent, parentPermissions, createParent);
            AsyncUtil.asyncApply(success -> {
                if (!success.booleanValue()) {
                    LOG.error("Couldn't create parents for {}", (Object)src);
                }
                return success;
            });
        }
        RemoteMethod method = new RemoteMethod("create", new Class[]{String.class, FsPermission.class, String.class, EnumSetWritable.class, Boolean.TYPE, Short.TYPE, Long.TYPE, CryptoProtocolVersion[].class, String.class, String.class}, new RemoteParam(), masked, clientName, flag, createParent, replication, blockSize, supportedVersions, ecPolicyName, storagePolicy);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteLocation[] createLocation = new RemoteLocation[1];
        AsyncUtil.asyncTry(() -> {
            this.rpcServer.getCreateLocationAsync(src, locations);
            AsyncUtil.asyncApply(remoteLocation -> {
                createLocation[0] = remoteLocation;
                this.rpcClient.invokeSingle((RemoteLocationContext)remoteLocation, method, HdfsFileStatus.class);
                AsyncUtil.asyncApply(status -> {
                    status.setNamespace(remoteLocation.getNameserviceId());
                    return status;
                });
            });
        });
        AsyncUtil.asyncCatch((o, ioe) -> {
            List<RemoteLocation> newLocations = this.checkFaultTolerantRetry(method, src, (IOException)ioe, createLocation[0], locations);
            this.rpcClient.invokeSequential(newLocations, method, HdfsFileStatus.class, null);
        }, IOException.class);
        return AsyncUtil.asyncReturn(HdfsFileStatus.class);
    }

    @Override
    public LastBlockWithStatus append(String src, String clientName, EnumSetWritable<CreateFlag> flag) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("append", new Class[]{String.class, String.class, EnumSetWritable.class}, new RemoteParam(), clientName, flag);
        this.rpcClient.invokeSequential(method, locations, LastBlockWithStatus.class, null);
        AsyncUtil.asyncApply(result -> {
            LastBlockWithStatus lbws = (LastBlockWithStatus)result.getResult();
            lbws.getFileStatus().setNamespace(((RemoteLocationContext)result.getLocation()).getNameserviceId());
            return lbws;
        });
        return AsyncUtil.asyncReturn(LastBlockWithStatus.class);
    }

    @Override
    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> srcLocations = this.rpcServer.getLocationsForPath(src, true, false);
        List<RemoteLocation> dstLocations = this.rpcServer.getLocationsForPath(dst, false, false);
        LinkedList<RemoteLocation> locs = new LinkedList<RemoteLocation>(srcLocations);
        RemoteParam dstParam = this.getRenameDestinations(locs, dstLocations);
        if (locs.isEmpty()) {
            AsyncUtil.asyncComplete(this.rbfRename.routerFedRename(src, dst, srcLocations, dstLocations));
            return AsyncUtil.asyncReturn(Boolean.class);
        }
        RemoteMethod method = new RemoteMethod("rename", new Class[]{String.class, String.class}, new RemoteParam(), dstParam);
        this.isMultiDestDirectory(src);
        AsyncUtil.asyncApply(isMultiDestDirectory -> {
            if (isMultiDestDirectory.booleanValue()) {
                if (locs.size() != srcLocations.size()) {
                    throw new IOException("Rename of " + src + " to " + dst + " is not allowed. The number of remote locations for both source and target should be same.");
                }
                this.rpcClient.invokeAll(locs, method);
            } else {
                this.rpcClient.invokeSequential(locs, method, Boolean.class, (Object)Boolean.TRUE);
            }
        });
        return AsyncUtil.asyncReturn(Boolean.class);
    }

    @Override
    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> srcLocations = this.rpcServer.getLocationsForPath(src, true, false);
        List<RemoteLocation> dstLocations = this.rpcServer.getLocationsForPath(dst, false, false);
        LinkedList<RemoteLocation> locs = new LinkedList<RemoteLocation>(srcLocations);
        RemoteParam dstParam = this.getRenameDestinations(locs, dstLocations);
        if (locs.isEmpty()) {
            this.rbfRename.routerFedRename(src, dst, srcLocations, dstLocations);
            return;
        }
        RemoteMethod method = new RemoteMethod("rename2", new Class[]{String.class, String.class, options.getClass()}, new RemoteParam(), dstParam, options);
        this.isMultiDestDirectory(src);
        AsyncUtil.asyncApply(isMultiDestDirectory -> {
            if (isMultiDestDirectory.booleanValue()) {
                if (locs.size() != srcLocations.size()) {
                    throw new IOException("Rename of " + src + " to " + dst + " is not allowed. The number of remote locations for both source and target should be same.");
                }
                this.rpcClient.invokeConcurrent(locs, method);
            } else {
                this.rpcClient.invokeSequential(locs, method, null, null);
            }
        });
    }

    @Override
    public void concat(String trg, String[] src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        this.getFileRemoteLocation(trg);
        AsyncUtil.asyncApply(targetDestination -> {
            if (targetDestination == null) {
                throw new IOException("Cannot find target file - " + trg);
            }
            String targetNameService = targetDestination.getNameserviceId();
            String[] sourceDestinations = new String[src.length];
            int[] index = new int[1];
            AsyncUtil.asyncForEach(Arrays.stream(src).iterator(), (forEachRun, sourceFile) -> {
                this.getFileRemoteLocation((String)sourceFile);
                AsyncUtil.asyncApply(srcLocation -> {
                    if (srcLocation == null) {
                        throw new IOException("Cannot find source file - " + sourceFile);
                    }
                    int n = index[0];
                    index[0] = n + 1;
                    sourceDestinations[n] = srcLocation.getDest();
                    if (!targetNameService.equals(srcLocation.getNameserviceId())) {
                        throw new IOException("Cannot concatenate source file " + sourceFile + " because it is located in a different namespace with nameservice " + srcLocation.getNameserviceId() + " from the target file with nameservice " + targetNameService);
                    }
                    return null;
                });
            });
            AsyncUtil.asyncApply(o -> {
                RemoteMethod method = new RemoteMethod("concat", new Class[]{String.class, String[].class}, targetDestination.getDest(), sourceDestinations);
                this.rpcClient.invokeSingle((RemoteLocationContext)targetDestination, method, Void.class);
            });
        });
    }

    @Override
    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false);
        RemoteMethod method = new RemoteMethod("mkdirs", new Class[]{String.class, FsPermission.class, Boolean.TYPE}, new RemoteParam(), masked, createParent);
        if (this.rpcServer.isPathAll(src)) {
            return this.rpcClient.invokeAll(locations, method);
        }
        if (locations.size() > 1) {
            AsyncUtil.asyncTry(() -> {
                this.getFileInfo(src);
                AsyncUtil.asyncApply(fileStatus -> {
                    if (fileStatus != null) {
                        return true;
                    }
                    return false;
                });
            });
            AsyncUtil.asyncCatch((ret, ioe) -> {
                LOG.error("Error getting file info for {} while proxying mkdirs: {}", (Object)src, (Object)ioe.getMessage());
                return false;
            }, IOException.class);
            AsyncUtil.asyncApply(ret -> {
                if (!ret.booleanValue()) {
                    RemoteLocation firstLocation = (RemoteLocation)locations.get(0);
                    AsyncUtil.asyncTry(() -> this.rpcClient.invokeSingle(firstLocation, method, Boolean.class));
                    AsyncUtil.asyncCatch((o, ioe) -> {
                        List<RemoteLocation> newLocations = this.checkFaultTolerantRetry(method, src, (IOException)ioe, firstLocation, locations);
                        this.rpcClient.invokeSequential(newLocations, method, Boolean.class, (Object)Boolean.TRUE);
                    }, IOException.class);
                } else {
                    AsyncUtil.asyncComplete(ret);
                }
            });
        } else {
            RemoteLocation firstLocation = locations.get(0);
            AsyncUtil.asyncTry(() -> this.rpcClient.invokeSingle(firstLocation, method, Boolean.class));
            AsyncUtil.asyncCatch((o, ioe) -> {
                List<RemoteLocation> newLocations = this.checkFaultTolerantRetry(method, src, (IOException)ioe, firstLocation, locations);
                this.rpcClient.invokeSequential(newLocations, method, Boolean.class, (Object)Boolean.TRUE);
            }, IOException.class);
        }
        return AsyncUtil.asyncReturn(Boolean.class);
    }

    @Override
    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RouterClientProtocol.GetListingComparator comparator = RouterClientProtocol.getComparator();
        this.getListingInt(src, startAfter, needLocation);
        AsyncUtil.asyncApply(listings -> {
            List<String> children;
            TreeMap<byte[], HdfsFileStatus> nnListing = new TreeMap<byte[], HdfsFileStatus>(comparator);
            int totalRemainingEntries = 0;
            int[] remainingEntries = new int[]{0};
            boolean namenodeListingExists = false;
            byte[] lastName = null;
            if (listings != null) {
                DirectoryListing listing;
                for (RemoteResult result : listings) {
                    if (result.hasException()) {
                        IOException ioe = result.getException();
                        if (ioe instanceof FileNotFoundException) {
                            RemoteLocation location = (RemoteLocation)result.getLocation();
                            LOG.debug("Cannot get listing from {}", (Object)location);
                            continue;
                        }
                        if (this.allowPartialList) continue;
                        throw ioe;
                    }
                    if (result.getResult() == null) continue;
                    listing = (DirectoryListing)result.getResult();
                    totalRemainingEntries += listing.getRemainingEntries();
                    HdfsFileStatus[] partialListing = listing.getPartialListing();
                    int length = partialListing.length;
                    if (length <= 0) continue;
                    HdfsFileStatus lastLocalEntry = partialListing[length - 1];
                    byte[] lastLocalName = lastLocalEntry.getLocalNameInBytes();
                    if (lastName != null && comparator.compare(lastName, lastLocalName) <= 0) continue;
                    lastName = lastLocalName;
                }
                for (RemoteResult result : listings) {
                    listing = (DirectoryListing)result.getResult();
                    if (listing == null) continue;
                    namenodeListingExists = true;
                    for (HdfsFileStatus file : listing.getPartialListing()) {
                        byte[] filename = file.getLocalNameInBytes();
                        if (totalRemainingEntries > 0 && comparator.compare(filename, lastName) > 0) {
                            remainingEntries[0] = remainingEntries[0] + 1;
                            continue;
                        }
                        nnListing.put(filename, file);
                    }
                    remainingEntries[0] = remainingEntries[0] + listing.getRemainingEntries();
                }
            }
            if ((children = this.subclusterResolver.getMountPoints(src)) != null) {
                Map<String, Long> dates = this.getMountPointDates(src);
                byte[] finalLastName = lastName;
                AsyncUtil.asyncForEach(children.iterator(), (forEachRun, child) -> {
                    long date = 0L;
                    if (dates != null && dates.containsKey(child)) {
                        date = (Long)dates.get(child);
                    }
                    Path childPath = new Path(src, child);
                    this.getMountPointStatus(childPath.toString(), 0, date);
                    AsyncUtil.asyncApply(dirStatus -> {
                        byte[] bChild = DFSUtil.string2Bytes((String)child);
                        if (finalLastName == null) {
                            nnListing.put(bChild, (HdfsFileStatus)dirStatus);
                        } else if (RouterAsyncClientProtocol.shouldAddMountPoint(bChild, finalLastName, startAfter, remainingEntries[0])) {
                            nnListing.put(bChild, (HdfsFileStatus)dirStatus);
                        }
                        return null;
                    });
                });
                boolean finalNamenodeListingExists = namenodeListingExists;
                AsyncUtil.asyncApply(o -> {
                    if (nnListing.size() > 0) {
                        byte[] lastListing = (byte[])nnListing.lastKey();
                        for (int i = 0; i < children.size(); ++i) {
                            byte[] bChild = DFSUtil.string2Bytes((String)((String)children.get(i)));
                            if (comparator.compare(bChild, lastListing) <= 0) continue;
                            remainingEntries[0] = remainingEntries[0] + (children.size() - i);
                            break;
                        }
                    }
                    return finalNamenodeListingExists;
                });
            } else {
                AsyncUtil.asyncComplete(namenodeListingExists);
            }
            AsyncUtil.asyncApply(exists -> {
                if (!exists.booleanValue() && nnListing.size() == 0 && children == null) {
                    return null;
                }
                HdfsFileStatus[] combinedData = new HdfsFileStatus[nnListing.size()];
                combinedData = nnListing.values().toArray(combinedData);
                return new DirectoryListing(combinedData, remainingEntries[0]);
            });
        });
        return AsyncUtil.asyncReturn(DirectoryListing.class);
    }

    @Override
    protected List<RemoteResult<RemoteLocation, DirectoryListing>> getListingInt(String src, byte[] startAfter, boolean needLocation) throws IOException {
        try {
            List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
            if (locations.isEmpty()) {
                AsyncUtil.asyncComplete(new ArrayList());
                return AsyncUtil.asyncReturn(List.class);
            }
            RemoteMethod method = new RemoteMethod("getListing", new Class[]{String.class, startAfter.getClass(), Boolean.TYPE}, new RemoteParam(), startAfter, needLocation);
            this.rpcClient.invokeConcurrent(locations, method, false, -1L, DirectoryListing.class);
        }
        catch (RouterResolveException | NoLocationException e) {
            LOG.debug("Cannot get locations for {}, {}.", (Object)src, (Object)e.getMessage());
            AsyncUtil.asyncComplete(new ArrayList());
        }
        return AsyncUtil.asyncReturn(List.class);
    }

    @Override
    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        IOException[] noLocationException = new IOException[1];
        AsyncUtil.asyncTry(() -> {
            List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
            RemoteMethod method = new RemoteMethod("getFileInfo", new Class[]{String.class}, new RemoteParam());
            if (this.rpcServer.isPathAll(src)) {
                this.getFileInfoAll(locations, method);
            } else {
                this.rpcClient.invokeSequential(locations, method, HdfsFileStatus.class, null);
            }
        });
        AsyncUtil.asyncCatch((o, e) -> {
            if (!(e instanceof NoLocationException) && !(e instanceof RouterResolveException)) {
                throw e;
            }
            noLocationException[0] = e;
            return null;
        }, IOException.class);
        AsyncUtil.asyncApply(ret -> {
            if (ret == null) {
                List<String> children = this.subclusterResolver.getMountPoints(src);
                if (children != null && !children.isEmpty()) {
                    Map<String, Long> dates = this.getMountPointDates(src);
                    long date = 0L;
                    if (dates != null && dates.containsKey(src)) {
                        date = dates.get(src);
                    }
                    this.getMountPointStatus(src, children.size(), date, false);
                } else if (children != null) {
                    this.getMountPointStatus(src, 0, 0L, false);
                } else {
                    if (noLocationException[0] != null) {
                        throw noLocationException[0];
                    }
                    AsyncUtil.asyncComplete(null);
                    return;
                }
                AsyncUtil.asyncApply(result -> {
                    if (result == null && noLocationException[0] != null) {
                        throw noLocationException[0];
                    }
                    return result;
                });
            } else {
                AsyncUtil.asyncComplete(ret);
            }
        });
        return AsyncUtil.asyncReturn(HdfsFileStatus.class);
    }

    @Override
    public RemoteLocation getFileRemoteLocation(String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path, false, false);
        if (locations.size() == 1) {
            AsyncUtil.asyncComplete(locations.get(0));
            return AsyncUtil.asyncReturn(RemoteLocation.class);
        }
        AsyncUtil.asyncForEach(locations.iterator(), (forEachRun, location) -> {
            RemoteMethod method = new RemoteMethod("getFileInfo", new Class[]{String.class}, new RemoteParam());
            this.rpcClient.invokeSequential(Collections.singletonList(location), method, HdfsFileStatus.class, null);
            AsyncUtil.asyncApply(ret -> {
                if (ret != null) {
                    forEachRun.breakNow();
                    return location;
                }
                return null;
            });
        });
        return AsyncUtil.asyncReturn(RemoteLocation.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HdfsFileStatus getMountPointStatus(String name, int childrenNum, long date, boolean setPath) {
        long modTime = date;
        long accessTime = date;
        FsPermission[] permission = new FsPermission[]{FsPermission.getDirDefault()};
        String[] owner = new String[]{this.superUser};
        String[] group = new String[]{this.superGroup};
        int[] childrenNums = new int[]{childrenNum};
        EnumSet[] flags = new EnumSet[]{EnumSet.noneOf(HdfsFileStatus.Flags.class)};
        long inodeId = 0L;
        HdfsFileStatus.Builder builder = new HdfsFileStatus.Builder();
        if (setPath) {
            Path path = new Path(name);
            String nameStr = path.getName();
            builder.path(DFSUtil.string2Bytes((String)nameStr));
        }
        if (this.getSubclusterResolver() instanceof MountTableResolver) {
            AsyncUtil.asyncTry(() -> {
                MountTableResolver mountTable = (MountTableResolver)this.subclusterResolver;
                Object mName = name.startsWith("/") ? name : "/" + name;
                MountTable entry = mountTable.getMountPoint((String)mName);
                if (entry != null) {
                    permission[0] = entry.getMode();
                    owner[0] = entry.getOwnerName();
                    group[0] = entry.getGroupName();
                    RemoteMethod method = new RemoteMethod("getFileInfo", new Class[]{String.class}, new RemoteParam());
                    this.getFileInfoAll(entry.getDestinations(), method, this.mountStatusTimeOut);
                    AsyncUtil.asyncApply(fInfo -> {
                        if (fInfo != null) {
                            permission[0] = fInfo.getPermission();
                            owner[0] = fInfo.getOwner();
                            group[0] = fInfo.getGroup();
                            childrenNums[0] = fInfo.getChildrenNum();
                            flags[0] = DFSUtil.getFlags((boolean)fInfo.isEncrypted(), (boolean)fInfo.isErasureCoded(), (boolean)fInfo.isSnapshotEnabled(), (boolean)fInfo.hasAcl());
                        }
                        return builder.isdir(true).mtime(modTime).atime(accessTime).perm(permission[0]).owner(owner[0]).group(group[0]).symlink(new byte[0]).fileId(inodeId).children(childrenNums[0]).flags(flags[0]).build();
                    });
                } else {
                    AsyncUtil.asyncComplete(builder.isdir(true).mtime(modTime).atime(accessTime).perm(permission[0]).owner(owner[0]).group(group[0]).symlink(new byte[0]).fileId(inodeId).children(childrenNums[0]).flags(flags[0]).build());
                }
            });
            AsyncUtil.asyncCatch((status, e) -> {
                LOG.error("Cannot get mount point: {}", (Object)e.getMessage());
                return builder.isdir(true).mtime(modTime).atime(accessTime).perm(permission[0]).owner(owner[0]).group(group[0]).symlink(new byte[0]).fileId(inodeId).children(childrenNums[0]).flags(flags[0]).build();
            }, IOException.class);
        } else {
            try {
                UserGroupInformation ugi = RouterRpcServer.getRemoteUser();
                owner[0] = ugi.getUserName();
                group[0] = ugi.getPrimaryGroupName();
            }
            catch (IOException e2) {
                String msg = "Cannot get remote user: " + e2.getMessage();
                if (UserGroupInformation.isSecurityEnabled()) {
                    LOG.error(msg);
                } else {
                    LOG.debug(msg);
                }
            }
            finally {
                AsyncUtil.asyncComplete(builder.isdir(true).mtime(modTime).atime(accessTime).perm(permission[0]).owner(owner[0]).group(group[0]).symlink(new byte[0]).fileId(inodeId).children(childrenNums[0]).flags(flags[0]).build());
            }
        }
        return AsyncUtil.asyncReturn(HdfsFileStatus.class);
    }

    @Override
    protected HdfsFileStatus getFileInfoAll(List<RemoteLocation> locations, RemoteMethod method, long timeOutMs) throws IOException {
        this.rpcClient.invokeConcurrent(locations, method, false, false, timeOutMs, HdfsFileStatus.class);
        AsyncUtil.asyncApply(res -> {
            Map results = (Map)res;
            int children = 0;
            HdfsFileStatus dirStatus = null;
            for (RemoteLocation loc : locations) {
                HdfsFileStatus fileStatus = (HdfsFileStatus)results.get(loc);
                if (fileStatus == null) continue;
                children += fileStatus.getChildrenNum();
                if (!fileStatus.isDirectory()) {
                    return fileStatus;
                }
                if (dirStatus != null) continue;
                dirStatus = fileStatus;
            }
            if (dirStatus != null) {
                return FederationUtil.updateMountPointStatus(dirStatus, children);
            }
            return null;
        });
        return AsyncUtil.asyncReturn(HdfsFileStatus.class);
    }

    @Override
    public boolean recoverLease(String src, String clientName) throws IOException {
        super.recoverLease(src, clientName);
        return AsyncUtil.asyncReturn(Boolean.TYPE);
    }

    @Override
    public long[] getStats() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("getStats");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, long[].class);
        AsyncUtil.asyncApply(o -> {
            Map results = (Map)o;
            long[] combinedData = new long[9];
            for (long[] data : results.values()) {
                for (int i = 0; i < combinedData.length && i < data.length; ++i) {
                    if (data[i] < 0L) continue;
                    int n = i;
                    combinedData[n] = combinedData[n] + data[i];
                }
            }
            return combinedData;
        });
        return AsyncUtil.asyncReturn(long[].class);
    }

    @Override
    public ReplicatedBlockStats getReplicatedBlockStats() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getReplicatedBlockStats");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, ReplicatedBlockStats.class);
        AsyncUtil.asyncApply(o -> {
            Map ret = (Map)o;
            return ReplicatedBlockStats.merge(ret.values());
        });
        return AsyncUtil.asyncReturn(ReplicatedBlockStats.class);
    }

    @Override
    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        return this.rpcServer.getDatanodeReportAsync(type, true, 0L);
    }

    @Override
    public DatanodeInfo[] getSlowDatanodeReport() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        return this.rpcServer.getSlowDatanodeReportAsync(true, 0L);
    }

    @Override
    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.rpcServer.getDatanodeStorageReportMapAsync(type);
        AsyncUtil.asyncApply(dnSubcluster -> this.mergeDtanodeStorageReport((Map<String, DatanodeStorageReport[]>)dnSubcluster));
        return AsyncUtil.asyncReturn(DatanodeStorageReport[].class);
    }

    @Override
    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type, boolean requireResponse, long timeOutMs) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.rpcServer.getDatanodeStorageReportMapAsync(type, requireResponse, timeOutMs);
        AsyncUtil.asyncApply(dnSubcluster -> this.mergeDtanodeStorageReport((Map<String, DatanodeStorageReport[]>)dnSubcluster));
        return AsyncUtil.asyncReturn(DatanodeStorageReport[].class);
    }

    @Override
    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("setSafeMode", new Class[]{HdfsConstants.SafeModeAction.class, Boolean.TYPE}, action, isChecked);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, !isChecked, Boolean.class);
        AsyncUtil.asyncApply(o -> {
            Map results = (Map)o;
            int numSafemode = 0;
            Iterator iterator = results.values().iterator();
            while (iterator.hasNext()) {
                boolean safemode = (Boolean)iterator.next();
                if (!safemode) continue;
                ++numSafemode;
            }
            return numSafemode == results.size();
        });
        return AsyncUtil.asyncReturn(Boolean.class);
    }

    @Override
    public boolean saveNamespace(long timeWindow, long txGap) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("saveNamespace", new Class[]{Long.TYPE, Long.TYPE}, timeWindow, txGap);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, Boolean.TYPE);
        AsyncUtil.asyncApply(o -> {
            Map ret = (Map)o;
            boolean success = true;
            Iterator iterator = ret.values().iterator();
            while (iterator.hasNext()) {
                boolean s = (Boolean)iterator.next();
                if (s) continue;
                success = false;
                break;
            }
            return success;
        });
        return AsyncUtil.asyncReturn(Boolean.class);
    }

    @Override
    public long rollEdits() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("rollEdits", new Class[0], new Object[0]);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, Long.TYPE);
        AsyncUtil.asyncApply(o -> {
            Map ret = (Map)o;
            long txid = 0L;
            Iterator iterator = ret.values().iterator();
            while (iterator.hasNext()) {
                long t = (Long)iterator.next();
                if (t <= txid) continue;
                txid = t;
            }
            return txid;
        });
        return AsyncUtil.asyncReturn(Long.TYPE);
    }

    @Override
    public boolean restoreFailedStorage(String arg) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.UNCHECKED);
        RemoteMethod method = new RemoteMethod("restoreFailedStorage", new Class[]{String.class}, arg);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, Boolean.class);
        AsyncUtil.asyncApply(o -> {
            Map ret = (Map)o;
            boolean success = true;
            Iterator iterator = ret.values().iterator();
            while (iterator.hasNext()) {
                boolean s = (Boolean)iterator.next();
                if (s) continue;
                success = false;
                break;
            }
            return success;
        });
        return AsyncUtil.asyncReturn(Boolean.TYPE);
    }

    @Override
    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("rollingUpgrade", new Class[]{HdfsConstants.RollingUpgradeAction.class}, action);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, RollingUpgradeInfo.class);
        AsyncUtil.asyncApply(o -> {
            Map ret = (Map)o;
            RollingUpgradeInfo info = null;
            for (RollingUpgradeInfo infoNs : ret.values()) {
                if (info != null || infoNs == null) continue;
                info = infoNs;
            }
            return info;
        });
        return AsyncUtil.asyncReturn(RollingUpgradeInfo.class);
    }

    @Override
    public ContentSummary getContentSummary(String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        ArrayList summaries = new ArrayList();
        List<RemoteLocation> locations = this.getLocationsForContentSummary(path);
        RemoteMethod method = new RemoteMethod("getContentSummary", new Class[]{String.class}, new RemoteParam());
        this.rpcClient.invokeConcurrent(locations, method, false, -1L, ContentSummary.class);
        AsyncUtil.asyncApply(o -> {
            List results = (List)o;
            FileNotFoundException notFoundException = null;
            for (RemoteResult result : results) {
                if (result.hasException()) {
                    IOException ioe = result.getException();
                    if (ioe instanceof FileNotFoundException) {
                        notFoundException = (FileNotFoundException)ioe;
                        continue;
                    }
                    if (this.allowPartialList) continue;
                    throw ioe;
                }
                if (result.getResult() == null) continue;
                summaries.add((ContentSummary)result.getResult());
            }
            if (summaries.isEmpty() && notFoundException != null) {
                throw notFoundException;
            }
            return this.aggregateContentSummary(summaries);
        });
        return AsyncUtil.asyncReturn(ContentSummary.class);
    }

    @Override
    public long getCurrentEditLogTxid() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getCurrentEditLogTxid", new Class[0], new Object[0]);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, Long.TYPE);
        AsyncUtil.asyncApply(o -> {
            Map ret = (Map)o;
            long txid = 0L;
            Iterator iterator = ret.values().iterator();
            while (iterator.hasNext()) {
                long t = (Long)iterator.next();
                if (t <= txid) continue;
                txid = t;
            }
            return txid;
        });
        return AsyncUtil.asyncReturn(Long.TYPE);
    }

    @Override
    public void msync() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, true);
        Set<FederationNamespaceInfo> allNamespaces = this.namenodeResolver.getNamespaces();
        RemoteMethod method = new RemoteMethod("msync");
        Set namespacesEligibleForObserverReads = allNamespaces.stream().filter(ns -> this.rpcClient.isNamespaceObserverReadEligible(ns.getNameserviceId())).collect(Collectors.toSet());
        if (namespacesEligibleForObserverReads.isEmpty()) {
            AsyncUtil.asyncCompleteWith(CompletableFuture.completedFuture(null));
            return;
        }
        this.rpcClient.invokeConcurrent(namespacesEligibleForObserverReads, method);
    }

    @Override
    public boolean setReplication(String src, short replication) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, true);
        RemoteMethod method = new RemoteMethod("setReplication", new Class[]{String.class, Short.TYPE}, new RemoteParam(), replication);
        if (this.rpcServer.isInvokeConcurrent(src)) {
            this.rpcClient.invokeConcurrent(locations, method, Boolean.class);
            AsyncUtil.asyncApply(o -> {
                Map results = (Map)o;
                return !results.containsValue(false);
            });
        } else {
            this.rpcClient.invokeSequential(locations, method, Boolean.class, (Object)Boolean.TRUE);
        }
        return AsyncUtil.asyncReturn(Boolean.TYPE);
    }

    @Override
    @VisibleForTesting
    public boolean isMultiDestDirectory(String src) {
        AsyncUtil.asyncTry(() -> {
            if (this.rpcServer.isPathAll(src)) {
                List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
                RemoteMethod method = new RemoteMethod("getFileInfo", new Class[]{String.class}, new RemoteParam());
                this.rpcClient.invokeSequential(locations, method, HdfsFileStatus.class, null);
                AsyncUtil.asyncApply(fileStatus -> {
                    if (fileStatus != null) {
                        return fileStatus.isDirectory();
                    }
                    LOG.debug("The destination {} doesn't exist.", (Object)src);
                    return false;
                });
            } else {
                AsyncUtil.asyncComplete(false);
            }
        });
        AsyncUtil.asyncCatch((o, e) -> {
            LOG.debug("The destination {} is a symlink.", (Object)src);
            return false;
        }, UnresolvedPathException.class);
        return AsyncUtil.asyncReturn(Boolean.TYPE);
    }

    @Override
    public Path getEnclosingRoot(String src) throws IOException {
        MountTableResolver mountTable;
        Path[] mountPath = new Path[1];
        if (this.defaultNameServiceEnabled) {
            mountPath[0] = new Path("/");
        }
        if (this.subclusterResolver instanceof MountTableResolver && (mountTable = (MountTableResolver)this.subclusterResolver).getMountPoint(src) != null) {
            mountPath[0] = new Path(mountTable.getMountPoint(src).getSourcePath());
        }
        if (mountPath[0] == null) {
            throw new IOException(String.format("No mount point for %s", src));
        }
        this.getEZForPath(src);
        AsyncUtil.asyncApply(zone -> {
            if (zone == null) {
                return mountPath[0];
            }
            Path zonePath = new Path(zone.getPath());
            return zonePath.depth() > mountPath[0].depth() ? zonePath : mountPath[0];
        });
        return AsyncUtil.asyncReturn(Path.class);
    }

    @Override
    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        AsyncUtil.asyncComplete(this.getSecurityManager().getDelegationToken(renewer));
        return AsyncUtil.asyncReturn(Token.class);
    }

    @Override
    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        AsyncUtil.asyncComplete(this.getSecurityManager().renewDelegationToken(token));
        return AsyncUtil.asyncReturn(Long.class);
    }

    @Override
    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        this.getSecurityManager().cancelDelegationToken(token);
        AsyncUtil.asyncComplete(null);
    }
}

