/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.server.federation.router.RouterCacheAdmin;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;

public class RouterAsyncCacheAdmin
extends RouterCacheAdmin {
    public RouterAsyncCacheAdmin(RouterRpcServer server) {
        super(server);
    }

    @Override
    public long addCacheDirective(CacheDirectiveInfo path, EnumSet<CacheFlag> flags) throws IOException {
        this.invokeAddCacheDirective(path, flags);
        AsyncUtil.asyncApply(response -> (Long)response.values().iterator().next());
        return AsyncUtil.asyncReturn(Long.class);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        this.invokeListCacheDirectives(prevId, filter);
        AsyncUtil.asyncApply(response -> (BatchedRemoteIterator.BatchedEntries)response.values().iterator().next());
        return AsyncUtil.asyncReturn(BatchedRemoteIterator.BatchedEntries.class);
    }

    @Override
    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        this.invokeListCachePools(prevKey);
        AsyncUtil.asyncApply(results -> (BatchedRemoteIterator.BatchedEntries)results.values().iterator().next());
        return AsyncUtil.asyncReturn(BatchedRemoteIterator.BatchedEntries.class);
    }
}

