/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.Quota;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class AsyncQuota
extends Quota {
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;
    private final Router router;

    public AsyncQuota(Router router, RouterRpcServer server) {
        super(router, server);
        this.router = router;
        this.rpcServer = server;
        this.rpcClient = this.rpcServer.getRPCClient();
    }

    @Override
    public QuotaUsage getQuotaUsage(String path) throws IOException {
        this.getEachQuotaUsage(path);
        AsyncUtil.asyncApply(o -> {
            Map results = (Map)o;
            try {
                return this.aggregateQuota(path, results);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
        return AsyncUtil.asyncReturn(QuotaUsage.class);
    }

    @Override
    protected Map<RemoteLocation, QuotaUsage> getEachQuotaUsage(String path) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        if (!this.router.isQuotaEnabled()) {
            throw new IOException("The quota system is disabled in Router.");
        }
        List<RemoteLocation> quotaLocs = this.getValidQuotaLocations(path);
        RemoteMethod method = new RemoteMethod("getQuotaUsage", new Class[]{String.class}, new RemoteParam());
        this.rpcClient.invokeConcurrent(quotaLocs, method, true, false, QuotaUsage.class);
        return AsyncUtil.asyncReturn(Map.class);
    }
}

