/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.ErasureCoding;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class AsyncErasureCoding
extends ErasureCoding {
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;
    private final ActiveNamenodeResolver namenodeResolver;

    public AsyncErasureCoding(RouterRpcServer server) {
        super(server);
        this.rpcServer = server;
        this.rpcClient = this.rpcServer.getRPCClient();
        this.namenodeResolver = this.rpcClient.getNamenodeResolver();
    }

    @Override
    public ErasureCodingPolicyInfo[] getErasureCodingPolicies() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getErasureCodingPolicies");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, ErasureCodingPolicyInfo[].class);
        AsyncUtil.asyncApply(ret -> RouterRpcServer.merge(ret, ErasureCodingPolicyInfo.class));
        return AsyncUtil.asyncReturn(ErasureCodingPolicyInfo[].class);
    }

    @Override
    public Map<String, String> getErasureCodingCodecs() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getErasureCodingCodecs");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, Map.class);
        AsyncUtil.asyncApply(retCodecs -> {
            Map obj;
            HashMap ret = new HashMap();
            Map results = obj = retCodecs;
            Collection allCodecs = results.values();
            for (Map codecs : allCodecs) {
                ret.putAll(codecs);
            }
            return ret;
        });
        return AsyncUtil.asyncReturn(Map.class);
    }

    @Override
    public AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] policies) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE);
        RemoteMethod method = new RemoteMethod("addErasureCodingPolicies", new Class[]{ErasureCodingPolicy[].class}, new Object[]{policies});
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, AddErasureCodingPolicyResponse[].class);
        AsyncUtil.asyncApply(ret -> RouterRpcServer.merge(ret, AddErasureCodingPolicyResponse.class));
        return AsyncUtil.asyncReturn(AddErasureCodingPolicyResponse[].class);
    }

    @Override
    public ErasureCodingPolicy getErasureCodingPolicy(String src) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(src, false, false);
        RemoteMethod remoteMethod = new RemoteMethod("getErasureCodingPolicy", new Class[]{String.class}, new RemoteParam());
        this.rpcClient.invokeSequential(locations, remoteMethod, null, null);
        AsyncUtil.asyncApply(ret -> (ErasureCodingPolicy)ret);
        return AsyncUtil.asyncReturn(ErasureCodingPolicy.class);
    }

    @Override
    public ECTopologyVerifierResult getECTopologyResultForPolicies(String[] policyNames) throws IOException {
        RemoteMethod method = new RemoteMethod("getECTopologyResultForPolicies", new Class[]{String[].class}, new Object[]{policyNames});
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        if (nss.isEmpty()) {
            throw new IOException("No namespace availaible.");
        }
        this.rpcClient.invokeConcurrent(nss, method, true, false, ECTopologyVerifierResult.class);
        AsyncUtil.asyncApply(ret -> {
            for (Map.Entry entry : ret.entrySet()) {
                if (((ECTopologyVerifierResult)entry.getValue()).isSupported()) continue;
                return (ECTopologyVerifierResult)entry.getValue();
            }
            return (ECTopologyVerifierResult)ret.get(nss.iterator().next());
        });
        return AsyncUtil.asyncReturn(ECTopologyVerifierResult.class);
    }

    @Override
    public ECBlockGroupStats getECBlockGroupStats() throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ);
        RemoteMethod method = new RemoteMethod("getECBlockGroupStats");
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false, ECBlockGroupStats.class);
        AsyncUtil.asyncApply(allStats -> ECBlockGroupStats.merge(allStats.values()));
        return AsyncUtil.asyncReturn(ECBlockGroupStats.class);
    }
}

