/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import org.apache.hadoop.hdfs.server.federation.metrics.FederationRPCPerformanceMonitor;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.Server;

public class ThreadLocalContext {
    private final Server.Call call = (Server.Call)Server.getCurCall().get();
    private final CallerContext context = CallerContext.getCurrent();
    private final long startOpTime = FederationRPCPerformanceMonitor.getStartOpTime();
    private final long proxyOpTime = FederationRPCPerformanceMonitor.getProxyOpTime();

    public void transfer() {
        Server.getCurCall().set(null);
        if (this.call != null) {
            Server.getCurCall().set(this.call);
        }
        CallerContext.setCurrent(null);
        if (this.context != null) {
            CallerContext.setCurrent((CallerContext)this.context);
        }
        if (this.startOpTime != -1L) {
            FederationRPCPerformanceMonitor.setStartOpTime(this.startOpTime);
        }
        if (this.proxyOpTime != -1L) {
            FederationRPCPerformanceMonitor.setProxyOpTime(this.proxyOpTime);
        }
    }

    public String toString() {
        return "ThreadLocalContext{call=" + this.call + ", context=" + this.context + ", startOpTime=" + this.startOpTime + ", proxyOpTime=" + this.proxyOpTime + "}";
    }
}

