/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAccumulator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.server.namenode.ha.ReadOnly;
import org.apache.hadoop.ipc.AlignmentContext;
import org.apache.hadoop.ipc.RetriableException;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.thirdparty.protobuf.InvalidProtocolBufferException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RouterStateIdContext
implements AlignmentContext {
    private final HashSet<String> coordinatedMethods;
    private final ConcurrentHashMap<String, LongAccumulator> namespaceIdMap;
    private final int maxSizeOfFederatedStateToPropagate;
    private final boolean observerReadEnabledDefault;
    private HashSet<String> observerReadEnabledOverrides = new HashSet();

    RouterStateIdContext(Configuration conf) {
        this.coordinatedMethods = new HashSet();
        for (Method method : ClientProtocol.class.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ReadOnly.class) || !((ReadOnly[])method.getAnnotationsByType(ReadOnly.class))[0].isCoordinated()) continue;
            this.coordinatedMethods.add(method.getName());
        }
        this.namespaceIdMap = new ConcurrentHashMap();
        this.maxSizeOfFederatedStateToPropagate = conf.getInt("dfs.federation.router.observer.federated.state.propagation.maxsize", 5);
        this.observerReadEnabledDefault = conf.getBoolean("dfs.federation.router.observer.read.default", false);
        String[] observerReadOverrides = conf.getStrings("dfs.federation.router.observer.read.overrides");
        if (observerReadOverrides != null) {
            this.observerReadEnabledOverrides.addAll(Arrays.asList(observerReadOverrides));
        }
    }

    public void setResponseHeaderState(RpcHeaderProtos.RpcResponseHeaderProto.Builder headerBuilder) {
        if (this.namespaceIdMap.isEmpty()) {
            return;
        }
        HdfsProtos.RouterFederatedStateProto.Builder builder = HdfsProtos.RouterFederatedStateProto.newBuilder();
        this.namespaceIdMap.forEach((k, v) -> {
            if (v.get() != Long.MIN_VALUE && this.isNamespaceObserverReadEligible((String)k)) {
                builder.putNamespaceStateIds(k, v.get());
            }
        });
        if (builder.getNamespaceStateIdsCount() <= this.maxSizeOfFederatedStateToPropagate) {
            headerBuilder.setRouterFederatedState(builder.build().toByteString());
        }
    }

    public LongAccumulator getNamespaceStateId(String nsId) {
        return this.namespaceIdMap.computeIfAbsent(nsId, key -> new LongAccumulator(Math::max, Long.MIN_VALUE));
    }

    public List<String> getNamespaces() {
        return Collections.list(this.namespaceIdMap.keys());
    }

    public ConcurrentHashMap<String, LongAccumulator> getNamespaceIdMap() {
        return this.namespaceIdMap;
    }

    public void removeNamespaceStateId(String nsId) {
        this.namespaceIdMap.remove(nsId);
    }

    public static Map<String, Long> getRouterFederatedStateMap(ByteString byteString) {
        if (byteString != null) {
            HdfsProtos.RouterFederatedStateProto federatedState;
            try {
                federatedState = HdfsProtos.RouterFederatedStateProto.parseFrom((ByteString)byteString);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
            return federatedState.getNamespaceStateIdsMap();
        }
        return Collections.emptyMap();
    }

    public static long getClientStateIdFromCurrentCall(String nsId) {
        ByteString callFederatedNamespaceState;
        Long clientStateID = Long.MIN_VALUE;
        Server.Call call = (Server.Call)Server.getCurCall().get();
        if (call != null && (callFederatedNamespaceState = call.getFederatedNamespaceState()) != null) {
            Map<String, Long> clientFederatedStateIds = RouterStateIdContext.getRouterFederatedStateMap(callFederatedNamespaceState);
            clientStateID = clientFederatedStateIds.getOrDefault(nsId, Long.MIN_VALUE);
        }
        return clientStateID;
    }

    public void updateResponseState(RpcHeaderProtos.RpcResponseHeaderProto.Builder header) {
        this.setResponseHeaderState(header);
    }

    public void receiveResponseState(RpcHeaderProtos.RpcResponseHeaderProto header) {
    }

    public void updateRequestState(RpcHeaderProtos.RpcRequestHeaderProto.Builder header) {
    }

    public long receiveRequestState(RpcHeaderProtos.RpcRequestHeaderProto header, long clientWaitTime) throws RetriableException {
        return 0L;
    }

    public long getLastSeenStateId() {
        return 0L;
    }

    public boolean isCoordinatedCall(String protocolName, String methodName) {
        return protocolName.equals(ClientProtocol.class.getCanonicalName()) && this.coordinatedMethods.contains(methodName);
    }

    boolean isNamespaceObserverReadEligible(String nsId) {
        return this.observerReadEnabledDefault != this.observerReadEnabledOverrides.contains(nsId);
    }
}

