/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.PeriodicService;
import org.apache.hadoop.hdfs.server.federation.router.Quota;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaManager;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.federation.store.MountTableStore;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetMountTableEntriesResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterQuotaUpdateService
extends PeriodicService {
    private static final Logger LOG = LoggerFactory.getLogger(RouterQuotaUpdateService.class);
    private MountTableStore mountTableStore;
    private RouterRpcServer rpcServer;
    private final Router router;
    private RouterQuotaManager quotaManager;

    public RouterQuotaUpdateService(Router router) throws IOException {
        super(RouterQuotaUpdateService.class.getName());
        this.router = router;
        this.rpcServer = router.getRpcServer();
        this.quotaManager = router.getQuotaManager();
        if (this.quotaManager == null) {
            throw new IOException("Router quota manager is not initialized.");
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.setIntervalMs(conf.getTimeDuration("dfs.federation.router.quota-cache.update.interval", 60000L, TimeUnit.MILLISECONDS));
        super.serviceInit(conf);
    }

    @Override
    protected void periodicInvoke() {
        LOG.debug("Start to update quota cache.");
        try {
            List<MountTable> mountTables = this.getQuotaSetMountTables();
            HashMap remoteQuotaUsage = new HashMap();
            for (MountTable mountTable : mountTables) {
                String src = mountTable.getSourcePath();
                RouterQuotaUsage oldQuota = mountTable.getQuota();
                long nsQuota = oldQuota.getQuota();
                long ssQuota = oldQuota.getSpaceQuota();
                long[] typeQuota = new long[StorageType.values().length];
                Quota.eachByStorageType(t -> {
                    typeQuota[t.ordinal()] = oldQuota.getTypeQuota((StorageType)t);
                });
                RouterQuotaUsage currentQuotaUsage = null;
                HdfsFileStatus ret = this.rpcServer.getFileInfo(src);
                if (this.rpcServer.isAsync()) {
                    ret = AsyncUtil.syncReturn(HdfsFileStatus.class);
                }
                if (ret == null || ret.getModificationTime() == 0L) {
                    long[] zeroConsume = new long[StorageType.values().length];
                    currentQuotaUsage = new RouterQuotaUsage.Builder().fileAndDirectoryCount(0L).quota(nsQuota).spaceConsumed(0L).spaceQuota(ssQuota).typeConsumed(zeroConsume).typeQuota(typeQuota).build();
                } else {
                    try {
                        Quota quotaModule = this.rpcServer.getQuotaModule();
                        Map usageMap = quotaModule.getEachQuotaUsage(src);
                        if (this.rpcServer.isAsync()) {
                            usageMap = AsyncUtil.syncReturn(Map.class);
                        }
                        currentQuotaUsage = quotaModule.aggregateQuota(src, usageMap);
                        remoteQuotaUsage.putAll(usageMap);
                    }
                    catch (IOException ioe) {
                        LOG.error("Unable to get quota usage for " + src, (Throwable)ioe);
                        continue;
                    }
                }
                RouterQuotaUsage newQuota = this.generateNewQuota(oldQuota, currentQuotaUsage);
                this.quotaManager.put(src, newQuota);
                mountTable.setQuota(newQuota);
            }
            for (Map.Entry entry : remoteQuotaUsage.entrySet()) {
                RemoteLocation remoteLocation = (RemoteLocation)entry.getKey();
                QuotaUsage currentQuota = (QuotaUsage)entry.getValue();
                this.fixGlobalQuota(remoteLocation, currentQuota);
            }
        }
        catch (IOException e) {
            LOG.error("Quota cache updated error.", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error(e.toString());
        }
    }

    private void fixGlobalQuota(RemoteLocation location, QuotaUsage remoteQuota) throws IOException {
        QuotaUsage gQuota = this.rpcServer.getQuotaModule().getGlobalQuota(location.getSrc());
        if (remoteQuota.getQuota() != gQuota.getQuota() || remoteQuota.getSpaceQuota() != gQuota.getSpaceQuota()) {
            this.rpcServer.getQuotaModule().setQuotaInternal(location.getSrc(), Arrays.asList(location), gQuota.getQuota(), gQuota.getSpaceQuota(), null);
            LOG.info("[Fix Quota] src={} dst={} oldQuota={}/{} newQuota={}/{}", new Object[]{location.getSrc(), location, remoteQuota.getQuota(), remoteQuota.getSpaceQuota(), gQuota.getQuota(), gQuota.getSpaceQuota()});
        }
        for (StorageType t : StorageType.values()) {
            if (remoteQuota.getTypeQuota(t) == gQuota.getTypeQuota(t)) continue;
            this.rpcServer.getQuotaModule().setQuotaInternal(location.getSrc(), Arrays.asList(location), Long.MAX_VALUE, gQuota.getTypeQuota(t), t);
            LOG.info("[Fix Quota] src={} dst={} type={} oldQuota={} newQuota={}", new Object[]{location.getSrc(), location, t, remoteQuota.getTypeQuota(t), gQuota.getTypeQuota(t)});
        }
    }

    private MountTableStore getMountTableStore() throws IOException {
        if (this.mountTableStore == null) {
            this.mountTableStore = this.router.getStateStore().getRegisteredRecordStore(MountTableStore.class);
            if (this.mountTableStore == null) {
                throw new IOException("Mount table state store is not available.");
            }
        }
        return this.mountTableStore;
    }

    private List<MountTable> getMountTableEntries() throws IOException {
        GetMountTableEntriesRequest getRequest = GetMountTableEntriesRequest.newInstance("/");
        GetMountTableEntriesResponse getResponse = this.getMountTableStore().getMountTableEntries(getRequest);
        return getResponse.getEntries();
    }

    private List<MountTable> getQuotaSetMountTables() throws IOException {
        List<MountTable> mountTables = this.getMountTableEntries();
        Set<String> allPaths = this.quotaManager.getAll();
        HashSet<String> stalePaths = new HashSet<String>(allPaths);
        LinkedList<MountTable> neededMountTables = new LinkedList<MountTable>();
        for (MountTable entry : mountTables) {
            if (this.isQuotaSet(entry)) {
                neededMountTables.add(entry);
            }
            String src = entry.getSourcePath();
            this.quotaManager.updateQuota(src, entry.getQuota());
            stalePaths.remove(src);
        }
        for (String stalePath : stalePaths) {
            this.quotaManager.remove(stalePath);
        }
        return neededMountTables;
    }

    private boolean isQuotaSet(MountTable mountTable) {
        if (mountTable != null) {
            return RouterQuotaManager.isQuotaSet(mountTable.getQuota());
        }
        return false;
    }

    private RouterQuotaUsage generateNewQuota(RouterQuotaUsage oldQuota, QuotaUsage currentQuotaUsage) {
        RouterQuotaUsage.Builder newQuotaBuilder = new RouterQuotaUsage.Builder().fileAndDirectoryCount(currentQuotaUsage.getFileAndDirectoryCount()).quota(oldQuota.getQuota()).spaceConsumed(currentQuotaUsage.getSpaceConsumed()).spaceQuota(oldQuota.getSpaceQuota());
        Quota.eachByStorageType(t -> {
            newQuotaBuilder.typeQuota((StorageType)t, oldQuota.getTypeQuota((StorageType)t));
            newQuotaBuilder.typeConsumed((StorageType)t, currentQuotaUsage.getTypeConsumed(t));
        });
        return newQuotaBuilder.build();
    }
}

