/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.tools.fedbalance.DistCpProcedure;
import org.apache.hadoop.tools.fedbalance.FedBalanceConfigs;
import org.apache.hadoop.tools.fedbalance.FedBalanceContext;
import org.apache.hadoop.tools.fedbalance.TrashProcedure;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceJob;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceProcedure;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceProcedureScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RouterFederationRename {
    private static final Logger LOG = LoggerFactory.getLogger((String)RouterFederationRename.class.getName());
    private final RouterRpcServer rpcServer;
    private final Configuration conf;
    private final AtomicInteger routerRenameCounter = new AtomicInteger();

    public RouterFederationRename(RouterRpcServer rpcServer, Configuration conf) {
        this.rpcServer = rpcServer;
        this.conf = conf;
    }

    public boolean routerFedRename(String src, String dst, List<RemoteLocation> srcLocations, List<RemoteLocation> dstLocations) throws IOException {
        if (!this.rpcServer.isEnableRenameAcrossNamespace()) {
            throw new IOException("Rename of " + src + " to " + dst + " is not allowed, no eligible destination in the same namespace was found");
        }
        if (srcLocations.size() != 1 || dstLocations.size() != 1) {
            throw new IOException("Rename of " + src + " to " + dst + " is not allowed. The remote location should be exactly one.");
        }
        RemoteLocation srcLoc = srcLocations.get(0);
        RemoteLocation dstLoc = dstLocations.get(0);
        RouterFederationRename.checkSnapshotPath(srcLoc, dstLoc);
        this.checkPermission(srcLoc, dstLoc);
        UserGroupInformation routerUser = UserGroupInformation.getLoginUser();
        try {
            return (Boolean)routerUser.doAs(() -> {
                BalanceJob job = this.buildRouterRenameJob(srcLoc.getNameserviceId(), dstLoc.getNameserviceId(), srcLoc.getDest(), dstLoc.getDest());
                BalanceProcedureScheduler scheduler = this.rpcServer.getFedRenameScheduler();
                this.countIncrement();
                try {
                    scheduler.submit(job);
                    LOG.info("Rename {} to {} from namespace {} to {}. JobId={}.", new Object[]{src, dst, srcLoc.getNameserviceId(), dstLoc.getNameserviceId(), job.getId()});
                    scheduler.waitUntilDone(job);
                    if (job.getError() != null) {
                        throw new IOException("Rename of " + src + " to " + dst + " failed.", job.getError());
                    }
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    this.countDecrement();
                }
            });
        }
        catch (InterruptedException e) {
            LOG.warn("Fed balance job is interrupted.", (Throwable)e);
            throw new InterruptedIOException(e.getMessage());
        }
    }

    private void checkPermission(RemoteLocation src, RemoteLocation dst) throws IOException {
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                String remoteUserName = NameNode.getRemoteUser().getShortUserName();
                UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)remoteUserName, (UserGroupInformation)UserGroupInformation.getLoginUser());
                proxyUser.doAs(() -> {
                    this.checkRenamePermission(src, dst);
                    return null;
                });
            } else {
                this.checkRenamePermission(src, dst);
            }
        }
        catch (AccessControlException e) {
            throw new AccessControlException("Permission denied rename " + src.getSrc() + "(" + src + ") to " + dst.getSrc() + "(" + dst + ") Reason=" + e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InterruptedIOException("Router Federation Rename is interrupted while checking permission.");
        }
    }

    private void checkRenamePermission(RemoteLocation srcLoc, RemoteLocation dstLoc) throws IOException {
        Path srcPath = new Path("hdfs://" + srcLoc.getNameserviceId() + srcLoc.getDest());
        srcPath.getFileSystem(this.conf).access(srcPath.getParent(), FsAction.WRITE);
        Path dstPath = new Path("hdfs://" + dstLoc.getNameserviceId() + dstLoc.getDest());
        dstPath.getFileSystem(this.conf).access(dstPath.getParent(), FsAction.WRITE);
    }

    static void checkSnapshotPath(RemoteLocation src, RemoteLocation dst) throws AccessControlException {
        if (src.getDest().contains("/.snapshot/")) {
            throw new AccessControlException("Router federation rename can't rename snapshot path. src=" + src.getSrc() + "(" + src + ")");
        }
        if (dst.getDest().contains("/.snapshot/")) {
            throw new AccessControlException("Router federation rename can't rename snapshot path. dst=" + dst.getSrc() + "(" + dst + ")");
        }
    }

    private BalanceJob buildRouterRenameJob(String srcNs, String dstNs, String src, String dst) throws IOException {
        RouterFederationRename.checkConfiguration(this.conf);
        Path srcPath = new Path("hdfs://" + srcNs + src);
        Path dstPath = new Path("hdfs://" + dstNs + dst);
        boolean forceCloseOpen = this.conf.getBoolean("dfs.federation.router.federation.rename.force.close.open.file", true);
        int map = this.conf.getInt("dfs.federation.router.federation.rename.map", -1);
        int bandwidth = this.conf.getInt("dfs.federation.router.federation.rename.bandwidth", -1);
        long delay = this.conf.getLong("dfs.federation.router.federation.rename.delay", 1000L);
        int diff = this.conf.getInt("dfs.federation.router.federation.rename.diff", 0);
        String trashPolicy = this.conf.get("dfs.federation.router.federation.rename.trash", "trash");
        FedBalanceConfigs.TrashOption trashOpt = FedBalanceConfigs.TrashOption.valueOf((String)trashPolicy.toUpperCase());
        FedBalanceContext context = new FedBalanceContext.Builder(srcPath, dstPath, "no-mount", this.conf).setForceCloseOpenFiles(forceCloseOpen).setUseMountReadOnly(true).setMapNum(map).setBandwidthLimit(bandwidth).setTrash(trashOpt).setDelayDuration(delay).setDiffThreshold(diff).build();
        LOG.info(context.toString());
        BalanceJob.Builder builder = new BalanceJob.Builder();
        DistCpProcedure dcp = new DistCpProcedure("distcp-procedure", null, delay, context);
        builder.nextProcedure((BalanceProcedure)dcp);
        TrashProcedure tp = new TrashProcedure("trash-procedure", null, delay, context);
        builder.nextProcedure((BalanceProcedure)tp);
        return builder.build();
    }

    public int getRouterFederationRenameCount() {
        return this.routerRenameCounter.get();
    }

    void countIncrement() {
        this.routerRenameCounter.incrementAndGet();
    }

    void countDecrement() {
        this.routerRenameCounter.decrementAndGet();
    }

    static void checkConfiguration(Configuration conf) throws IOException {
        int map = conf.getInt("dfs.federation.router.federation.rename.map", -1);
        int bandwidth = conf.getInt("dfs.federation.router.federation.rename.bandwidth", -1);
        long delay = conf.getLong("dfs.federation.router.federation.rename.delay", 1000L);
        int diff = conf.getInt("dfs.federation.router.federation.rename.diff", 0);
        if (map < 0) {
            throw new IOException("map=" + map + " is negative. Please check dfs.federation.router.federation.rename.map");
        }
        if (bandwidth < 0) {
            throw new IOException("bandwidth=" + bandwidth + " is negative. Please check dfs.federation.router.federation.rename.bandwidth");
        }
        if (delay < 0L) {
            throw new IOException("delay=" + delay + " is negative. Please check dfs.federation.router.federation.rename.delay");
        }
        if (diff < 0) {
            throw new IOException("diff=" + diff + " is negative. Please check dfs.federation.router.federation.rename.diff");
        }
    }

    public static enum RouterRenameOption {
        NONE,
        DISTCP;

    }
}

