/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.ActiveNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RemoteParam;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.NameNode;

public class RouterCacheAdmin {
    private final RouterRpcServer rpcServer;
    private final RouterRpcClient rpcClient;
    private final ActiveNamenodeResolver namenodeResolver;

    public RouterCacheAdmin(RouterRpcServer server) {
        this.rpcServer = server;
        this.rpcClient = this.rpcServer.getRPCClient();
        this.namenodeResolver = this.rpcClient.getNamenodeResolver();
    }

    public long addCacheDirective(CacheDirectiveInfo path, EnumSet<CacheFlag> flags) throws IOException {
        Map<RemoteLocation, Long> response = this.invokeAddCacheDirective(path, flags);
        return response.values().iterator().next();
    }

    protected Map<RemoteLocation, Long> invokeAddCacheDirective(CacheDirectiveInfo path, EnumSet<CacheFlag> flags) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(path.getPath().toString(), true, false);
        RemoteMethod method = new RemoteMethod("addCacheDirective", new Class[]{CacheDirectiveInfo.class, EnumSet.class}, new RemoteParam(this.getRemoteMap(path, locations)), flags);
        return this.rpcClient.invokeConcurrent(locations, method, false, false, Long.TYPE);
    }

    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        Path p = directive.getPath();
        if (p != null) {
            List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(directive.getPath().toString(), true, false);
            RemoteMethod method = new RemoteMethod("modifyCacheDirective", new Class[]{CacheDirectiveInfo.class, EnumSet.class}, new RemoteParam(this.getRemoteMap(directive, locations)), flags);
            this.rpcClient.invokeConcurrent(locations, method);
            return;
        }
        RemoteMethod method = new RemoteMethod("modifyCacheDirective", new Class[]{CacheDirectiveInfo.class, EnumSet.class}, directive, flags);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, false, false);
    }

    public void removeCacheDirective(long id) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        RemoteMethod method = new RemoteMethod("removeCacheDirective", new Class[]{Long.TYPE}, id);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, false, false);
    }

    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        Map results = this.invokeListCacheDirectives(prevId, filter);
        return (BatchedRemoteIterator.BatchedEntries)results.values().iterator().next();
    }

    protected Map invokeListCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, true);
        if (filter.getPath() != null) {
            List<RemoteLocation> locations = this.rpcServer.getLocationsForPath(filter.getPath().toString(), true, false);
            RemoteMethod method = new RemoteMethod("listCacheDirectives", new Class[]{Long.TYPE, CacheDirectiveInfo.class}, prevId, new RemoteParam(this.getRemoteMap(filter, locations)));
            return this.rpcClient.invokeConcurrent(locations, method, false, false, BatchedRemoteIterator.BatchedEntries.class);
        }
        RemoteMethod method = new RemoteMethod("listCacheDirectives", new Class[]{Long.TYPE, CacheDirectiveInfo.class}, prevId, filter);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        return this.rpcClient.invokeConcurrent(nss, method, true, false, BatchedRemoteIterator.BatchedEntries.class);
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        RemoteMethod method = new RemoteMethod("addCachePool", new Class[]{CachePoolInfo.class}, info);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        RemoteMethod method = new RemoteMethod("modifyCachePool", new Class[]{CachePoolInfo.class}, info);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    public void removeCachePool(String cachePoolName) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.WRITE, true);
        RemoteMethod method = new RemoteMethod("removeCachePool", new Class[]{String.class}, cachePoolName);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        this.rpcClient.invokeConcurrent(nss, method, true, false);
    }

    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        Map<FederationNamespaceInfo, BatchedRemoteIterator.BatchedEntries> results = this.invokeListCachePools(prevKey);
        return results.values().iterator().next();
    }

    protected Map<FederationNamespaceInfo, BatchedRemoteIterator.BatchedEntries> invokeListCachePools(String prevKey) throws IOException {
        this.rpcServer.checkOperation(NameNode.OperationCategory.READ, true);
        RemoteMethod method = new RemoteMethod("listCachePools", new Class[]{String.class}, prevKey);
        Set<FederationNamespaceInfo> nss = this.namenodeResolver.getNamespaces();
        return this.rpcClient.invokeConcurrent(nss, method, true, false, BatchedRemoteIterator.BatchedEntries.class);
    }

    protected Map<RemoteLocation, CacheDirectiveInfo> getRemoteMap(CacheDirectiveInfo path, List<RemoteLocation> locations) {
        HashMap<RemoteLocation, CacheDirectiveInfo> dstMap = new HashMap<RemoteLocation, CacheDirectiveInfo>();
        Iterator<RemoteLocation> iterator = locations.iterator();
        while (iterator.hasNext()) {
            dstMap.put(iterator.next(), path);
        }
        return dstMap;
    }
}

