/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;

public class NamenodeStatusReport {
    private String nameserviceId = "";
    private String namenodeId = "";
    private String clusterId = "";
    private String blockPoolId = "";
    private String rpcAddress = "";
    private String serviceAddress = "";
    private String lifelineAddress = "";
    private String webAddress = "";
    private String webScheme = "";
    private HAServiceProtocol.HAServiceState status = HAServiceProtocol.HAServiceState.STANDBY;
    private boolean safeMode = false;
    private int liveDatanodes = -1;
    private int deadDatanodes = -1;
    private int staleDatanodes = -1;
    private int decomDatanodes = -1;
    private int liveDecomDatanodes = -1;
    private int deadDecomDatanodes = -1;
    private int inMaintenanceLiveDataNodes = -1;
    private int inMaintenanceDeadDataNodes = -1;
    private int enteringMaintenanceDataNodes = -1;
    private long availableSpace = -1L;
    private long numOfFiles = -1L;
    private long numOfBlocks = -1L;
    private long numOfBlocksMissing = -1L;
    private long numOfBlocksPendingReplication = -1L;
    private long numOfBlocksUnderReplicated = -1L;
    private long numOfBlocksPendingDeletion = -1L;
    private long totalSpace = -1L;
    private long providedSpace = -1L;
    private int corruptFilesCount = -1;
    private long scheduledReplicationBlocks = -1L;
    private long numberOfMissingBlocksWithReplicationFactorOne = -1L;
    private long numberOfBadlyDistributedBlocks = -1L;
    private long highestPriorityLowRedundancyReplicatedBlocks = -1L;
    private long highestPriorityLowRedundancyECBlocks = -1L;
    private int pendingSPSPaths = -1;
    private boolean registrationValid = false;
    private boolean statsValid = false;
    private boolean haStateValid = false;

    public NamenodeStatusReport(String ns, String nn, String rpc, String service, String lifeline, String webScheme, String web) {
        this.nameserviceId = ns;
        this.namenodeId = nn;
        this.rpcAddress = rpc;
        this.serviceAddress = service;
        this.lifelineAddress = lifeline;
        this.webScheme = webScheme;
        this.webAddress = web;
    }

    public boolean statsValid() {
        return this.statsValid;
    }

    public boolean registrationValid() {
        return this.registrationValid;
    }

    public boolean haStateValid() {
        return this.haStateValid;
    }

    public FederationNamenodeServiceState getState() {
        if (!this.registrationValid) {
            return FederationNamenodeServiceState.UNAVAILABLE;
        }
        if (this.haStateValid) {
            return FederationNamenodeServiceState.getState(this.status);
        }
        return FederationNamenodeServiceState.ACTIVE;
    }

    public String getNameserviceId() {
        return this.nameserviceId;
    }

    public String getNamenodeId() {
        return this.namenodeId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public String getLifelineAddress() {
        return this.lifelineAddress;
    }

    public String getWebAddress() {
        return this.webAddress;
    }

    public String getWebScheme() {
        return this.webScheme;
    }

    public void setHAServiceState(HAServiceProtocol.HAServiceState state) {
        this.status = state;
        this.haStateValid = true;
    }

    public void setNamespaceInfo(NamespaceInfo info) {
        this.clusterId = info.getClusterID();
        this.blockPoolId = info.getBlockPoolID();
        this.registrationValid = true;
    }

    public void setSafeMode(boolean safemode) {
        this.safeMode = safemode;
    }

    public boolean getSafemode() {
        return this.safeMode;
    }

    public void setDatanodeInfo(int numLive, int numDead, int numStale, int numDecom, int numLiveDecom, int numDeadDecom, int numInMaintenanceLive, int numInMaintenanceDead, int numEnteringMaintenance, long numScheduledReplicationBlocks) {
        this.liveDatanodes = numLive;
        this.deadDatanodes = numDead;
        this.staleDatanodes = numStale;
        this.decomDatanodes = numDecom;
        this.liveDecomDatanodes = numLiveDecom;
        this.deadDecomDatanodes = numDeadDecom;
        this.inMaintenanceLiveDataNodes = numInMaintenanceLive;
        this.inMaintenanceDeadDataNodes = numInMaintenanceDead;
        this.enteringMaintenanceDataNodes = numEnteringMaintenance;
        this.statsValid = true;
        this.scheduledReplicationBlocks = numScheduledReplicationBlocks;
    }

    public int getNumLiveDatanodes() {
        return this.liveDatanodes;
    }

    public int getNumDeadDatanodes() {
        return this.deadDatanodes;
    }

    public int getNumStaleDatanodes() {
        return this.staleDatanodes;
    }

    public int getNumDecommissioningDatanodes() {
        return this.decomDatanodes;
    }

    public int getNumDecomLiveDatanodes() {
        return this.liveDecomDatanodes;
    }

    public int getNumDecomDeadDatanodes() {
        return this.deadDecomDatanodes;
    }

    public int getNumInMaintenanceLiveDataNodes() {
        return this.inMaintenanceLiveDataNodes;
    }

    public int getNumInMaintenanceDeadDataNodes() {
        return this.inMaintenanceDeadDataNodes;
    }

    public int getNumEnteringMaintenanceDataNodes() {
        return this.enteringMaintenanceDataNodes;
    }

    public void setNamesystemInfo(long available, long total, long numFiles, long numBlocks, long numBlocksMissing, long numBlocksPendingReplication, long numBlocksUnderReplicated, long numBlocksPendingDeletion, long providedStorageSpace, int numPendingSPSPaths) {
        this.totalSpace = total;
        this.availableSpace = available;
        this.numOfBlocks = numBlocks;
        this.numOfBlocksMissing = numBlocksMissing;
        this.numOfBlocksPendingReplication = numBlocksPendingReplication;
        this.numOfBlocksUnderReplicated = numBlocksUnderReplicated;
        this.numOfBlocksPendingDeletion = numBlocksPendingDeletion;
        this.numOfFiles = numFiles;
        this.statsValid = true;
        this.providedSpace = providedStorageSpace;
        this.pendingSPSPaths = numPendingSPSPaths;
    }

    public void setNamenodeInfo(int numCorruptFiles, long numOfMissingBlocksWithReplicationFactorOne, long numOfBadlyDistributedBlocks, long highestPriorityLowRedundancyRepBlocks, long highPriorityLowRedundancyECBlocks) {
        this.corruptFilesCount = numCorruptFiles;
        this.numberOfMissingBlocksWithReplicationFactorOne = numOfMissingBlocksWithReplicationFactorOne;
        this.numberOfBadlyDistributedBlocks = numOfBadlyDistributedBlocks;
        this.highestPriorityLowRedundancyReplicatedBlocks = highestPriorityLowRedundancyRepBlocks;
        this.highestPriorityLowRedundancyECBlocks = highPriorityLowRedundancyECBlocks;
    }

    public int getCorruptFilesCount() {
        return this.corruptFilesCount;
    }

    public long getScheduledReplicationBlocks() {
        return this.scheduledReplicationBlocks;
    }

    public long getNumberOfMissingBlocksWithReplicationFactorOne() {
        return this.numberOfMissingBlocksWithReplicationFactorOne;
    }

    public long getNumberOfBadlyDistributedBlocks() {
        return this.numberOfBadlyDistributedBlocks;
    }

    public long getHighestPriorityLowRedundancyReplicatedBlocks() {
        return this.highestPriorityLowRedundancyReplicatedBlocks;
    }

    public long getHighestPriorityLowRedundancyECBlocks() {
        return this.highestPriorityLowRedundancyECBlocks;
    }

    public int getPendingSPSPaths() {
        return this.pendingSPSPaths;
    }

    public long getNumBlocks() {
        return this.numOfBlocks;
    }

    public long getNumFiles() {
        return this.numOfFiles;
    }

    public long getTotalSpace() {
        return this.totalSpace;
    }

    public long getAvailableSpace() {
        return this.availableSpace;
    }

    public long getProvidedSpace() {
        return this.providedSpace;
    }

    public long getNumBlocksMissing() {
        return this.numOfBlocksMissing;
    }

    public long getNumOfBlocksPendingReplication() {
        return this.numOfBlocksPendingReplication;
    }

    public long getNumOfBlocksUnderReplicated() {
        return this.numOfBlocksUnderReplicated;
    }

    public long getNumOfBlocksPendingDeletion() {
        return this.numOfBlocksPendingDeletion;
    }

    public void setRegistrationValid(boolean isValid) {
        this.registrationValid = isValid;
    }

    public String toString() {
        return String.format("%s-%s:%s", this.nameserviceId, this.namenodeId, this.serviceAddress);
    }
}

