/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.metrics;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.Util;
import org.apache.hadoop.hdfs.server.federation.metrics.RBFMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamespaceInfo;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.SubClusterTimeoutException;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamespaceInfoResponse;
import org.apache.hadoop.hdfs.server.namenode.NameNodeMXBean;
import org.apache.hadoop.hdfs.server.namenode.NameNodeStatusMXBean;
import org.apache.hadoop.hdfs.server.namenode.metrics.FSNamesystemMBean;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.thirdparty.com.google.common.cache.CacheLoader;
import org.apache.hadoop.thirdparty.com.google.common.cache.LoadingCache;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.util.VersionInfo;
import org.eclipse.jetty.util.ajax.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamenodeBeanMetrics
implements FSNamesystemMBean,
NameNodeMXBean,
NameNodeStatusMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(NamenodeBeanMetrics.class);
    private final Router router;
    private ObjectName fsBeanName;
    private ObjectName fsStateBeanName;
    private ObjectName nnInfoBeanName;
    private ObjectName nnStatusBeanName;
    private final long dnReportTimeOut;
    private final LoadingCache<HdfsConstants.DatanodeReportType, String> dnCache;

    public NamenodeBeanMetrics(Router router) {
        StandardMBean bean;
        this.router = router;
        try {
            bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.fsBeanName = MBeans.register((String)"NameNode", (String)"FSNamesystem", (Object)bean);
            LOG.info("Registered FSNamesystem MBean: {}", (Object)this.fsBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad FSNamesystem MBean setup", e);
        }
        try {
            bean = new StandardMBean(this, FSNamesystemMBean.class);
            this.fsStateBeanName = MBeans.register((String)"NameNode", (String)"FSNamesystemState", (Object)bean);
            LOG.info("Registered FSNamesystemState MBean: {}", (Object)this.fsStateBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad FSNamesystemState MBean setup", e);
        }
        try {
            bean = new StandardMBean(this, NameNodeMXBean.class);
            this.nnInfoBeanName = MBeans.register((String)"NameNode", (String)"NameNodeInfo", (Object)bean);
            LOG.info("Registered NameNodeInfo MBean: {}", (Object)this.nnInfoBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad NameNodeInfo MBean setup", e);
        }
        try {
            bean = new StandardMBean(this, NameNodeStatusMXBean.class);
            this.nnStatusBeanName = MBeans.register((String)"NameNode", (String)"NameNodeStatus", (Object)bean);
            LOG.info("Registered NameNodeStatus MBean: {}", (Object)this.nnStatusBeanName);
        }
        catch (NotCompliantMBeanException e) {
            throw new RuntimeException("Bad NameNodeStatus MBean setup", e);
        }
        Configuration conf = router.getConfig();
        this.dnReportTimeOut = conf.getTimeDuration("dfs.federation.router.dn-report.time-out", 1000L, TimeUnit.MILLISECONDS);
        long dnCacheExpire = conf.getTimeDuration("dfs.federation.router.dn-report.cache-expire", RBFConfigKeys.DN_REPORT_CACHE_EXPIRE_MS_DEFAULT, TimeUnit.MILLISECONDS);
        this.dnCache = CacheBuilder.newBuilder().expireAfterWrite(dnCacheExpire, TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<HdfsConstants.DatanodeReportType, String>(){

            public String load(HdfsConstants.DatanodeReportType type) throws Exception {
                return NamenodeBeanMetrics.this.getNodesImpl(type);
            }
        });
    }

    public void close() {
        if (this.fsStateBeanName != null) {
            MBeans.unregister((ObjectName)this.fsStateBeanName);
            this.fsStateBeanName = null;
        }
        if (this.nnInfoBeanName != null) {
            MBeans.unregister((ObjectName)this.nnInfoBeanName);
            this.nnInfoBeanName = null;
        }
        if (this.nnStatusBeanName != null) {
            MBeans.unregister((ObjectName)this.nnStatusBeanName);
            this.nnStatusBeanName = null;
        }
    }

    private RBFMetrics getRBFMetrics() throws IOException {
        RBFMetrics metrics = this.getRouter().getMetrics();
        if (metrics == null) {
            throw new IOException("Federated metrics is not initialized");
        }
        return metrics;
    }

    public String getVersion() {
        return VersionInfo.getVersion() + ", r" + VersionInfo.getRevision();
    }

    public String getSoftwareVersion() {
        return VersionInfo.getVersion();
    }

    public long getUsed() {
        try {
            return this.getRBFMetrics().getUsedCapacity();
        }
        catch (IOException e) {
            LOG.debug("Failed to get the used capacity", (Throwable)e);
            return 0L;
        }
    }

    public long getFree() {
        try {
            return this.getRBFMetrics().getRemainingCapacity();
        }
        catch (IOException e) {
            LOG.debug("Failed to get remaining capacity", (Throwable)e);
            return 0L;
        }
    }

    public long getTotal() {
        try {
            return this.getRBFMetrics().getTotalCapacity();
        }
        catch (IOException e) {
            LOG.debug("Failed to Get total capacity", (Throwable)e);
            return 0L;
        }
    }

    public long getProvidedCapacity() {
        try {
            return this.getRBFMetrics().getProvidedSpace();
        }
        catch (IOException e) {
            LOG.debug("Failed to get provided capacity", (Throwable)e);
            return 0L;
        }
    }

    public String getSafemode() {
        try {
            return this.getRBFMetrics().getSafemode();
        }
        catch (IOException e) {
            return "Failed to get safemode status. Please check routerlog for more detail.";
        }
    }

    public boolean isUpgradeFinalized() {
        return true;
    }

    public RollingUpgradeInfo.Bean getRollingUpgradeStatus() {
        return null;
    }

    public long getNonDfsUsedSpace() {
        return 0L;
    }

    public float getPercentUsed() {
        return DFSUtilClient.getPercentUsed((long)this.getCapacityUsed(), (long)this.getCapacityTotal());
    }

    public float getPercentRemaining() {
        return DFSUtilClient.getPercentUsed((long)this.getCapacityRemaining(), (long)this.getCapacityTotal());
    }

    public long getCacheUsed() {
        return 0L;
    }

    public long getCacheCapacity() {
        return 0L;
    }

    public long getBlockPoolUsedSpace() {
        return 0L;
    }

    public float getPercentBlockPoolUsed() {
        return 0.0f;
    }

    public long getTotalBlocks() {
        try {
            return this.getRBFMetrics().getNumBlocks();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of blocks", (Throwable)e);
            return 0L;
        }
    }

    public long getNumberOfMissingBlocks() {
        try {
            return this.getRBFMetrics().getNumOfMissingBlocks();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of missing blocks", (Throwable)e);
            return 0L;
        }
    }

    @Deprecated
    public long getPendingReplicationBlocks() {
        try {
            return this.getRBFMetrics().getNumOfBlocksPendingReplication();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of blocks pending replica", (Throwable)e);
            return 0L;
        }
    }

    public long getPendingReconstructionBlocks() {
        try {
            return this.getRBFMetrics().getNumOfBlocksPendingReplication();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of blocks pending replica", (Throwable)e);
            return 0L;
        }
    }

    @Deprecated
    public long getUnderReplicatedBlocks() {
        try {
            return this.getRBFMetrics().getNumOfBlocksUnderReplicated();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of blocks under replicated", (Throwable)e);
            return 0L;
        }
    }

    public long getLowRedundancyBlocks() {
        try {
            return this.getRBFMetrics().getNumOfBlocksUnderReplicated();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of blocks under replicated", (Throwable)e);
            return 0L;
        }
    }

    public long getPendingDeletionBlocks() {
        try {
            return this.getRBFMetrics().getNumOfBlocksPendingDeletion();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of blocks pending deletion", (Throwable)e);
            return 0L;
        }
    }

    public long getScheduledReplicationBlocks() {
        try {
            return this.getRBFMetrics().getScheduledReplicationBlocks();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of scheduled replication blocks", (Throwable)e);
            return 0L;
        }
    }

    public long getNumberOfMissingBlocksWithReplicationFactorOne() {
        try {
            return this.getRBFMetrics().getNumberOfMissingBlocksWithReplicationFactorOne();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of missing blocks with replication factor one.", (Throwable)e);
            return 0L;
        }
    }

    public long getNumberOfBadlyDistributedBlocks() {
        try {
            return this.getRBFMetrics().getNumberOfBadlyDistributedBlocks();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of badly distributed blocks", (Throwable)e);
            return 0L;
        }
    }

    public long getHighestPriorityLowRedundancyReplicatedBlocks() {
        try {
            return this.getRBFMetrics().getHighestPriorityLowRedundancyReplicatedBlocks();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of highest priority low redundancy replicated blocks.", (Throwable)e);
            return 0L;
        }
    }

    public long getHighestPriorityLowRedundancyECBlocks() {
        try {
            return this.getRBFMetrics().getHighestPriorityLowRedundancyECBlocks();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of highest priority low redundancy EC blocks.", (Throwable)e);
            return 0L;
        }
    }

    public String getCorruptFiles() {
        return "N/A";
    }

    public int getCorruptFilesCount() {
        try {
            return this.getRBFMetrics().getCorruptFilesCount();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of corrupt files", (Throwable)e);
            return 0;
        }
    }

    public int getThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    public String getLiveNodes() {
        return this.getNodes(HdfsConstants.DatanodeReportType.LIVE);
    }

    public String getDeadNodes() {
        return this.getNodes(HdfsConstants.DatanodeReportType.DEAD);
    }

    public String getDecomNodes() {
        return this.getNodes(HdfsConstants.DatanodeReportType.DECOMMISSIONING);
    }

    private String getNodes(HdfsConstants.DatanodeReportType type) {
        try {
            return (String)this.dnCache.get((Object)type);
        }
        catch (ExecutionException e) {
            LOG.error("Cannot get the DN storage report for {}", (Object)type, (Object)e);
            return "{}";
        }
    }

    private String getNodesImpl(HdfsConstants.DatanodeReportType type) {
        HashMap info = new HashMap();
        try {
            RouterClientProtocol clientProtocol = this.router.getRpcServer().getClientProtocolModule();
            DatanodeStorageReport[] datanodeStorageReports = clientProtocol.getDatanodeStorageReport(type, false, this.dnReportTimeOut);
            if (this.router.getRpcServer().isAsync()) {
                datanodeStorageReports = AsyncUtil.syncReturn(DatanodeStorageReport[].class);
            }
            for (DatanodeStorageReport datanodeStorageReport : datanodeStorageReports) {
                DatanodeInfo node = datanodeStorageReport.getDatanodeInfo();
                StorageReport[] storageReports = datanodeStorageReport.getStorageReports();
                HashMap<String, Object> innerinfo = new HashMap<String, Object>();
                innerinfo.put("infoAddr", node.getInfoAddr());
                innerinfo.put("infoSecureAddr", node.getInfoSecureAddr());
                innerinfo.put("xferaddr", node.getXferAddr());
                innerinfo.put("location", node.getNetworkLocation());
                innerinfo.put("uuid", Optional.ofNullable(node.getDatanodeUuid()).orElse(""));
                innerinfo.put("lastContact", this.getLastContact(node));
                innerinfo.put("usedSpace", node.getDfsUsed());
                innerinfo.put("adminState", node.getAdminState().toString());
                innerinfo.put("nonDfsUsedSpace", node.getNonDfsUsed());
                innerinfo.put("capacity", node.getCapacity());
                innerinfo.put("numBlocks", node.getNumBlocks());
                innerinfo.put("version", node.getSoftwareVersion() == null ? "UNKNOWN" : node.getSoftwareVersion());
                innerinfo.put("used", node.getDfsUsed());
                innerinfo.put("remaining", node.getRemaining());
                innerinfo.put("blockScheduled", -1);
                innerinfo.put("blockPoolUsed", node.getBlockPoolUsed());
                innerinfo.put("blockPoolUsedPercent", Float.valueOf(node.getBlockPoolUsedPercent()));
                innerinfo.put("volfails", -1);
                innerinfo.put("blockPoolUsedPercentStdDev", Float.valueOf(Util.getBlockPoolUsedPercentStdDev((StorageReport[])storageReports)));
                innerinfo.put("lastBlockReport", this.getLastBlockReport(node));
                info.put(node.getXferAddrWithHostname(), Collections.unmodifiableMap(innerinfo));
            }
        }
        catch (StandbyException e) {
            LOG.error("Cannot get {} nodes, Router in safe mode", (Object)type);
        }
        catch (SubClusterTimeoutException e) {
            LOG.error("Cannot get {} nodes, subclusters timed out responding", (Object)type);
        }
        catch (Exception e) {
            LOG.error("Cannot get " + type + " nodes", (Throwable)e);
        }
        return JSON.toString(info);
    }

    public String getClusterId() {
        try {
            return this.getNamespaceInfo(FederationNamespaceInfo::getClusterId).toString();
        }
        catch (IOException e) {
            LOG.error("Cannot fetch cluster ID metrics {}", (Object)e.getMessage());
            return "";
        }
    }

    public String getBlockPoolId() {
        try {
            return this.getNamespaceInfo(FederationNamespaceInfo::getBlockPoolId).toString();
        }
        catch (IOException e) {
            LOG.error("Cannot fetch block pool ID metrics {}", (Object)e.getMessage());
            return "";
        }
    }

    private Collection<String> getNamespaceInfo(Function<FederationNamespaceInfo, String> f) throws IOException {
        StateStoreService stateStore = this.router.getStateStore();
        MembershipStore membershipStore = stateStore.getRegisteredRecordStore(MembershipStore.class);
        GetNamespaceInfoRequest request = GetNamespaceInfoRequest.newInstance();
        GetNamespaceInfoResponse response = membershipStore.getNamespaceInfo(request);
        return response.getNamespaceInfo().stream().map(f).collect(Collectors.toSet());
    }

    public String getNameDirStatuses() {
        return "N/A";
    }

    public String getNodeUsage() {
        return "N/A";
    }

    public String getNameJournalStatus() {
        return "N/A";
    }

    public String getJournalTransactionInfo() {
        return "N/A";
    }

    public long getNNStartedTimeInMillis() {
        try {
            return this.getRouter().getStartTime();
        }
        catch (IOException e) {
            LOG.debug("Failed to get the router startup time", (Throwable)e);
            return 0L;
        }
    }

    public String getCompileInfo() {
        return VersionInfo.getDate() + " by " + VersionInfo.getUser() + " from " + VersionInfo.getBranch();
    }

    public int getDistinctVersionCount() {
        return 0;
    }

    public Map<String, Integer> getDistinctVersions() {
        return null;
    }

    public String getFSState() {
        return "Operational";
    }

    public long getBlocksTotal() {
        return this.getTotalBlocks();
    }

    public long getCapacityTotal() {
        return this.getTotal();
    }

    public long getCapacityRemaining() {
        return this.getFree();
    }

    public long getCapacityUsed() {
        return this.getUsed();
    }

    public long getProvidedCapacityTotal() {
        return this.getProvidedCapacity();
    }

    public long getFilesTotal() {
        try {
            return this.getRBFMetrics().getNumFiles();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of files", (Throwable)e);
            return 0L;
        }
    }

    public int getTotalLoad() {
        return -1;
    }

    public int getNumLiveDataNodes() {
        try {
            return this.getRBFMetrics().getNumLiveNodes();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of live nodes", (Throwable)e);
            return 0;
        }
    }

    public int getNumDeadDataNodes() {
        try {
            return this.getRBFMetrics().getNumDeadNodes();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of dead nodes", (Throwable)e);
            return 0;
        }
    }

    public int getNumStaleDataNodes() {
        try {
            return this.getRBFMetrics().getNumStaleNodes();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of stale nodes", (Throwable)e);
            return 0;
        }
    }

    public int getNumDecomLiveDataNodes() {
        try {
            return this.getRBFMetrics().getNumDecomLiveNodes();
        }
        catch (IOException e) {
            LOG.debug("Failed to get the number of live decommissioned datanodes", (Throwable)e);
            return 0;
        }
    }

    public int getNumDecomDeadDataNodes() {
        try {
            return this.getRBFMetrics().getNumDecomDeadNodes();
        }
        catch (IOException e) {
            LOG.debug("Failed to get the number of dead decommissioned datanodes", (Throwable)e);
            return 0;
        }
    }

    public int getNumDecommissioningDataNodes() {
        try {
            return this.getRBFMetrics().getNumDecommissioningNodes();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of decommissioning nodes", (Throwable)e);
            return 0;
        }
    }

    public int getNumInMaintenanceLiveDataNodes() {
        try {
            return this.getRBFMetrics().getNumInMaintenanceLiveDataNodes();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of live in maintenance nodes", (Throwable)e);
            return 0;
        }
    }

    public int getNumInMaintenanceDeadDataNodes() {
        try {
            return this.getRBFMetrics().getNumInMaintenanceDeadDataNodes();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of dead in maintenance nodes", (Throwable)e);
            return 0;
        }
    }

    public int getNumEnteringMaintenanceDataNodes() {
        try {
            return this.getRBFMetrics().getNumEnteringMaintenanceDataNodes();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of entering maintenance nodes", (Throwable)e);
            return 0;
        }
    }

    public int getNumInServiceLiveDataNodes() {
        return 0;
    }

    public int getVolumeFailuresTotal() {
        return 0;
    }

    public long getEstimatedCapacityLostTotal() {
        return 0L;
    }

    public String getSnapshotStats() {
        return null;
    }

    public long getMaxObjects() {
        return 0L;
    }

    public long getBlockDeletionStartTime() {
        return -1L;
    }

    public int getNumStaleStorages() {
        return -1;
    }

    public String getTopUserOpCounts() {
        return "N/A";
    }

    public int getFsLockQueueLength() {
        return 0;
    }

    public long getTotalSyncCount() {
        return 0L;
    }

    public String getTotalSyncTimes() {
        return "";
    }

    private long getLastContact(DatanodeInfo node) {
        return (Time.now() - node.getLastUpdate()) / 1000L;
    }

    private long getLastBlockReport(DatanodeInfo node) {
        return (Time.now() - node.getLastBlockReportTime()) / 60000L;
    }

    public String getNNRole() {
        return HdfsServerConstants.NamenodeRole.NAMENODE.toString();
    }

    public String getState() {
        return HAServiceProtocol.HAServiceState.ACTIVE.toString();
    }

    public String getHostAndPort() {
        return NetUtils.getHostPortString((InetSocketAddress)this.router.getRpcServerAddress());
    }

    public boolean isSecurityEnabled() {
        try {
            return this.getRBFMetrics().isSecurityEnabled();
        }
        catch (IOException e) {
            LOG.debug("Failed to get security status", (Throwable)e);
            return false;
        }
    }

    public long getLastHATransitionTime() {
        return 0L;
    }

    public long getBytesWithFutureGenerationStamps() {
        return 0L;
    }

    public String getSlowPeersReport() {
        return "N/A";
    }

    public String getSlowDisksReport() {
        return "N/A";
    }

    public long getNumberOfSnapshottableDirs() {
        return 0L;
    }

    public String getEnteringMaintenanceNodes() {
        return "{}";
    }

    public String getNameDirSize() {
        return "N/A";
    }

    public int getNumEncryptionZones() {
        return 0;
    }

    public String getVerifyECWithTopologyResult() {
        return null;
    }

    public long getCurrentTokensCount() {
        return 0L;
    }

    public int getPendingSPSPaths() {
        try {
            return this.getRBFMetrics().getPendingSPSPaths();
        }
        catch (IOException e) {
            LOG.debug("Failed to get number of paths to be processed by sps", (Throwable)e);
            return 0;
        }
    }

    public float getReconstructionQueuesInitProgress() {
        return 0.0f;
    }

    private Router getRouter() throws IOException {
        if (this.router == null) {
            throw new IOException("Router is not initialized");
        }
        return this.router;
    }
}

