/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.fairness;

import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.fairness.AbstractRouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterAsyncRpcFairnessPolicyController
extends AbstractRouterRpcFairnessPolicyController {
    private static final Logger LOG = LoggerFactory.getLogger(RouterAsyncRpcFairnessPolicyController.class);
    public static final String INIT_MSG = "Max async call permits per nameservice: %d";

    public RouterAsyncRpcFairnessPolicyController(Configuration conf) {
        this.init(conf);
    }

    @Override
    public void init(Configuration conf) throws IllegalArgumentException {
        super.init(conf);
        int maxAsyncCallPermit = conf.getInt("dfs.federation.router.async.rpc.max.asynccall.permit", 20000);
        if (maxAsyncCallPermit <= 0) {
            maxAsyncCallPermit = 20000;
        }
        LOG.info(String.format(INIT_MSG, maxAsyncCallPermit));
        Set<String> allConfiguredNS = FederationUtil.getAllConfiguredNS(conf);
        for (String nsId : allConfiguredNS) {
            LOG.info("Dedicated permits {} for ns {} ", (Object)maxAsyncCallPermit, (Object)nsId);
            this.insertNameServiceWithPermits(nsId, maxAsyncCallPermit);
            RouterAsyncRpcFairnessPolicyController.logAssignment(nsId, maxAsyncCallPermit);
        }
        this.insertNameServiceWithPermits("concurrent", maxAsyncCallPermit);
        LOG.info("Dedicated permits {} for ns {} ", (Object)maxAsyncCallPermit, (Object)"concurrent");
    }

    private static void logAssignment(String nsId, int count) {
        LOG.info("Assigned {} permits to nsId {} ", (Object)count, (Object)nsId);
    }

    @Override
    public boolean acquirePermit(String nsId) {
        if (nsId.equals("concurrent")) {
            return true;
        }
        return super.acquirePermit(nsId);
    }

    @Override
    public void releasePermit(String nsId) {
        if (nsId.equals("concurrent")) {
            return;
        }
        super.releasePermit(nsId);
    }
}

