/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.fairness;

import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.fairness.AbstractRouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProportionRouterRpcFairnessPolicyController
extends AbstractRouterRpcFairnessPolicyController {
    private static final Logger LOG = LoggerFactory.getLogger(ProportionRouterRpcFairnessPolicyController.class);
    private static final String DEFAULT_NS = "default_ns";

    public ProportionRouterRpcFairnessPolicyController(Configuration conf) {
        this.init(conf);
    }

    @Override
    public void init(Configuration conf) {
        super.init(conf);
        int handlerCount = conf.getInt("dfs.federation.router.handler.count", 10);
        LOG.info("Handlers available for fairness assignment {} ", (Object)handlerCount);
        Set<String> allConfiguredNS = FederationUtil.getAllConfiguredNS(conf);
        allConfiguredNS.add("concurrent");
        allConfiguredNS.add(DEFAULT_NS);
        for (String nsId : allConfiguredNS) {
            double dedicatedHandlerProportion = conf.getDouble("dfs.federation.router.fairness.handler.proportion." + nsId, 0.1);
            int dedicatedHandlers = (int)(dedicatedHandlerProportion * (double)handlerCount);
            LOG.info("Dedicated handlers {} for ns {} ", (Object)dedicatedHandlers, (Object)nsId);
            if (dedicatedHandlers <= 0) {
                dedicatedHandlers = 1;
            }
            this.insertNameServiceWithPermits(nsId, dedicatedHandlers);
            LOG.info("Assigned {} handlers to nsId {} ", (Object)dedicatedHandlers, (Object)nsId);
        }
    }

    @Override
    public boolean acquirePermit(String nsId) {
        if (this.contains(nsId)) {
            return super.acquirePermit(nsId);
        }
        return super.acquirePermit(DEFAULT_NS);
    }

    @Override
    public void releasePermit(String nsId) {
        if (this.contains(nsId)) {
            super.releasePermit(nsId);
        } else {
            super.releasePermit(DEFAULT_NS);
        }
    }
}

