/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.fairness;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.fairness.RouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.router.RBFConfigKeys;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractRouterRpcFairnessPolicyController
implements RouterRpcFairnessPolicyController {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractRouterRpcFairnessPolicyController.class);
    private Map<String, Semaphore> permits;
    private long acquireTimeoutMs = RBFConfigKeys.DFS_ROUTER_FAIRNESS_ACQUIRE_TIMEOUT_DEFAULT;

    public void init(Configuration conf) {
        this.permits = new HashMap<String, Semaphore>();
        long timeoutMs = conf.getTimeDuration("dfs.federation.router.fairness.acquire.timeout", RBFConfigKeys.DFS_ROUTER_FAIRNESS_ACQUIRE_TIMEOUT_DEFAULT, TimeUnit.MILLISECONDS);
        if (timeoutMs >= 0L) {
            this.acquireTimeoutMs = timeoutMs;
        } else {
            LOG.warn("Invalid value {} configured for {} should be greater than or equal to 0. Using default value of : {}ms instead.", new Object[]{timeoutMs, "dfs.federation.router.fairness.acquire.timeout", RBFConfigKeys.DFS_ROUTER_FAIRNESS_ACQUIRE_TIMEOUT_DEFAULT});
        }
    }

    @Override
    public boolean acquirePermit(String nsId) {
        try {
            LOG.debug("Taking lock for nameservice {}", (Object)nsId);
            return this.permits.get(nsId).tryAcquire(this.acquireTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.debug("Cannot get a permit for nameservice {}", (Object)nsId);
            return false;
        }
    }

    @Override
    public void releasePermit(String nsId) {
        this.permits.get(nsId).release();
    }

    @Override
    public void shutdown() {
        LOG.debug("Shutting down router fairness policy controller");
        for (Semaphore sema : this.permits.values()) {
            sema.drainPermits();
        }
    }

    protected void insertNameServiceWithPermits(String nsId, int maxPermits) {
        this.permits.put(nsId, new Semaphore(maxPermits));
    }

    @Override
    public int getAvailablePermits(String nsId) {
        return this.permits.get(nsId).availablePermits();
    }

    @Override
    public String getAvailableHandlerOnPerNs() {
        JSONObject json = new JSONObject();
        this.permits.forEach((k, v) -> {
            try {
                json.put(k, v.availablePermits());
            }
            catch (JSONException e) {
                LOG.warn("Cannot put {} into JSONObject", k, (Object)e);
            }
        });
        return json.toString();
    }

    @Override
    public boolean contains(String nsId) {
        return this.permits.containsKey(nsId);
    }
}

