/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.proto.HdfsServerProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.AsyncRpcProtocolPBUtil;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.ipc.Client;

public class RouterNamenodeProtocolTranslatorPB
extends NamenodeProtocolTranslatorPB {
    private static final NamenodeProtocolProtos.GetBlockKeysRequestProto VOID_GET_BLOCKKEYS_REQUEST = NamenodeProtocolProtos.GetBlockKeysRequestProto.newBuilder().build();
    private static final NamenodeProtocolProtos.GetTransactionIdRequestProto VOID_GET_TRANSACTIONID_REQUEST = NamenodeProtocolProtos.GetTransactionIdRequestProto.newBuilder().build();
    private static final NamenodeProtocolProtos.RollEditLogRequestProto VOID_ROLL_EDITLOG_REQUEST = NamenodeProtocolProtos.RollEditLogRequestProto.newBuilder().build();
    private static final HdfsServerProtos.VersionRequestProto VOID_VERSION_REQUEST = HdfsServerProtos.VersionRequestProto.newBuilder().build();
    private final NamenodeProtocolPB rpcProxy;

    public RouterNamenodeProtocolTranslatorPB(NamenodeProtocolPB rpcProxy) {
        super(rpcProxy);
        this.rpcProxy = rpcProxy;
    }

    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size, long minBlockSize, long timeInterval, StorageType storageType) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getBlocks(datanode, size, minBlockSize, timeInterval, storageType);
        }
        NamenodeProtocolProtos.GetBlocksRequestProto.Builder builder = NamenodeProtocolProtos.GetBlocksRequestProto.newBuilder().setDatanode(PBHelperClient.convert((DatanodeID)datanode)).setSize(size).setMinBlockSize(minBlockSize).setTimeInterval(timeInterval);
        if (storageType != null) {
            builder.setStorageType(PBHelperClient.convertStorageType((StorageType)storageType));
        }
        NamenodeProtocolProtos.GetBlocksRequestProto req = builder.build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getBlocks(null, req), res -> PBHelper.convert((HdfsServerProtos.BlocksWithLocationsProto)res.getBlocks()), BlocksWithLocations.class);
    }

    public ExportedBlockKeys getBlockKeys() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getBlockKeys();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getBlockKeys(null, VOID_GET_BLOCKKEYS_REQUEST), res -> res.hasKeys() ? PBHelper.convert((HdfsServerProtos.ExportedBlockKeysProto)res.getKeys()) : null, ExportedBlockKeys.class);
    }

    public long getTransactionID() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getTransactionID();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getTransactionId(null, VOID_GET_TRANSACTIONID_REQUEST), res -> res.getTxId(), Long.class);
    }

    public long getMostRecentCheckpointTxId() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getMostRecentCheckpointTxId();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getMostRecentCheckpointTxId(null, NamenodeProtocolProtos.GetMostRecentCheckpointTxIdRequestProto.getDefaultInstance()), res -> res.getTxId(), Long.class);
    }

    public long getMostRecentNameNodeFileTxId(NNStorage.NameNodeFile nnf) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getMostRecentNameNodeFileTxId(nnf);
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getMostRecentNameNodeFileTxId(null, NamenodeProtocolProtos.GetMostRecentNameNodeFileTxIdRequestProto.newBuilder().setNameNodeFile(nnf.toString()).build()), res -> res.getTxId(), Long.class);
    }

    public CheckpointSignature rollEditLog() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.rollEditLog();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.rollEditLog(null, VOID_ROLL_EDITLOG_REQUEST), res -> PBHelper.convert((HdfsServerProtos.CheckpointSignatureProto)res.getSignature()), CheckpointSignature.class);
    }

    public NamespaceInfo versionRequest() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.versionRequest();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.versionRequest(null, VOID_VERSION_REQUEST), res -> PBHelper.convert((HdfsServerProtos.NamespaceInfoProto)res.getInfo()), NamespaceInfo.class);
    }

    public void errorReport(NamenodeRegistration registration, int errorCode, String msg) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.errorReport(registration, errorCode, msg);
            return;
        }
        NamenodeProtocolProtos.ErrorReportRequestProto req = NamenodeProtocolProtos.ErrorReportRequestProto.newBuilder().setErrorCode(errorCode).setMsg(msg).setRegistration(PBHelper.convert((NamenodeRegistration)registration)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.errorReport(null, req), res -> null, Void.class);
    }

    public NamenodeRegistration registerSubordinateNamenode(NamenodeRegistration registration) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.registerSubordinateNamenode(registration);
        }
        NamenodeProtocolProtos.RegisterRequestProto req = NamenodeProtocolProtos.RegisterRequestProto.newBuilder().setRegistration(PBHelper.convert((NamenodeRegistration)registration)).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.registerSubordinateNamenode(null, req), res -> PBHelper.convert((HdfsServerProtos.NamenodeRegistrationProto)res.getRegistration()), NamenodeRegistration.class);
    }

    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.startCheckpoint(registration);
        }
        NamenodeProtocolProtos.StartCheckpointRequestProto req = NamenodeProtocolProtos.StartCheckpointRequestProto.newBuilder().setRegistration(PBHelper.convert((NamenodeRegistration)registration)).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.startCheckpoint(null, req), res -> {
            HdfsServerProtos.NamenodeCommandProto cmd = res.getCommand();
            return PBHelper.convert((HdfsServerProtos.NamenodeCommandProto)cmd);
        }, NamenodeCommand.class);
    }

    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.endCheckpoint(registration, sig);
            return;
        }
        NamenodeProtocolProtos.EndCheckpointRequestProto req = NamenodeProtocolProtos.EndCheckpointRequestProto.newBuilder().setRegistration(PBHelper.convert((NamenodeRegistration)registration)).setSignature(PBHelper.convert((CheckpointSignature)sig)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.endCheckpoint(null, req), res -> null, Void.class);
    }

    public RemoteEditLogManifest getEditLogManifest(long sinceTxId) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getEditLogManifest(sinceTxId);
        }
        NamenodeProtocolProtos.GetEditLogManifestRequestProto req = NamenodeProtocolProtos.GetEditLogManifestRequestProto.newBuilder().setSinceTxId(sinceTxId).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getEditLogManifest(null, req), res -> PBHelper.convert((HdfsServerProtos.RemoteEditLogManifestProto)res.getManifest()), RemoteEditLogManifest.class);
    }

    public boolean isUpgradeFinalized() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.isUpgradeFinalized();
        }
        NamenodeProtocolProtos.IsUpgradeFinalizedRequestProto req = NamenodeProtocolProtos.IsUpgradeFinalizedRequestProto.newBuilder().build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.isUpgradeFinalized(null, req), res -> res.getIsUpgradeFinalized(), Boolean.class);
    }

    public boolean isRollingUpgrade() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.isRollingUpgrade();
        }
        NamenodeProtocolProtos.IsRollingUpgradeRequestProto req = NamenodeProtocolProtos.IsRollingUpgradeRequestProto.newBuilder().build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.isRollingUpgrade(null, req), res -> res.getIsRollingUpgrade(), Boolean.class);
    }

    public Long getNextSPSPath() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getNextSPSPath();
        }
        NamenodeProtocolProtos.GetNextSPSPathRequestProto req = NamenodeProtocolProtos.GetNextSPSPathRequestProto.newBuilder().build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getNextSPSPath(null, req), res -> res.hasSpsPath() ? Long.valueOf(res.getSpsPath()) : null, Long.class);
    }
}

