/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsServerProtos;
import org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.AsyncRpcProtocolPBUtil;
import org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;

public class RouterNamenodeProtocolServerSideTranslatorPB
extends NamenodeProtocolServerSideTranslatorPB {
    private final RouterRpcServer server;
    private final boolean isAsyncRpc;

    public RouterNamenodeProtocolServerSideTranslatorPB(NamenodeProtocol impl) {
        super(impl);
        this.server = (RouterRpcServer)impl;
        this.isAsyncRpc = this.server.isAsync();
    }

    public NamenodeProtocolProtos.GetBlocksResponseProto getBlocks(RpcController unused, NamenodeProtocolProtos.GetBlocksRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.getBlocks(unused, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            DatanodeInfo dnInfo = new DatanodeInfo.DatanodeInfoBuilder().setNodeID(PBHelperClient.convert((HdfsProtos.DatanodeIDProto)request.getDatanode())).build();
            return this.server.getBlocks(dnInfo, request.getSize(), request.getMinBlockSize(), request.getTimeInterval(), request.hasStorageType() ? PBHelperClient.convertStorageType((HdfsProtos.StorageTypeProto)request.getStorageType()) : null);
        }, blocks -> NamenodeProtocolProtos.GetBlocksResponseProto.newBuilder().setBlocks(PBHelper.convert((BlocksWithLocations)blocks)).build());
        return null;
    }

    public NamenodeProtocolProtos.GetBlockKeysResponseProto getBlockKeys(RpcController unused, NamenodeProtocolProtos.GetBlockKeysRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.getBlockKeys(unused, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getBlockKeys, keys -> {
            NamenodeProtocolProtos.GetBlockKeysResponseProto.Builder builder = NamenodeProtocolProtos.GetBlockKeysResponseProto.newBuilder();
            if (keys != null) {
                builder.setKeys(PBHelper.convert((ExportedBlockKeys)keys));
            }
            return builder.build();
        });
        return null;
    }

    public NamenodeProtocolProtos.GetTransactionIdResponseProto getTransactionId(RpcController unused, NamenodeProtocolProtos.GetTransactionIdRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.getTransactionId(unused, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getTransactionID, txid -> NamenodeProtocolProtos.GetTransactionIdResponseProto.newBuilder().setTxId(txid.longValue()).build());
        return null;
    }

    public NamenodeProtocolProtos.GetMostRecentCheckpointTxIdResponseProto getMostRecentCheckpointTxId(RpcController unused, NamenodeProtocolProtos.GetMostRecentCheckpointTxIdRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.getMostRecentCheckpointTxId(unused, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getMostRecentCheckpointTxId, txid -> NamenodeProtocolProtos.GetMostRecentCheckpointTxIdResponseProto.newBuilder().setTxId(txid.longValue()).build());
        return null;
    }

    public NamenodeProtocolProtos.GetMostRecentNameNodeFileTxIdResponseProto getMostRecentNameNodeFileTxId(RpcController unused, NamenodeProtocolProtos.GetMostRecentNameNodeFileTxIdRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.getMostRecentNameNodeFileTxId(unused, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getMostRecentNameNodeFileTxId(NNStorage.NameNodeFile.valueOf((String)request.getNameNodeFile())), txid -> NamenodeProtocolProtos.GetMostRecentNameNodeFileTxIdResponseProto.newBuilder().setTxId(txid.longValue()).build());
        return null;
    }

    public NamenodeProtocolProtos.RollEditLogResponseProto rollEditLog(RpcController unused, NamenodeProtocolProtos.RollEditLogRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.rollEditLog(unused, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::rollEditLog, signature -> NamenodeProtocolProtos.RollEditLogResponseProto.newBuilder().setSignature(PBHelper.convert((CheckpointSignature)signature)).build());
        return null;
    }

    public NamenodeProtocolProtos.ErrorReportResponseProto errorReport(RpcController unused, NamenodeProtocolProtos.ErrorReportRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.errorReport(unused, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.errorReport(PBHelper.convert((HdfsServerProtos.NamenodeRegistrationProto)request.getRegistration()), request.getErrorCode(), request.getMsg());
            return null;
        }, result -> VOID_ERROR_REPORT_RESPONSE);
        return null;
    }

    public NamenodeProtocolProtos.RegisterResponseProto registerSubordinateNamenode(RpcController unused, NamenodeProtocolProtos.RegisterRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.registerSubordinateNamenode(unused, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.registerSubordinateNamenode(PBHelper.convert((HdfsServerProtos.NamenodeRegistrationProto)request.getRegistration())), reg -> NamenodeProtocolProtos.RegisterResponseProto.newBuilder().setRegistration(PBHelper.convert((NamenodeRegistration)reg)).build());
        return null;
    }

    public NamenodeProtocolProtos.StartCheckpointResponseProto startCheckpoint(RpcController unused, NamenodeProtocolProtos.StartCheckpointRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.startCheckpoint(unused, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.startCheckpoint(PBHelper.convert((HdfsServerProtos.NamenodeRegistrationProto)request.getRegistration())), cmd -> NamenodeProtocolProtos.StartCheckpointResponseProto.newBuilder().setCommand(PBHelper.convert((NamenodeCommand)cmd)).build());
        return null;
    }

    public NamenodeProtocolProtos.EndCheckpointResponseProto endCheckpoint(RpcController unused, NamenodeProtocolProtos.EndCheckpointRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.endCheckpoint(unused, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.endCheckpoint(PBHelper.convert((HdfsServerProtos.NamenodeRegistrationProto)request.getRegistration()), PBHelper.convert((HdfsServerProtos.CheckpointSignatureProto)request.getSignature()));
            return null;
        }, result -> VOID_END_CHECKPOINT_RESPONSE);
        return null;
    }

    public NamenodeProtocolProtos.GetEditLogManifestResponseProto getEditLogManifest(RpcController unused, NamenodeProtocolProtos.GetEditLogManifestRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.getEditLogManifest(unused, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getEditLogManifest(request.getSinceTxId()), manifest -> NamenodeProtocolProtos.GetEditLogManifestResponseProto.newBuilder().setManifest(PBHelper.convert((RemoteEditLogManifest)manifest)).build());
        return null;
    }

    public HdfsServerProtos.VersionResponseProto versionRequest(RpcController controller, HdfsServerProtos.VersionRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.versionRequest(controller, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::versionRequest, info -> HdfsServerProtos.VersionResponseProto.newBuilder().setInfo(PBHelper.convert((NamespaceInfo)info)).build());
        return null;
    }

    public NamenodeProtocolProtos.IsUpgradeFinalizedResponseProto isUpgradeFinalized(RpcController controller, NamenodeProtocolProtos.IsUpgradeFinalizedRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.isUpgradeFinalized(controller, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::isUpgradeFinalized, isUpgradeFinalized -> NamenodeProtocolProtos.IsUpgradeFinalizedResponseProto.newBuilder().setIsUpgradeFinalized(isUpgradeFinalized.booleanValue()).build());
        return null;
    }

    public NamenodeProtocolProtos.IsRollingUpgradeResponseProto isRollingUpgrade(RpcController controller, NamenodeProtocolProtos.IsRollingUpgradeRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.isRollingUpgrade(controller, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::isRollingUpgrade, isRollingUpgrade -> NamenodeProtocolProtos.IsRollingUpgradeResponseProto.newBuilder().setIsRollingUpgrade(isRollingUpgrade.booleanValue()).build());
        return null;
    }

    public NamenodeProtocolProtos.GetNextSPSPathResponseProto getNextSPSPath(RpcController controller, NamenodeProtocolProtos.GetNextSPSPathRequestProto request) throws ServiceException {
        if (!this.isAsyncRpc) {
            return super.getNextSPSPath(controller, request);
        }
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getNextSPSPath, nextSPSPath -> NamenodeProtocolProtos.GetNextSPSPathResponseProto.newBuilder().setSpsPath(nextSPSPath.longValue()).build());
        return null;
    }
}

