/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.BatchedRemoteIterator;
import org.apache.hadoop.fs.CacheFlag;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttr;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.inotify.EventBatchList;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.BatchedDirectoryListing;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsPartialListing;
import org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import org.apache.hadoop.hdfs.protocol.ReplicatedBlockStats;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshotStatus;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.EncryptionZonesProtos;
import org.apache.hadoop.hdfs.protocol.proto.ErasureCodingProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.protocolPB.AsyncRpcProtocolPBUtil;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.util.Lists;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class RouterClientProtocolTranslatorPB
extends ClientNamenodeProtocolTranslatorPB {
    private final ClientNamenodeProtocolPB rpcProxy;

    public RouterClientProtocolTranslatorPB(ClientNamenodeProtocolPB proxy) {
        super(proxy);
        this.rpcProxy = proxy;
    }

    public void close() {
        super.close();
    }

    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getBlockLocations(src, offset, length);
        }
        ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto req = ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto.newBuilder().setSrc(src).setOffset(offset).setLength(length).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getBlockLocations(null, req), res -> res.hasLocations() ? PBHelperClient.convert((HdfsProtos.LocatedBlocksProto)res.getLocations()) : null, LocatedBlocks.class);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getServerDefaults();
        }
        ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto req = VOID_GET_SERVER_DEFAULT_REQUEST;
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getServerDefaults(null, req), res -> PBHelperClient.convert((HdfsProtos.FsServerDefaultsProto)res.getServerDefaults()), FsServerDefaults.class);
    }

    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions, String ecPolicyName, String storagePolicy) throws IOException {
        FsPermission unmasked;
        if (!Client.isAsynchronousMode()) {
            return super.create(src, masked, clientName, flag, createParent, replication, blockSize, supportedVersions, ecPolicyName, storagePolicy);
        }
        ClientNamenodeProtocolProtos.CreateRequestProto.Builder builder = ClientNamenodeProtocolProtos.CreateRequestProto.newBuilder().setSrc(src).setMasked(PBHelperClient.convert((FsPermission)masked)).setClientName(clientName).setCreateFlag(PBHelperClient.convertCreateFlag(flag)).setCreateParent(createParent).setReplication((int)replication).setBlockSize(blockSize);
        if (ecPolicyName != null) {
            builder.setEcPolicyName(ecPolicyName);
        }
        if (storagePolicy != null) {
            builder.setStoragePolicy(storagePolicy);
        }
        if ((unmasked = masked.getUnmasked()) != null) {
            builder.setUnmasked(PBHelperClient.convert((FsPermission)unmasked));
        }
        builder.addAllCryptoProtocolVersion((Iterable)PBHelperClient.convert((CryptoProtocolVersion[])supportedVersions));
        ClientNamenodeProtocolProtos.CreateRequestProto req = builder.build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.create(null, req), res -> res.hasFs() ? PBHelperClient.convert((HdfsProtos.HdfsFileStatusProto)res.getFs()) : null, HdfsFileStatus.class);
    }

    public boolean truncate(String src, long newLength, String clientName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.truncate(src, newLength, clientName);
        }
        ClientNamenodeProtocolProtos.TruncateRequestProto req = ClientNamenodeProtocolProtos.TruncateRequestProto.newBuilder().setSrc(src).setNewLength(newLength).setClientName(clientName).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.truncate(null, req), res -> res.getResult(), Boolean.class);
    }

    public LastBlockWithStatus append(String src, String clientName, EnumSetWritable<CreateFlag> flag) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.append(src, clientName, flag);
        }
        ClientNamenodeProtocolProtos.AppendRequestProto req = ClientNamenodeProtocolProtos.AppendRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFlag(PBHelperClient.convertCreateFlag(flag)).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.append(null, req), res -> {
            LocatedBlock lastBlock = res.hasBlock() ? PBHelperClient.convertLocatedBlockProto((HdfsProtos.LocatedBlockProto)res.getBlock()) : null;
            HdfsFileStatus stat = res.hasStat() ? PBHelperClient.convert((HdfsProtos.HdfsFileStatusProto)res.getStat()) : null;
            return new LastBlockWithStatus(lastBlock, stat);
        }, LastBlockWithStatus.class);
    }

    public boolean setReplication(String src, short replication) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.setReplication(src, replication);
        }
        ClientNamenodeProtocolProtos.SetReplicationRequestProto req = ClientNamenodeProtocolProtos.SetReplicationRequestProto.newBuilder().setSrc(src).setReplication((int)replication).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.setReplication(null, req), res -> res.getResult(), Boolean.class);
    }

    public void setPermission(String src, FsPermission permission) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.setPermission(src, permission);
            return;
        }
        ClientNamenodeProtocolProtos.SetPermissionRequestProto req = ClientNamenodeProtocolProtos.SetPermissionRequestProto.newBuilder().setSrc(src).setPermission(PBHelperClient.convert((FsPermission)permission)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.setPermission(null, req), res -> null, null);
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.setOwner(src, username, groupname);
            return;
        }
        ClientNamenodeProtocolProtos.SetOwnerRequestProto.Builder req = ClientNamenodeProtocolProtos.SetOwnerRequestProto.newBuilder().setSrc(src);
        if (username != null) {
            req.setUsername(username);
        }
        if (groupname != null) {
            req.setGroupname(groupname);
        }
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.setOwner(null, req.build()), res -> null, null);
    }

    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.abandonBlock(b, fileId, src, holder);
            return;
        }
        ClientNamenodeProtocolProtos.AbandonBlockRequestProto req = ClientNamenodeProtocolProtos.AbandonBlockRequestProto.newBuilder().setB(PBHelperClient.convert((ExtendedBlock)b)).setSrc(src).setHolder(holder).setFileId(fileId).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.abandonBlock(null, req), res -> null, null);
    }

    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludeNodes, long fileId, String[] favoredNodes, EnumSet<AddBlockFlag> addBlockFlags) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.addBlock(src, clientName, previous, excludeNodes, fileId, favoredNodes, addBlockFlags);
        }
        ClientNamenodeProtocolProtos.AddBlockRequestProto.Builder req = ClientNamenodeProtocolProtos.AddBlockRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFileId(fileId);
        if (previous != null) {
            req.setPrevious(PBHelperClient.convert((ExtendedBlock)previous));
        }
        if (excludeNodes != null) {
            req.addAllExcludeNodes((Iterable)PBHelperClient.convert((DatanodeInfo[])excludeNodes));
        }
        if (favoredNodes != null) {
            req.addAllFavoredNodes(Arrays.asList(favoredNodes));
        }
        if (addBlockFlags != null) {
            req.addAllFlags((Iterable)PBHelperClient.convertAddBlockFlags(addBlockFlags));
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.addBlock(null, req.build()), res -> PBHelperClient.convertLocatedBlockProto((HdfsProtos.LocatedBlockProto)res.getBlock()), LocatedBlock.class);
    }

    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getAdditionalDatanode(src, fileId, blk, existings, existingStorageIDs, excludes, numAdditionalNodes, clientName);
        }
        ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto req = ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto.newBuilder().setSrc(src).setFileId(fileId).setBlk(PBHelperClient.convert((ExtendedBlock)blk)).addAllExistings((Iterable)PBHelperClient.convert((DatanodeInfo[])existings)).addAllExistingStorageUuids(Arrays.asList(existingStorageIDs)).addAllExcludes((Iterable)PBHelperClient.convert((DatanodeInfo[])excludes)).setNumAdditionalNodes(numAdditionalNodes).setClientName(clientName).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getAdditionalDatanode(null, req), res -> PBHelperClient.convertLocatedBlockProto((HdfsProtos.LocatedBlockProto)res.getBlock()), LocatedBlock.class);
    }

    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.complete(src, clientName, last, fileId);
        }
        ClientNamenodeProtocolProtos.CompleteRequestProto.Builder req = ClientNamenodeProtocolProtos.CompleteRequestProto.newBuilder().setSrc(src).setClientName(clientName).setFileId(fileId);
        if (last != null) {
            req.setLast(PBHelperClient.convert((ExtendedBlock)last));
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.complete(null, req.build()), res -> res.getResult(), Boolean.class);
    }

    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.reportBadBlocks(blocks);
            return;
        }
        ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto req = ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto.newBuilder().addAllBlocks(Arrays.asList(PBHelperClient.convertLocatedBlocks((LocatedBlock[])blocks))).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.reportBadBlocks(null, req), res -> null, Void.class);
    }

    public boolean rename(String src, String dst) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.rename(src, dst);
        }
        ClientNamenodeProtocolProtos.RenameRequestProto req = ClientNamenodeProtocolProtos.RenameRequestProto.newBuilder().setSrc(src).setDst(dst).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.rename(null, req), res -> res.getResult(), Boolean.class);
    }

    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.rename2(src, dst, options);
            return;
        }
        boolean overwrite = false;
        boolean toTrash = false;
        if (options != null) {
            for (Options.Rename option : options) {
                if (option == Options.Rename.OVERWRITE) {
                    overwrite = true;
                }
                if (option != Options.Rename.TO_TRASH) continue;
                toTrash = true;
            }
        }
        ClientNamenodeProtocolProtos.Rename2RequestProto req = ClientNamenodeProtocolProtos.Rename2RequestProto.newBuilder().setSrc(src).setDst(dst).setOverwriteDest(overwrite).setMoveToTrash(toTrash).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.rename2(null, req), res -> null, Void.class);
    }

    public void concat(String trg, String[] srcs) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.concat(trg, srcs);
            return;
        }
        ClientNamenodeProtocolProtos.ConcatRequestProto req = ClientNamenodeProtocolProtos.ConcatRequestProto.newBuilder().setTrg(trg).addAllSrcs(Arrays.asList(srcs)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.concat(null, req), res -> null, Void.class);
    }

    public boolean delete(String src, boolean recursive) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.delete(src, recursive);
        }
        ClientNamenodeProtocolProtos.DeleteRequestProto req = ClientNamenodeProtocolProtos.DeleteRequestProto.newBuilder().setSrc(src).setRecursive(recursive).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.delete(null, req), res -> res.getResult(), Boolean.class);
    }

    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.mkdirs(src, masked, createParent);
        }
        ClientNamenodeProtocolProtos.MkdirsRequestProto.Builder builder = ClientNamenodeProtocolProtos.MkdirsRequestProto.newBuilder().setSrc(src).setMasked(PBHelperClient.convert((FsPermission)masked)).setCreateParent(createParent);
        FsPermission unmasked = masked.getUnmasked();
        if (unmasked != null) {
            builder.setUnmasked(PBHelperClient.convert((FsPermission)unmasked));
        }
        ClientNamenodeProtocolProtos.MkdirsRequestProto req = builder.build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.mkdirs(null, req), res -> res.getResult(), Boolean.class);
    }

    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getListing(src, startAfter, needLocation);
        }
        ClientNamenodeProtocolProtos.GetListingRequestProto req = ClientNamenodeProtocolProtos.GetListingRequestProto.newBuilder().setSrc(src).setStartAfter(ByteString.copyFrom((byte[])startAfter)).setNeedLocation(needLocation).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getListing(null, req), res -> {
            if (res.hasDirList()) {
                return PBHelperClient.convert((HdfsProtos.DirectoryListingProto)res.getDirList());
            }
            return null;
        }, DirectoryListing.class);
    }

    public BatchedDirectoryListing getBatchedListing(String[] srcs, byte[] startAfter, boolean needLocation) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getBatchedListing(srcs, startAfter, needLocation);
        }
        ClientNamenodeProtocolProtos.GetBatchedListingRequestProto req = ClientNamenodeProtocolProtos.GetBatchedListingRequestProto.newBuilder().addAllPaths(Arrays.asList(srcs)).setStartAfter(ByteString.copyFrom((byte[])startAfter)).setNeedLocation(needLocation).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getBatchedListing(null, req), res -> {
            if (res.getListingsCount() > 0) {
                HdfsPartialListing[] listingArray = new HdfsPartialListing[res.getListingsCount()];
                int listingIdx = 0;
                for (HdfsProtos.BatchedDirectoryListingProto proto : res.getListingsList()) {
                    HdfsPartialListing listing;
                    if (proto.hasException()) {
                        HdfsProtos.RemoteExceptionProto reProto = proto.getException();
                        RemoteException ex = new RemoteException(reProto.getClassName(), reProto.getMessage());
                        listing = new HdfsPartialListing(proto.getParentIdx(), ex);
                    } else {
                        List statuses = PBHelperClient.convertHdfsFileStatus((List)proto.getPartialListingList());
                        listing = new HdfsPartialListing(proto.getParentIdx(), statuses);
                    }
                    listingArray[listingIdx++] = listing;
                }
                BatchedDirectoryListing batchedListing = new BatchedDirectoryListing(listingArray, res.getHasMore(), res.getStartAfter().toByteArray());
                return batchedListing;
            }
            return null;
        }, BatchedDirectoryListing.class);
    }

    public void renewLease(String clientName, List<String> namespaces) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.renewLease(clientName, namespaces);
            return;
        }
        ClientNamenodeProtocolProtos.RenewLeaseRequestProto.Builder builder = ClientNamenodeProtocolProtos.RenewLeaseRequestProto.newBuilder().setClientName(clientName);
        if (namespaces != null && !namespaces.isEmpty()) {
            builder.addAllNamespaces(namespaces);
        }
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.renewLease(null, builder.build()), res -> null, Void.class);
    }

    public boolean recoverLease(String src, String clientName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.recoverLease(src, clientName);
        }
        ClientNamenodeProtocolProtos.RecoverLeaseRequestProto req = ClientNamenodeProtocolProtos.RecoverLeaseRequestProto.newBuilder().setSrc(src).setClientName(clientName).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.recoverLease(null, req), res -> res.getResult(), Boolean.class);
    }

    public long[] getStats() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getStats();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getFsStats(null, VOID_GET_FSSTATUS_REQUEST), res -> PBHelperClient.convert((ClientNamenodeProtocolProtos.GetFsStatsResponseProto)res), long[].class);
    }

    public ReplicatedBlockStats getReplicatedBlockStats() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getReplicatedBlockStats();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getFsReplicatedBlockStats(null, VOID_GET_FS_REPLICATED_BLOCK_STATS_REQUEST), res -> PBHelperClient.convert((ClientNamenodeProtocolProtos.GetFsReplicatedBlockStatsResponseProto)res), ReplicatedBlockStats.class);
    }

    public ECBlockGroupStats getECBlockGroupStats() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getECBlockGroupStats();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getFsECBlockGroupStats(null, VOID_GET_FS_ECBLOCKGROUP_STATS_REQUEST), res -> PBHelperClient.convert((ClientNamenodeProtocolProtos.GetFsECBlockGroupStatsResponseProto)res), ECBlockGroupStats.class);
    }

    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getDatanodeReport(type);
        }
        ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto req = ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto.newBuilder().setType(PBHelperClient.convert((HdfsConstants.DatanodeReportType)type)).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getDatanodeReport(null, req), res -> PBHelperClient.convert((List)res.getDiList()), DatanodeInfo[].class);
    }

    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getDatanodeStorageReport(type);
        }
        ClientNamenodeProtocolProtos.GetDatanodeStorageReportRequestProto req = ClientNamenodeProtocolProtos.GetDatanodeStorageReportRequestProto.newBuilder().setType(PBHelperClient.convert((HdfsConstants.DatanodeReportType)type)).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getDatanodeStorageReport(null, req), res -> PBHelperClient.convertDatanodeStorageReports((List)res.getDatanodeStorageReportsList()), DatanodeStorageReport[].class);
    }

    public long getPreferredBlockSize(String filename) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getPreferredBlockSize(filename);
        }
        ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto req = ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto.newBuilder().setFilename(filename).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getPreferredBlockSize(null, req), res -> res.getBsize(), Long.class);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.setSafeMode(action, isChecked);
        }
        ClientNamenodeProtocolProtos.SetSafeModeRequestProto req = ClientNamenodeProtocolProtos.SetSafeModeRequestProto.newBuilder().setAction(PBHelperClient.convert((HdfsConstants.SafeModeAction)action)).setChecked(isChecked).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.setSafeMode(null, req), res -> res.getResult(), Boolean.class);
    }

    public boolean saveNamespace(long timeWindow, long txGap) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.saveNamespace(timeWindow, txGap);
        }
        ClientNamenodeProtocolProtos.SaveNamespaceRequestProto req = ClientNamenodeProtocolProtos.SaveNamespaceRequestProto.newBuilder().setTimeWindow(timeWindow).setTxGap(txGap).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.saveNamespace(null, req), res -> res.getSaved(), Boolean.class);
    }

    public long rollEdits() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.rollEdits();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.rollEdits(null, VOID_ROLLEDITS_REQUEST), res -> res.getNewSegmentTxId(), Long.class);
    }

    public boolean restoreFailedStorage(String arg) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.restoreFailedStorage(arg);
        }
        ClientNamenodeProtocolProtos.RestoreFailedStorageRequestProto req = ClientNamenodeProtocolProtos.RestoreFailedStorageRequestProto.newBuilder().setArg(arg).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.restoreFailedStorage(null, req), res -> res.getResult(), Boolean.class);
    }

    public void refreshNodes() throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.refreshNodes();
            return;
        }
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.refreshNodes(null, VOID_REFRESH_NODES_REQUEST), res -> null, Void.class);
    }

    public void finalizeUpgrade() throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.finalizeUpgrade();
            return;
        }
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.finalizeUpgrade(null, VOID_FINALIZE_UPGRADE_REQUEST), res -> null, Void.class);
    }

    public boolean upgradeStatus() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.upgradeStatus();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.upgradeStatus(null, VOID_UPGRADE_STATUS_REQUEST), res -> res.getUpgradeFinalized(), Boolean.class);
    }

    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.rollingUpgrade(action);
        }
        ClientNamenodeProtocolProtos.RollingUpgradeRequestProto r = ClientNamenodeProtocolProtos.RollingUpgradeRequestProto.newBuilder().setAction(PBHelperClient.convert((HdfsConstants.RollingUpgradeAction)action)).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.rollingUpgrade(null, r), res -> PBHelperClient.convert((ClientNamenodeProtocolProtos.RollingUpgradeInfoProto)res.getRollingUpgradeInfo()), RollingUpgradeInfo.class);
    }

    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.listCorruptFileBlocks(path, cookie);
        }
        ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto.Builder req = ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto.newBuilder().setPath(path);
        if (cookie != null) {
            req.setCookie(cookie);
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.listCorruptFileBlocks(null, req.build()), res -> PBHelperClient.convert((HdfsProtos.CorruptFileBlocksProto)res.getCorrupt()), CorruptFileBlocks.class);
    }

    public void metaSave(String filename) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.metaSave(filename);
            return;
        }
        ClientNamenodeProtocolProtos.MetaSaveRequestProto req = ClientNamenodeProtocolProtos.MetaSaveRequestProto.newBuilder().setFilename(filename).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.metaSave(null, req), res -> null, Void.class);
    }

    public HdfsFileStatus getFileInfo(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getFileInfo(src);
        }
        ClientNamenodeProtocolProtos.GetFileInfoRequestProto req = ClientNamenodeProtocolProtos.GetFileInfoRequestProto.newBuilder().setSrc(src).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getFileInfo(null, req), res -> res.hasFs() ? PBHelperClient.convert((HdfsProtos.HdfsFileStatusProto)res.getFs()) : null, HdfsFileStatus.class);
    }

    public HdfsLocatedFileStatus getLocatedFileInfo(String src, boolean needBlockToken) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getLocatedFileInfo(src, needBlockToken);
        }
        ClientNamenodeProtocolProtos.GetLocatedFileInfoRequestProto req = ClientNamenodeProtocolProtos.GetLocatedFileInfoRequestProto.newBuilder().setSrc(src).setNeedBlockToken(needBlockToken).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getLocatedFileInfo(null, req), res -> (HdfsLocatedFileStatus)(res.hasFs() ? PBHelperClient.convert((HdfsProtos.HdfsFileStatusProto)res.getFs()) : null), HdfsLocatedFileStatus.class);
    }

    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getFileLinkInfo(src);
        }
        ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto req = ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto.newBuilder().setSrc(src).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getFileLinkInfo(null, req), res -> res.hasFs() ? PBHelperClient.convert((HdfsProtos.HdfsFileStatusProto)res.getFs()) : null, HdfsFileStatus.class);
    }

    public ContentSummary getContentSummary(String path) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getContentSummary(path);
        }
        ClientNamenodeProtocolProtos.GetContentSummaryRequestProto req = ClientNamenodeProtocolProtos.GetContentSummaryRequestProto.newBuilder().setPath(path).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getContentSummary(null, req), res -> PBHelperClient.convert((HdfsProtos.ContentSummaryProto)res.getSummary()), ContentSummary.class);
    }

    public void setQuota(String path, long namespaceQuota, long storagespaceQuota, StorageType type) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.setQuota(path, namespaceQuota, storagespaceQuota, type);
            return;
        }
        ClientNamenodeProtocolProtos.SetQuotaRequestProto.Builder builder = ClientNamenodeProtocolProtos.SetQuotaRequestProto.newBuilder().setPath(path).setNamespaceQuota(namespaceQuota).setStoragespaceQuota(storagespaceQuota);
        if (type != null) {
            builder.setStorageType(PBHelperClient.convertStorageType((StorageType)type));
        }
        ClientNamenodeProtocolProtos.SetQuotaRequestProto req = builder.build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.setQuota(null, req), res -> null, Void.class);
    }

    public void fsync(String src, long fileId, String client, long lastBlockLength) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.fsync(src, fileId, client, lastBlockLength);
            return;
        }
        ClientNamenodeProtocolProtos.FsyncRequestProto req = ClientNamenodeProtocolProtos.FsyncRequestProto.newBuilder().setSrc(src).setClient(client).setLastBlockLength(lastBlockLength).setFileId(fileId).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.fsync(null, req), res -> null, Void.class);
    }

    public void setTimes(String src, long mtime, long atime) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.setTimes(src, mtime, atime);
            return;
        }
        ClientNamenodeProtocolProtos.SetTimesRequestProto req = ClientNamenodeProtocolProtos.SetTimesRequestProto.newBuilder().setSrc(src).setMtime(mtime).setAtime(atime).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.setTimes(null, req), res -> null, Void.class);
    }

    public void createSymlink(String target, String link, FsPermission dirPerm, boolean createParent) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.createSymlink(target, link, dirPerm, createParent);
            return;
        }
        ClientNamenodeProtocolProtos.CreateSymlinkRequestProto req = ClientNamenodeProtocolProtos.CreateSymlinkRequestProto.newBuilder().setTarget(target).setLink(link).setDirPerm(PBHelperClient.convert((FsPermission)dirPerm)).setCreateParent(createParent).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.createSymlink(null, req), res -> null, Void.class);
    }

    public String getLinkTarget(String path) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getLinkTarget(path);
        }
        ClientNamenodeProtocolProtos.GetLinkTargetRequestProto req = ClientNamenodeProtocolProtos.GetLinkTargetRequestProto.newBuilder().setPath(path).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getLinkTarget(null, req), res -> res.hasTargetPath() ? res.getTargetPath() : null, String.class);
    }

    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.updateBlockForPipeline(block, clientName);
        }
        ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto req = ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto.newBuilder().setBlock(PBHelperClient.convert((ExtendedBlock)block)).setClientName(clientName).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.updateBlockForPipeline(null, req), res -> PBHelperClient.convertLocatedBlockProto((HdfsProtos.LocatedBlockProto)res.getBlock()), LocatedBlock.class);
    }

    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] storageIDs) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.updatePipeline(clientName, oldBlock, newBlock, newNodes, storageIDs);
            return;
        }
        ClientNamenodeProtocolProtos.UpdatePipelineRequestProto req = ClientNamenodeProtocolProtos.UpdatePipelineRequestProto.newBuilder().setClientName(clientName).setOldBlock(PBHelperClient.convert((ExtendedBlock)oldBlock)).setNewBlock(PBHelperClient.convert((ExtendedBlock)newBlock)).addAllNewNodes(Arrays.asList(PBHelperClient.convert((DatanodeID[])newNodes))).addAllStorageIDs(storageIDs == null ? null : Arrays.asList(storageIDs)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.updatePipeline(null, req), res -> null, Void.class);
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getDelegationToken(renewer);
        }
        SecurityProtos.GetDelegationTokenRequestProto req = SecurityProtos.GetDelegationTokenRequestProto.newBuilder().setRenewer(renewer == null ? "" : renewer.toString()).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getDelegationToken(null, req), res -> res.hasToken() ? PBHelperClient.convertDelegationToken((SecurityProtos.TokenProto)res.getToken()) : null, Token.class);
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.renewDelegationToken(token);
        }
        SecurityProtos.RenewDelegationTokenRequestProto req = SecurityProtos.RenewDelegationTokenRequestProto.newBuilder().setToken(PBHelperClient.convert(token)).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.renewDelegationToken(null, req), res -> res.getNewExpiryTime(), Long.class);
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.cancelDelegationToken(token);
            return;
        }
        SecurityProtos.CancelDelegationTokenRequestProto req = SecurityProtos.CancelDelegationTokenRequestProto.newBuilder().setToken(PBHelperClient.convert(token)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.cancelDelegationToken(null, req), res -> null, Void.class);
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.setBalancerBandwidth(bandwidth);
            return;
        }
        ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto req = ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto.newBuilder().setBandwidth(bandwidth).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.setBalancerBandwidth(null, req), res -> null, Void.class);
    }

    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getDataEncryptionKey();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getDataEncryptionKey(null, VOID_GET_DATA_ENCRYPTIONKEY_REQUEST), res -> res.hasDataEncryptionKey() ? PBHelperClient.convert((HdfsProtos.DataEncryptionKeyProto)res.getDataEncryptionKey()) : null, DataEncryptionKey.class);
    }

    public boolean isFileClosed(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.isFileClosed(src);
        }
        ClientNamenodeProtocolProtos.IsFileClosedRequestProto req = ClientNamenodeProtocolProtos.IsFileClosedRequestProto.newBuilder().setSrc(src).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.isFileClosed(null, req), res -> res.getResult(), Boolean.class);
    }

    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.createSnapshot(snapshotRoot, snapshotName);
        }
        ClientNamenodeProtocolProtos.CreateSnapshotRequestProto.Builder builder = ClientNamenodeProtocolProtos.CreateSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot);
        if (snapshotName != null) {
            builder.setSnapshotName(snapshotName);
        }
        ClientNamenodeProtocolProtos.CreateSnapshotRequestProto req = builder.build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.createSnapshot(null, req), res -> res.getSnapshotPath(), String.class);
    }

    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.deleteSnapshot(snapshotRoot, snapshotName);
            return;
        }
        ClientNamenodeProtocolProtos.DeleteSnapshotRequestProto req = ClientNamenodeProtocolProtos.DeleteSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).setSnapshotName(snapshotName).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.deleteSnapshot(null, req), res -> null, Void.class);
    }

    public void allowSnapshot(String snapshotRoot) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.allowSnapshot(snapshotRoot);
            return;
        }
        ClientNamenodeProtocolProtos.AllowSnapshotRequestProto req = ClientNamenodeProtocolProtos.AllowSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.allowSnapshot(null, req), res -> null, Void.class);
    }

    public void disallowSnapshot(String snapshotRoot) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.disallowSnapshot(snapshotRoot);
            return;
        }
        ClientNamenodeProtocolProtos.DisallowSnapshotRequestProto req = ClientNamenodeProtocolProtos.DisallowSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.disallowSnapshot(null, req), res -> null, Void.class);
    }

    public void renameSnapshot(String snapshotRoot, String snapshotOldName, String snapshotNewName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.renameSnapshot(snapshotRoot, snapshotOldName, snapshotNewName);
            return;
        }
        ClientNamenodeProtocolProtos.RenameSnapshotRequestProto req = ClientNamenodeProtocolProtos.RenameSnapshotRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).setSnapshotOldName(snapshotOldName).setSnapshotNewName(snapshotNewName).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.renameSnapshot(null, req), res -> null, Void.class);
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getSnapshottableDirListing();
        }
        ClientNamenodeProtocolProtos.GetSnapshottableDirListingRequestProto req = ClientNamenodeProtocolProtos.GetSnapshottableDirListingRequestProto.newBuilder().build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getSnapshottableDirListing(null, req), res -> {
            if (res.hasSnapshottableDirList()) {
                return PBHelperClient.convert((HdfsProtos.SnapshottableDirectoryListingProto)res.getSnapshottableDirList());
            }
            return null;
        }, SnapshottableDirectoryStatus[].class);
    }

    public SnapshotStatus[] getSnapshotListing(String path) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getSnapshotListing(path);
        }
        ClientNamenodeProtocolProtos.GetSnapshotListingRequestProto req = ClientNamenodeProtocolProtos.GetSnapshotListingRequestProto.newBuilder().setSnapshotRoot(path).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getSnapshotListing(null, req), res -> {
            if (res.hasSnapshotList()) {
                return PBHelperClient.convert((HdfsProtos.SnapshotListingProto)res.getSnapshotList());
            }
            return null;
        }, SnapshotStatus[].class);
    }

    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String fromSnapshot, String toSnapshot) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getSnapshotDiffReport(snapshotRoot, fromSnapshot, toSnapshot);
        }
        ClientNamenodeProtocolProtos.GetSnapshotDiffReportRequestProto req = ClientNamenodeProtocolProtos.GetSnapshotDiffReportRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).setFromSnapshot(fromSnapshot).setToSnapshot(toSnapshot).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getSnapshotDiffReport(null, req), res -> PBHelperClient.convert((HdfsProtos.SnapshotDiffReportProto)res.getDiffReport()), SnapshotDiffReport.class);
    }

    public SnapshotDiffReportListing getSnapshotDiffReportListing(String snapshotRoot, String fromSnapshot, String toSnapshot, byte[] startPath, int index) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getSnapshotDiffReportListing(snapshotRoot, fromSnapshot, toSnapshot, startPath, index);
        }
        ClientNamenodeProtocolProtos.GetSnapshotDiffReportListingRequestProto req = ClientNamenodeProtocolProtos.GetSnapshotDiffReportListingRequestProto.newBuilder().setSnapshotRoot(snapshotRoot).setFromSnapshot(fromSnapshot).setToSnapshot(toSnapshot).setCursor(HdfsProtos.SnapshotDiffReportCursorProto.newBuilder().setStartPath(PBHelperClient.getByteString((byte[])startPath)).setIndex(index).build()).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getSnapshotDiffReportListing(null, req), res -> PBHelperClient.convert((HdfsProtos.SnapshotDiffReportListingProto)res.getDiffReport()), SnapshotDiffReportListing.class);
    }

    public long addCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.addCacheDirective(directive, flags);
        }
        ClientNamenodeProtocolProtos.AddCacheDirectiveRequestProto.Builder builder = ClientNamenodeProtocolProtos.AddCacheDirectiveRequestProto.newBuilder().setInfo(PBHelperClient.convert((CacheDirectiveInfo)directive));
        if (!flags.isEmpty()) {
            builder.setCacheFlags(PBHelperClient.convertCacheFlags(flags));
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.addCacheDirective(null, builder.build()), res -> res.getId(), Long.class);
    }

    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.modifyCacheDirective(directive, flags);
            return;
        }
        ClientNamenodeProtocolProtos.ModifyCacheDirectiveRequestProto.Builder builder = ClientNamenodeProtocolProtos.ModifyCacheDirectiveRequestProto.newBuilder().setInfo(PBHelperClient.convert((CacheDirectiveInfo)directive));
        if (!flags.isEmpty()) {
            builder.setCacheFlags(PBHelperClient.convertCacheFlags(flags));
        }
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.modifyCacheDirective(null, builder.build()), res -> null, Void.class);
    }

    public void removeCacheDirective(long id) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.removeCacheDirective(id);
            return;
        }
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.removeCacheDirective(null, ClientNamenodeProtocolProtos.RemoveCacheDirectiveRequestProto.newBuilder().setId(id).build()), res -> null, Void.class);
    }

    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.listCacheDirectives(prevId, filter);
        }
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        CacheDirectiveInfo f = filter;
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.listCacheDirectives(null, ClientNamenodeProtocolProtos.ListCacheDirectivesRequestProto.newBuilder().setPrevId(prevId).setFilter(PBHelperClient.convert((CacheDirectiveInfo)f)).build()), res -> new ClientNamenodeProtocolTranslatorPB.BatchedCacheEntries(res), BatchedRemoteIterator.BatchedEntries.class);
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.addCachePool(info);
            return;
        }
        ClientNamenodeProtocolProtos.AddCachePoolRequestProto.Builder builder = ClientNamenodeProtocolProtos.AddCachePoolRequestProto.newBuilder();
        builder.setInfo(PBHelperClient.convert((CachePoolInfo)info));
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.addCachePool(null, builder.build()), res -> null, Void.class);
    }

    public void modifyCachePool(CachePoolInfo req) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.modifyCachePool(req);
            return;
        }
        ClientNamenodeProtocolProtos.ModifyCachePoolRequestProto.Builder builder = ClientNamenodeProtocolProtos.ModifyCachePoolRequestProto.newBuilder();
        builder.setInfo(PBHelperClient.convert((CachePoolInfo)req));
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.modifyCachePool(null, builder.build()), res -> null, Void.class);
    }

    public void removeCachePool(String cachePoolName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.removeCachePool(cachePoolName);
            return;
        }
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.removeCachePool(null, ClientNamenodeProtocolProtos.RemoveCachePoolRequestProto.newBuilder().setPoolName(cachePoolName).build()), res -> null, Void.class);
    }

    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.listCachePools(prevKey);
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.listCachePools(null, ClientNamenodeProtocolProtos.ListCachePoolsRequestProto.newBuilder().setPrevPoolName(prevKey).build()), res -> new ClientNamenodeProtocolTranslatorPB.BatchedCachePoolEntries(res), BatchedRemoteIterator.BatchedEntries.class);
    }

    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.modifyAclEntries(src, aclSpec);
            return;
        }
        AclProtos.ModifyAclEntriesRequestProto req = AclProtos.ModifyAclEntriesRequestProto.newBuilder().setSrc(src).addAllAclSpec((Iterable)PBHelperClient.convertAclEntryProto(aclSpec)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.modifyAclEntries(null, req), res -> null, Void.class);
    }

    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.removeAclEntries(src, aclSpec);
            return;
        }
        AclProtos.RemoveAclEntriesRequestProto req = AclProtos.RemoveAclEntriesRequestProto.newBuilder().setSrc(src).addAllAclSpec((Iterable)PBHelperClient.convertAclEntryProto(aclSpec)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.removeAclEntries(null, req), res -> null, Void.class);
    }

    public void removeDefaultAcl(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.removeDefaultAcl(src);
            return;
        }
        AclProtos.RemoveDefaultAclRequestProto req = AclProtos.RemoveDefaultAclRequestProto.newBuilder().setSrc(src).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.removeDefaultAcl(null, req), res -> null, Void.class);
    }

    public void removeAcl(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.removeAcl(src);
            return;
        }
        AclProtos.RemoveAclRequestProto req = AclProtos.RemoveAclRequestProto.newBuilder().setSrc(src).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.removeAcl(null, req), res -> null, Void.class);
    }

    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.setAcl(src, aclSpec);
            return;
        }
        AclProtos.SetAclRequestProto req = AclProtos.SetAclRequestProto.newBuilder().setSrc(src).addAllAclSpec((Iterable)PBHelperClient.convertAclEntryProto(aclSpec)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.setAcl(null, req), res -> null, Void.class);
    }

    public AclStatus getAclStatus(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getAclStatus(src);
        }
        AclProtos.GetAclStatusRequestProto req = AclProtos.GetAclStatusRequestProto.newBuilder().setSrc(src).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getAclStatus(null, req), res -> PBHelperClient.convert((AclProtos.GetAclStatusResponseProto)res), AclStatus.class);
    }

    public void createEncryptionZone(String src, String keyName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.createEncryptionZone(src, keyName);
            return;
        }
        EncryptionZonesProtos.CreateEncryptionZoneRequestProto.Builder builder = EncryptionZonesProtos.CreateEncryptionZoneRequestProto.newBuilder();
        builder.setSrc(src);
        if (keyName != null && !keyName.isEmpty()) {
            builder.setKeyName(keyName);
        }
        EncryptionZonesProtos.CreateEncryptionZoneRequestProto req = builder.build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.createEncryptionZone(null, req), res -> null, Void.class);
    }

    public EncryptionZone getEZForPath(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getEZForPath(src);
        }
        EncryptionZonesProtos.GetEZForPathRequestProto.Builder builder = EncryptionZonesProtos.GetEZForPathRequestProto.newBuilder();
        builder.setSrc(src);
        EncryptionZonesProtos.GetEZForPathRequestProto req = builder.build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getEZForPath(null, req), res -> {
            if (res.hasZone()) {
                return PBHelperClient.convert((EncryptionZonesProtos.EncryptionZoneProto)res.getZone());
            }
            return null;
        }, EncryptionZone.class);
    }

    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long id) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.listEncryptionZones(id);
        }
        EncryptionZonesProtos.ListEncryptionZonesRequestProto req = EncryptionZonesProtos.ListEncryptionZonesRequestProto.newBuilder().setId(id).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.listEncryptionZones(null, req), res -> {
            ArrayList elements = Lists.newArrayListWithCapacity((int)res.getZonesCount());
            for (EncryptionZonesProtos.EncryptionZoneProto p : res.getZonesList()) {
                elements.add(PBHelperClient.convert((EncryptionZonesProtos.EncryptionZoneProto)p));
            }
            return new BatchedRemoteIterator.BatchedListEntries((List)elements, res.getHasMore());
        }, BatchedRemoteIterator.BatchedEntries.class);
    }

    public void setErasureCodingPolicy(String src, String ecPolicyName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.setErasureCodingPolicy(src, ecPolicyName);
            return;
        }
        ErasureCodingProtos.SetErasureCodingPolicyRequestProto.Builder builder = ErasureCodingProtos.SetErasureCodingPolicyRequestProto.newBuilder();
        builder.setSrc(src);
        if (ecPolicyName != null) {
            builder.setEcPolicyName(ecPolicyName);
        }
        ErasureCodingProtos.SetErasureCodingPolicyRequestProto req = builder.build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.setErasureCodingPolicy(null, req), res -> null, Void.class);
    }

    public void unsetErasureCodingPolicy(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.unsetErasureCodingPolicy(src);
            return;
        }
        ErasureCodingProtos.UnsetErasureCodingPolicyRequestProto.Builder builder = ErasureCodingProtos.UnsetErasureCodingPolicyRequestProto.newBuilder();
        builder.setSrc(src);
        ErasureCodingProtos.UnsetErasureCodingPolicyRequestProto req = builder.build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.unsetErasureCodingPolicy(null, req), res -> null, Void.class);
    }

    public ECTopologyVerifierResult getECTopologyResultForPolicies(String ... policyNames) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getECTopologyResultForPolicies(policyNames);
        }
        ErasureCodingProtos.GetECTopologyResultForPoliciesRequestProto.Builder builder = ErasureCodingProtos.GetECTopologyResultForPoliciesRequestProto.newBuilder();
        builder.addAllPolicies(Arrays.asList(policyNames));
        ErasureCodingProtos.GetECTopologyResultForPoliciesRequestProto req = builder.build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getECTopologyResultForPolicies(null, req), res -> PBHelperClient.convertECTopologyVerifierResultProto((HdfsProtos.ECTopologyVerifierResultProto)res.getResponse()), ECTopologyVerifierResult.class);
    }

    public void reencryptEncryptionZone(String zone, HdfsConstants.ReencryptAction action) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.reencryptEncryptionZone(zone, action);
            return;
        }
        EncryptionZonesProtos.ReencryptEncryptionZoneRequestProto.Builder builder = EncryptionZonesProtos.ReencryptEncryptionZoneRequestProto.newBuilder();
        builder.setZone(zone).setAction(PBHelperClient.convert((HdfsConstants.ReencryptAction)action));
        EncryptionZonesProtos.ReencryptEncryptionZoneRequestProto req = builder.build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.reencryptEncryptionZone(null, req), res -> null, Void.class);
    }

    public BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> listReencryptionStatus(long id) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.listReencryptionStatus(id);
        }
        EncryptionZonesProtos.ListReencryptionStatusRequestProto req = EncryptionZonesProtos.ListReencryptionStatusRequestProto.newBuilder().setId(id).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.listReencryptionStatus(null, req), res -> {
            ArrayList elements = Lists.newArrayListWithCapacity((int)res.getStatusesCount());
            for (EncryptionZonesProtos.ZoneReencryptionStatusProto p : res.getStatusesList()) {
                elements.add(PBHelperClient.convert((EncryptionZonesProtos.ZoneReencryptionStatusProto)p));
            }
            return new BatchedRemoteIterator.BatchedListEntries((List)elements, res.getHasMore());
        }, BatchedRemoteIterator.BatchedEntries.class);
    }

    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.setXAttr(src, xAttr, flag);
            return;
        }
        XAttrProtos.SetXAttrRequestProto req = XAttrProtos.SetXAttrRequestProto.newBuilder().setSrc(src).setXAttr(PBHelperClient.convertXAttrProto((XAttr)xAttr)).setFlag(PBHelperClient.convert(flag)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.setXAttr(null, req), res -> null, Void.class);
    }

    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getXAttrs(src, xAttrs);
        }
        XAttrProtos.GetXAttrsRequestProto.Builder builder = XAttrProtos.GetXAttrsRequestProto.newBuilder();
        builder.setSrc(src);
        if (xAttrs != null) {
            builder.addAllXAttrs((Iterable)PBHelperClient.convertXAttrProto(xAttrs));
        }
        XAttrProtos.GetXAttrsRequestProto req = builder.build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getXAttrs(null, req), res -> PBHelperClient.convert((XAttrProtos.GetXAttrsResponseProto)res), List.class);
    }

    public List<XAttr> listXAttrs(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.listXAttrs(src);
        }
        XAttrProtos.ListXAttrsRequestProto.Builder builder = XAttrProtos.ListXAttrsRequestProto.newBuilder();
        builder.setSrc(src);
        XAttrProtos.ListXAttrsRequestProto req = builder.build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.listXAttrs(null, req), res -> PBHelperClient.convert((XAttrProtos.ListXAttrsResponseProto)res), List.class);
    }

    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.removeXAttr(src, xAttr);
            return;
        }
        XAttrProtos.RemoveXAttrRequestProto req = XAttrProtos.RemoveXAttrRequestProto.newBuilder().setSrc(src).setXAttr(PBHelperClient.convertXAttrProto((XAttr)xAttr)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.removeXAttr(null, req), res -> null, Void.class);
    }

    public void checkAccess(String path, FsAction mode) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.checkAccess(path, mode);
            return;
        }
        ClientNamenodeProtocolProtos.CheckAccessRequestProto req = ClientNamenodeProtocolProtos.CheckAccessRequestProto.newBuilder().setPath(path).setMode(PBHelperClient.convert((FsAction)mode)).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.checkAccess(null, req), res -> null, Void.class);
    }

    public void setStoragePolicy(String src, String policyName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.setStoragePolicy(src, policyName);
            return;
        }
        ClientNamenodeProtocolProtos.SetStoragePolicyRequestProto req = ClientNamenodeProtocolProtos.SetStoragePolicyRequestProto.newBuilder().setSrc(src).setPolicyName(policyName).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.setStoragePolicy(null, req), res -> null, Void.class);
    }

    public void unsetStoragePolicy(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.unsetStoragePolicy(src);
            return;
        }
        ClientNamenodeProtocolProtos.UnsetStoragePolicyRequestProto req = ClientNamenodeProtocolProtos.UnsetStoragePolicyRequestProto.newBuilder().setSrc(src).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.unsetStoragePolicy(null, req), res -> null, Void.class);
    }

    public BlockStoragePolicy getStoragePolicy(String path) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getStoragePolicy(path);
        }
        ClientNamenodeProtocolProtos.GetStoragePolicyRequestProto request = ClientNamenodeProtocolProtos.GetStoragePolicyRequestProto.newBuilder().setPath(path).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getStoragePolicy(null, request), res -> PBHelperClient.convert((HdfsProtos.BlockStoragePolicyProto)res.getStoragePolicy()), BlockStoragePolicy.class);
    }

    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getStoragePolicies();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getStoragePolicies(null, VOID_GET_STORAGE_POLICIES_REQUEST), res -> PBHelperClient.convertStoragePolicies((List)res.getPoliciesList()), BlockStoragePolicy[].class);
    }

    public long getCurrentEditLogTxid() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getCurrentEditLogTxid();
        }
        ClientNamenodeProtocolProtos.GetCurrentEditLogTxidRequestProto req = ClientNamenodeProtocolProtos.GetCurrentEditLogTxidRequestProto.getDefaultInstance();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getCurrentEditLogTxid(null, req), res -> res.getTxid(), Long.class);
    }

    public EventBatchList getEditsFromTxid(long txid) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getEditsFromTxid(txid);
        }
        ClientNamenodeProtocolProtos.GetEditsFromTxidRequestProto req = ClientNamenodeProtocolProtos.GetEditsFromTxidRequestProto.newBuilder().setTxid(txid).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getEditsFromTxid(null, req), res -> PBHelperClient.convert((ClientNamenodeProtocolProtos.GetEditsFromTxidResponseProto)res), EventBatchList.class);
    }

    public AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] policies) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.addErasureCodingPolicies(policies);
        }
        List protos = Arrays.stream(policies).map(PBHelperClient::convertErasureCodingPolicy).collect(Collectors.toList());
        ErasureCodingProtos.AddErasureCodingPoliciesRequestProto req = ErasureCodingProtos.AddErasureCodingPoliciesRequestProto.newBuilder().addAllEcPolicies(protos).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.addErasureCodingPolicies(null, req), res -> (AddErasureCodingPolicyResponse[])res.getResponsesList().stream().map(PBHelperClient::convertAddErasureCodingPolicyResponse).toArray(AddErasureCodingPolicyResponse[]::new), AddErasureCodingPolicyResponse[].class);
    }

    public void removeErasureCodingPolicy(String ecPolicyName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.removeErasureCodingPolicy(ecPolicyName);
            return;
        }
        ErasureCodingProtos.RemoveErasureCodingPolicyRequestProto.Builder builder = ErasureCodingProtos.RemoveErasureCodingPolicyRequestProto.newBuilder();
        builder.setEcPolicyName(ecPolicyName);
        ErasureCodingProtos.RemoveErasureCodingPolicyRequestProto req = builder.build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.removeErasureCodingPolicy(null, req), res -> null, Void.class);
    }

    public void enableErasureCodingPolicy(String ecPolicyName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.enableErasureCodingPolicy(ecPolicyName);
            return;
        }
        ErasureCodingProtos.EnableErasureCodingPolicyRequestProto.Builder builder = ErasureCodingProtos.EnableErasureCodingPolicyRequestProto.newBuilder();
        builder.setEcPolicyName(ecPolicyName);
        ErasureCodingProtos.EnableErasureCodingPolicyRequestProto req = builder.build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.enableErasureCodingPolicy(null, req), res -> null, Void.class);
    }

    public void disableErasureCodingPolicy(String ecPolicyName) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.disableErasureCodingPolicy(ecPolicyName);
            return;
        }
        ErasureCodingProtos.DisableErasureCodingPolicyRequestProto.Builder builder = ErasureCodingProtos.DisableErasureCodingPolicyRequestProto.newBuilder();
        builder.setEcPolicyName(ecPolicyName);
        ErasureCodingProtos.DisableErasureCodingPolicyRequestProto req = builder.build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.disableErasureCodingPolicy(null, req), res -> null, Void.class);
    }

    public ErasureCodingPolicyInfo[] getErasureCodingPolicies() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getErasureCodingPolicies();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getErasureCodingPolicies(null, VOID_GET_EC_POLICIES_REQUEST), res -> {
            ErasureCodingPolicyInfo[] ecPolicies = new ErasureCodingPolicyInfo[res.getEcPoliciesCount()];
            int i = 0;
            for (HdfsProtos.ErasureCodingPolicyProto proto : res.getEcPoliciesList()) {
                ecPolicies[i++] = PBHelperClient.convertErasureCodingPolicyInfo((HdfsProtos.ErasureCodingPolicyProto)proto);
            }
            return ecPolicies;
        }, ErasureCodingPolicyInfo[].class);
    }

    public Map<String, String> getErasureCodingCodecs() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getErasureCodingCodecs();
        }
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getErasureCodingCodecs(null, VOID_GET_EC_CODEC_REQUEST), res -> {
            HashMap<String, String> ecCodecs = new HashMap<String, String>();
            for (ErasureCodingProtos.CodecProto codec : res.getCodecList()) {
                ecCodecs.put(codec.getCodec(), codec.getCoders());
            }
            return ecCodecs;
        }, Map.class);
    }

    public ErasureCodingPolicy getErasureCodingPolicy(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getErasureCodingPolicy(src);
        }
        ErasureCodingProtos.GetErasureCodingPolicyRequestProto req = ErasureCodingProtos.GetErasureCodingPolicyRequestProto.newBuilder().setSrc(src).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getErasureCodingPolicy(null, req), res -> {
            if (res.hasEcPolicy()) {
                return PBHelperClient.convertErasureCodingPolicy((HdfsProtos.ErasureCodingPolicyProto)res.getEcPolicy());
            }
            return null;
        }, ErasureCodingPolicy.class);
    }

    public QuotaUsage getQuotaUsage(String path) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getQuotaUsage(path);
        }
        ClientNamenodeProtocolProtos.GetQuotaUsageRequestProto req = ClientNamenodeProtocolProtos.GetQuotaUsageRequestProto.newBuilder().setPath(path).build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getQuotaUsage(null, req), res -> PBHelperClient.convert((HdfsProtos.QuotaUsageProto)res.getUsage()), QuotaUsage.class);
    }

    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long prevId, EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes, String path) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.listOpenFiles(prevId, openFilesTypes, path);
        }
        ClientNamenodeProtocolProtos.ListOpenFilesRequestProto.Builder req = ClientNamenodeProtocolProtos.ListOpenFilesRequestProto.newBuilder().setId(prevId);
        if (openFilesTypes != null) {
            req.addAllTypes((Iterable)PBHelperClient.convertOpenFileTypes(openFilesTypes));
        }
        req.setPath(path);
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.listOpenFiles(null, req.build()), res -> {
            ArrayList openFileEntries = Lists.newArrayListWithCapacity((int)res.getEntriesCount());
            for (ClientNamenodeProtocolProtos.OpenFilesBatchResponseProto p : res.getEntriesList()) {
                openFileEntries.add(PBHelperClient.convert((ClientNamenodeProtocolProtos.OpenFilesBatchResponseProto)p));
            }
            return new BatchedRemoteIterator.BatchedListEntries((List)openFileEntries, res.getHasMore());
        }, BatchedRemoteIterator.BatchedEntries.class);
    }

    public void msync() throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.msync();
            return;
        }
        ClientNamenodeProtocolProtos.MsyncRequestProto.Builder req = ClientNamenodeProtocolProtos.MsyncRequestProto.newBuilder();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.msync(null, req.build()), res -> null, Void.class);
    }

    public void satisfyStoragePolicy(String src) throws IOException {
        if (!Client.isAsynchronousMode()) {
            super.satisfyStoragePolicy(src);
            return;
        }
        ClientNamenodeProtocolProtos.SatisfyStoragePolicyRequestProto req = ClientNamenodeProtocolProtos.SatisfyStoragePolicyRequestProto.newBuilder().setSrc(src).build();
        AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.satisfyStoragePolicy(null, req), res -> null, Void.class);
    }

    public DatanodeInfo[] getSlowDatanodeReport() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getSlowDatanodeReport();
        }
        ClientNamenodeProtocolProtos.GetSlowDatanodeReportRequestProto req = ClientNamenodeProtocolProtos.GetSlowDatanodeReportRequestProto.newBuilder().build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getSlowDatanodeReport(null, req), res -> PBHelperClient.convert((List)res.getDatanodeInfoProtoList()), DatanodeInfo[].class);
    }

    public HAServiceProtocol.HAServiceState getHAServiceState() throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getHAServiceState();
        }
        ClientNamenodeProtocolProtos.HAServiceStateRequestProto req = ClientNamenodeProtocolProtos.HAServiceStateRequestProto.newBuilder().build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getHAServiceState(null, req), res -> {
            switch (res.getState()) {
                case ACTIVE: {
                    return HAServiceProtocol.HAServiceState.ACTIVE;
                }
                case STANDBY: {
                    return HAServiceProtocol.HAServiceState.STANDBY;
                }
                case OBSERVER: {
                    return HAServiceProtocol.HAServiceState.OBSERVER;
                }
            }
            return HAServiceProtocol.HAServiceState.INITIALIZING;
        }, HAServiceProtocol.HAServiceState.class);
    }

    public Path getEnclosingRoot(String filename) throws IOException {
        if (!Client.isAsynchronousMode()) {
            return super.getEnclosingRoot(filename);
        }
        ClientNamenodeProtocolProtos.GetEnclosingRootRequestProto.Builder builder = ClientNamenodeProtocolProtos.GetEnclosingRootRequestProto.newBuilder();
        builder.setFilename(filename);
        ClientNamenodeProtocolProtos.GetEnclosingRootRequestProto req = builder.build();
        return AsyncRpcProtocolPBUtil.asyncIpcClient(() -> this.rpcProxy.getEnclosingRoot(null, req), res -> new Path(res.getEnclosingRootPath()), Path.class);
    }
}

