/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.permission.FsCreateModes;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import org.apache.hadoop.hdfs.protocol.BatchedDirectoryListing;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ECTopologyVerifierResult;
import org.apache.hadoop.hdfs.protocol.EncryptionZone;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.HdfsPartialListing;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshotStatus;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import org.apache.hadoop.hdfs.protocol.proto.AclProtos;
import org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import org.apache.hadoop.hdfs.protocol.proto.EncryptionZonesProtos;
import org.apache.hadoop.hdfs.protocol.proto.ErasureCodingProtos;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.protocol.proto.XAttrProtos;
import org.apache.hadoop.hdfs.protocolPB.AsyncRpcProtocolPBUtil;
import org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolServerSideTranslatorPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelperClient;
import org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.thirdparty.protobuf.ByteString;
import org.apache.hadoop.thirdparty.protobuf.ProtocolStringList;
import org.apache.hadoop.thirdparty.protobuf.RpcController;
import org.apache.hadoop.thirdparty.protobuf.ServiceException;

public class RouterClientNamenodeProtocolServerSideTranslatorPB
extends ClientNamenodeProtocolServerSideTranslatorPB {
    private final RouterRpcServer server;

    public RouterClientNamenodeProtocolServerSideTranslatorPB(ClientProtocol server) throws IOException {
        super(server);
        this.server = (RouterRpcServer)server;
    }

    public ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto getBlockLocations(RpcController controller, ClientNamenodeProtocolProtos.GetBlockLocationsRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getBlockLocations(req.getSrc(), req.getOffset(), req.getLength()), b -> {
            ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetBlockLocationsResponseProto.newBuilder();
            if (b != null) {
                builder.setLocations(PBHelperClient.convert((LocatedBlocks)b)).build();
            }
            return builder.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetServerDefaultsResponseProto getServerDefaults(RpcController controller, ClientNamenodeProtocolProtos.GetServerDefaultsRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getServerDefaults, result -> ClientNamenodeProtocolProtos.GetServerDefaultsResponseProto.newBuilder().setServerDefaults(PBHelperClient.convert((FsServerDefaults)result)).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.CreateResponseProto create(RpcController controller, ClientNamenodeProtocolProtos.CreateRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            FsPermission masked = req.hasUnmasked() ? FsCreateModes.create((FsPermission)PBHelperClient.convert((AclProtos.FsPermissionProto)req.getMasked()), (FsPermission)PBHelperClient.convert((AclProtos.FsPermissionProto)req.getUnmasked())) : PBHelperClient.convert((AclProtos.FsPermissionProto)req.getMasked());
            return this.server.create(req.getSrc(), masked, req.getClientName(), (EnumSetWritable<CreateFlag>)PBHelperClient.convertCreateFlag((int)req.getCreateFlag()), req.getCreateParent(), (short)req.getReplication(), req.getBlockSize(), PBHelperClient.convertCryptoProtocolVersions((List)req.getCryptoProtocolVersionList()), req.getEcPolicyName(), req.getStoragePolicy());
        }, result -> {
            if (result != null) {
                return ClientNamenodeProtocolProtos.CreateResponseProto.newBuilder().setFs(PBHelperClient.convert((HdfsFileStatus)result)).build();
            }
            return VOID_CREATE_RESPONSE;
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.AppendResponseProto append(RpcController controller, ClientNamenodeProtocolProtos.AppendRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            EnumSetWritable flags = req.hasFlag() ? PBHelperClient.convertCreateFlag((int)req.getFlag()) : new EnumSetWritable(EnumSet.of(CreateFlag.APPEND));
            return this.server.append(req.getSrc(), req.getClientName(), (EnumSetWritable<CreateFlag>)flags);
        }, result -> {
            ClientNamenodeProtocolProtos.AppendResponseProto.Builder builder = ClientNamenodeProtocolProtos.AppendResponseProto.newBuilder();
            if (result.getLastBlock() != null) {
                builder.setBlock(PBHelperClient.convertLocatedBlock((LocatedBlock)result.getLastBlock()));
            }
            if (result.getFileStatus() != null) {
                builder.setStat(PBHelperClient.convert((HdfsFileStatus)result.getFileStatus()));
            }
            return builder.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.SetReplicationResponseProto setReplication(RpcController controller, ClientNamenodeProtocolProtos.SetReplicationRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.setReplication(req.getSrc(), (short)req.getReplication()), result -> ClientNamenodeProtocolProtos.SetReplicationResponseProto.newBuilder().setResult(result.booleanValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.SetPermissionResponseProto setPermission(RpcController controller, ClientNamenodeProtocolProtos.SetPermissionRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.setPermission(req.getSrc(), PBHelperClient.convert((AclProtos.FsPermissionProto)req.getPermission()));
            return null;
        }, result -> VOID_SET_PERM_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.SetOwnerResponseProto setOwner(RpcController controller, ClientNamenodeProtocolProtos.SetOwnerRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.setOwner(req.getSrc(), req.hasUsername() ? req.getUsername() : null, req.hasGroupname() ? req.getGroupname() : null);
            return null;
        }, result -> VOID_SET_OWNER_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.AbandonBlockResponseProto abandonBlock(RpcController controller, ClientNamenodeProtocolProtos.AbandonBlockRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.abandonBlock(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getB()), req.getFileId(), req.getSrc(), req.getHolder());
            return null;
        }, result -> VOID_ADD_BLOCK_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.AddBlockResponseProto addBlock(RpcController controller, ClientNamenodeProtocolProtos.AddBlockRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            List excl = req.getExcludeNodesList();
            ProtocolStringList favor = req.getFavoredNodesList();
            EnumSet flags = PBHelperClient.convertAddBlockFlags((List)req.getFlagsList());
            return this.server.addBlock(req.getSrc(), req.getClientName(), req.hasPrevious() ? PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getPrevious()) : null, excl == null || excl.size() == 0 ? null : PBHelperClient.convert((HdfsProtos.DatanodeInfoProto[])excl.toArray(new HdfsProtos.DatanodeInfoProto[excl.size()])), req.getFileId(), favor == null || favor.size() == 0 ? null : favor.toArray(new String[favor.size()]), flags);
        }, result -> ClientNamenodeProtocolProtos.AddBlockResponseProto.newBuilder().setBlock(PBHelperClient.convertLocatedBlock((LocatedBlock)result)).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.GetAdditionalDatanodeResponseProto getAdditionalDatanode(RpcController controller, ClientNamenodeProtocolProtos.GetAdditionalDatanodeRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            List existingList = req.getExistingsList();
            ProtocolStringList existingStorageIDsList = req.getExistingStorageUuidsList();
            List excludesList = req.getExcludesList();
            LocatedBlock result = this.server.getAdditionalDatanode(req.getSrc(), req.getFileId(), PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getBlk()), PBHelperClient.convert((HdfsProtos.DatanodeInfoProto[])existingList.toArray(new HdfsProtos.DatanodeInfoProto[existingList.size()])), existingStorageIDsList.toArray(new String[existingStorageIDsList.size()]), PBHelperClient.convert((HdfsProtos.DatanodeInfoProto[])excludesList.toArray(new HdfsProtos.DatanodeInfoProto[excludesList.size()])), req.getNumAdditionalNodes(), req.getClientName());
            return result;
        }, result -> ClientNamenodeProtocolProtos.GetAdditionalDatanodeResponseProto.newBuilder().setBlock(PBHelperClient.convertLocatedBlock((LocatedBlock)result)).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.CompleteResponseProto complete(RpcController controller, ClientNamenodeProtocolProtos.CompleteRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            boolean result = this.server.complete(req.getSrc(), req.getClientName(), req.hasLast() ? PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getLast()) : null, req.hasFileId() ? req.getFileId() : 0L);
            return result;
        }, result -> ClientNamenodeProtocolProtos.CompleteResponseProto.newBuilder().setResult(result.booleanValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.ReportBadBlocksResponseProto reportBadBlocks(RpcController controller, ClientNamenodeProtocolProtos.ReportBadBlocksRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            List bl = req.getBlocksList();
            this.server.reportBadBlocks(PBHelperClient.convertLocatedBlocks((HdfsProtos.LocatedBlockProto[])bl.toArray(new HdfsProtos.LocatedBlockProto[bl.size()])));
            return null;
        }, result -> VOID_REP_BAD_BLOCK_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.ConcatResponseProto concat(RpcController controller, ClientNamenodeProtocolProtos.ConcatRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            ProtocolStringList srcs = req.getSrcsList();
            this.server.concat(req.getTrg(), srcs.toArray(new String[srcs.size()]));
            return null;
        }, result -> VOID_CONCAT_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.RenameResponseProto rename(RpcController controller, ClientNamenodeProtocolProtos.RenameRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.rename(req.getSrc(), req.getDst()), result -> ClientNamenodeProtocolProtos.RenameResponseProto.newBuilder().setResult(result.booleanValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.Rename2ResponseProto rename2(RpcController controller, ClientNamenodeProtocolProtos.Rename2RequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            ArrayList<Options.Rename> optionList = new ArrayList<Options.Rename>();
            if (req.getOverwriteDest()) {
                optionList.add(Options.Rename.OVERWRITE);
            }
            if (req.hasMoveToTrash() && req.getMoveToTrash()) {
                optionList.add(Options.Rename.TO_TRASH);
            }
            if (optionList.isEmpty()) {
                optionList.add(Options.Rename.NONE);
            }
            this.server.rename2(req.getSrc(), req.getDst(), optionList.toArray(new Options.Rename[optionList.size()]));
            return null;
        }, result -> VOID_RENAME2_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.TruncateResponseProto truncate(RpcController controller, ClientNamenodeProtocolProtos.TruncateRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.truncate(req.getSrc(), req.getNewLength(), req.getClientName()), result -> ClientNamenodeProtocolProtos.TruncateResponseProto.newBuilder().setResult(result.booleanValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.DeleteResponseProto delete(RpcController controller, ClientNamenodeProtocolProtos.DeleteRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.delete(req.getSrc(), req.getRecursive()), result -> ClientNamenodeProtocolProtos.DeleteResponseProto.newBuilder().setResult(result.booleanValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.MkdirsResponseProto mkdirs(RpcController controller, ClientNamenodeProtocolProtos.MkdirsRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            FsPermission masked = req.hasUnmasked() ? FsCreateModes.create((FsPermission)PBHelperClient.convert((AclProtos.FsPermissionProto)req.getMasked()), (FsPermission)PBHelperClient.convert((AclProtos.FsPermissionProto)req.getUnmasked())) : PBHelperClient.convert((AclProtos.FsPermissionProto)req.getMasked());
            boolean result = this.server.mkdirs(req.getSrc(), masked, req.getCreateParent());
            return result;
        }, result -> ClientNamenodeProtocolProtos.MkdirsResponseProto.newBuilder().setResult(result.booleanValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.GetListingResponseProto getListing(RpcController controller, ClientNamenodeProtocolProtos.GetListingRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            DirectoryListing result = this.server.getListing(req.getSrc(), req.getStartAfter().toByteArray(), req.getNeedLocation());
            return result;
        }, result -> {
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetListingResponseProto.newBuilder().setDirList(PBHelperClient.convert((DirectoryListing)result)).build();
            }
            return VOID_GETLISTING_RESPONSE;
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetBatchedListingResponseProto getBatchedListing(RpcController controller, ClientNamenodeProtocolProtos.GetBatchedListingRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            BatchedDirectoryListing result = this.server.getBatchedListing((String[])request.getPathsList().toArray((Object[])new String[0]), request.getStartAfter().toByteArray(), request.getNeedLocation());
            return result;
        }, result -> {
            if (result != null) {
                ClientNamenodeProtocolProtos.GetBatchedListingResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetBatchedListingResponseProto.newBuilder();
                for (HdfsPartialListing partialListing : result.getListings()) {
                    HdfsProtos.BatchedDirectoryListingProto.Builder listingBuilder = HdfsProtos.BatchedDirectoryListingProto.newBuilder();
                    if (partialListing.getException() != null) {
                        RemoteException ex = partialListing.getException();
                        HdfsProtos.RemoteExceptionProto.Builder rexBuilder = HdfsProtos.RemoteExceptionProto.newBuilder();
                        rexBuilder.setClassName(ex.getClassName());
                        if (ex.getMessage() != null) {
                            rexBuilder.setMessage(ex.getMessage());
                        }
                        listingBuilder.setException(rexBuilder.build());
                    } else {
                        for (HdfsFileStatus f : partialListing.getPartialListing()) {
                            listingBuilder.addPartialListing(PBHelperClient.convert((HdfsFileStatus)f));
                        }
                    }
                    listingBuilder.setParentIdx(partialListing.getParentIdx());
                    builder.addListings(listingBuilder);
                }
                builder.setHasMore(result.hasMore());
                builder.setStartAfter(ByteString.copyFrom((byte[])result.getStartAfter()));
                return builder.build();
            }
            return VOID_GETBATCHEDLISTING_RESPONSE;
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.RenewLeaseResponseProto renewLease(RpcController controller, ClientNamenodeProtocolProtos.RenewLeaseRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.renewLease(req.getClientName(), (List<String>)req.getNamespacesList());
            return null;
        }, result -> VOID_RENEWLEASE_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.RecoverLeaseResponseProto recoverLease(RpcController controller, ClientNamenodeProtocolProtos.RecoverLeaseRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.recoverLease(req.getSrc(), req.getClientName()), result -> ClientNamenodeProtocolProtos.RecoverLeaseResponseProto.newBuilder().setResult(result.booleanValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.RestoreFailedStorageResponseProto restoreFailedStorage(RpcController controller, ClientNamenodeProtocolProtos.RestoreFailedStorageRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.restoreFailedStorage(req.getArg()), result -> ClientNamenodeProtocolProtos.RestoreFailedStorageResponseProto.newBuilder().setResult(result.booleanValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.GetFsStatsResponseProto getFsStats(RpcController controller, ClientNamenodeProtocolProtos.GetFsStatusRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getStats, PBHelperClient::convert);
        return null;
    }

    public ClientNamenodeProtocolProtos.GetFsReplicatedBlockStatsResponseProto getFsReplicatedBlockStats(RpcController controller, ClientNamenodeProtocolProtos.GetFsReplicatedBlockStatsRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getReplicatedBlockStats, PBHelperClient::convert);
        return null;
    }

    public ClientNamenodeProtocolProtos.GetFsECBlockGroupStatsResponseProto getFsECBlockGroupStats(RpcController controller, ClientNamenodeProtocolProtos.GetFsECBlockGroupStatsRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getECBlockGroupStats, PBHelperClient::convert);
        return null;
    }

    public ClientNamenodeProtocolProtos.GetDatanodeReportResponseProto getDatanodeReport(RpcController controller, ClientNamenodeProtocolProtos.GetDatanodeReportRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getDatanodeReport(PBHelperClient.convert((ClientNamenodeProtocolProtos.DatanodeReportTypeProto)req.getType())), result -> {
            List re = PBHelperClient.convert((DatanodeInfo[])result);
            return ClientNamenodeProtocolProtos.GetDatanodeReportResponseProto.newBuilder().addAllDi((Iterable)re).build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetDatanodeStorageReportResponseProto getDatanodeStorageReport(RpcController controller, ClientNamenodeProtocolProtos.GetDatanodeStorageReportRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getDatanodeStorageReport(PBHelperClient.convert((ClientNamenodeProtocolProtos.DatanodeReportTypeProto)req.getType())), result -> {
            List reports = PBHelperClient.convertDatanodeStorageReports((DatanodeStorageReport[])result);
            return ClientNamenodeProtocolProtos.GetDatanodeStorageReportResponseProto.newBuilder().addAllDatanodeStorageReports((Iterable)reports).build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetPreferredBlockSizeResponseProto getPreferredBlockSize(RpcController controller, ClientNamenodeProtocolProtos.GetPreferredBlockSizeRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getPreferredBlockSize(req.getFilename()), result -> ClientNamenodeProtocolProtos.GetPreferredBlockSizeResponseProto.newBuilder().setBsize(result.longValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.SetSafeModeResponseProto setSafeMode(RpcController controller, ClientNamenodeProtocolProtos.SetSafeModeRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.setSafeMode(PBHelperClient.convert((ClientNamenodeProtocolProtos.SafeModeActionProto)req.getAction()), req.getChecked()), result -> ClientNamenodeProtocolProtos.SetSafeModeResponseProto.newBuilder().setResult(result.booleanValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.SaveNamespaceResponseProto saveNamespace(RpcController controller, ClientNamenodeProtocolProtos.SaveNamespaceRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            long timeWindow = req.hasTimeWindow() ? req.getTimeWindow() : 0L;
            long txGap = req.hasTxGap() ? req.getTxGap() : 0L;
            return this.server.saveNamespace(timeWindow, txGap);
        }, result -> ClientNamenodeProtocolProtos.SaveNamespaceResponseProto.newBuilder().setSaved(result.booleanValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.RollEditsResponseProto rollEdits(RpcController controller, ClientNamenodeProtocolProtos.RollEditsRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::rollEdits, txid -> ClientNamenodeProtocolProtos.RollEditsResponseProto.newBuilder().setNewSegmentTxId(txid.longValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.RefreshNodesResponseProto refreshNodes(RpcController controller, ClientNamenodeProtocolProtos.RefreshNodesRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.refreshNodes();
            return null;
        }, result -> VOID_REFRESHNODES_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.FinalizeUpgradeResponseProto finalizeUpgrade(RpcController controller, ClientNamenodeProtocolProtos.FinalizeUpgradeRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.finalizeUpgrade();
            return null;
        }, result -> VOID_REFRESHNODES_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.UpgradeStatusResponseProto upgradeStatus(RpcController controller, ClientNamenodeProtocolProtos.UpgradeStatusRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::upgradeStatus, result -> {
            ClientNamenodeProtocolProtos.UpgradeStatusResponseProto.Builder b = ClientNamenodeProtocolProtos.UpgradeStatusResponseProto.newBuilder();
            b.setUpgradeFinalized(result.booleanValue());
            return b.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.RollingUpgradeResponseProto rollingUpgrade(RpcController controller, ClientNamenodeProtocolProtos.RollingUpgradeRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.rollingUpgrade(PBHelperClient.convert((ClientNamenodeProtocolProtos.RollingUpgradeActionProto)req.getAction())), info -> {
            ClientNamenodeProtocolProtos.RollingUpgradeResponseProto.Builder b = ClientNamenodeProtocolProtos.RollingUpgradeResponseProto.newBuilder();
            if (info != null) {
                b.setRollingUpgradeInfo(PBHelperClient.convert((RollingUpgradeInfo)info));
            }
            return b.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.ListCorruptFileBlocksResponseProto listCorruptFileBlocks(RpcController controller, ClientNamenodeProtocolProtos.ListCorruptFileBlocksRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.listCorruptFileBlocks(req.getPath(), req.hasCookie() ? req.getCookie() : null), result -> ClientNamenodeProtocolProtos.ListCorruptFileBlocksResponseProto.newBuilder().setCorrupt(PBHelperClient.convert((CorruptFileBlocks)result)).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.MetaSaveResponseProto metaSave(RpcController controller, ClientNamenodeProtocolProtos.MetaSaveRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.metaSave(req.getFilename());
            return null;
        }, result -> VOID_METASAVE_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.GetFileInfoResponseProto getFileInfo(RpcController controller, ClientNamenodeProtocolProtos.GetFileInfoRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getFileInfo(req.getSrc()), result -> {
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetFileInfoResponseProto.newBuilder().setFs(PBHelperClient.convert((HdfsFileStatus)result)).build();
            }
            return VOID_GETFILEINFO_RESPONSE;
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetLocatedFileInfoResponseProto getLocatedFileInfo(RpcController controller, ClientNamenodeProtocolProtos.GetLocatedFileInfoRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getLocatedFileInfo(req.getSrc(), req.getNeedBlockToken()), result -> {
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetLocatedFileInfoResponseProto.newBuilder().setFs(PBHelperClient.convert((HdfsFileStatus)result)).build();
            }
            return VOID_GETLOCATEDFILEINFO_RESPONSE;
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto getFileLinkInfo(RpcController controller, ClientNamenodeProtocolProtos.GetFileLinkInfoRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getFileLinkInfo(req.getSrc()), result -> {
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetFileLinkInfoResponseProto.newBuilder().setFs(PBHelperClient.convert((HdfsFileStatus)result)).build();
            }
            return VOID_GETFILELINKINFO_RESPONSE;
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetContentSummaryResponseProto getContentSummary(RpcController controller, ClientNamenodeProtocolProtos.GetContentSummaryRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getContentSummary(req.getPath()), result -> ClientNamenodeProtocolProtos.GetContentSummaryResponseProto.newBuilder().setSummary(PBHelperClient.convert((ContentSummary)result)).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.SetQuotaResponseProto setQuota(RpcController controller, ClientNamenodeProtocolProtos.SetQuotaRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.setQuota(req.getPath(), req.getNamespaceQuota(), req.getStoragespaceQuota(), req.hasStorageType() ? PBHelperClient.convertStorageType((HdfsProtos.StorageTypeProto)req.getStorageType()) : null);
            return null;
        }, result -> VOID_SETQUOTA_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.FsyncResponseProto fsync(RpcController controller, ClientNamenodeProtocolProtos.FsyncRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.fsync(req.getSrc(), req.getFileId(), req.getClient(), req.getLastBlockLength());
            return null;
        }, result -> VOID_FSYNC_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.SetTimesResponseProto setTimes(RpcController controller, ClientNamenodeProtocolProtos.SetTimesRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.setTimes(req.getSrc(), req.getMtime(), req.getAtime());
            return null;
        }, result -> VOID_SETTIMES_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.CreateSymlinkResponseProto createSymlink(RpcController controller, ClientNamenodeProtocolProtos.CreateSymlinkRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.createSymlink(req.getTarget(), req.getLink(), PBHelperClient.convert((AclProtos.FsPermissionProto)req.getDirPerm()), req.getCreateParent());
            return null;
        }, result -> VOID_CREATESYMLINK_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.GetLinkTargetResponseProto getLinkTarget(RpcController controller, ClientNamenodeProtocolProtos.GetLinkTargetRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getLinkTarget(req.getPath()), result -> {
            ClientNamenodeProtocolProtos.GetLinkTargetResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetLinkTargetResponseProto.newBuilder();
            if (result != null) {
                builder.setTargetPath(result);
            }
            return builder.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.UpdateBlockForPipelineResponseProto updateBlockForPipeline(RpcController controller, ClientNamenodeProtocolProtos.UpdateBlockForPipelineRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.updateBlockForPipeline(PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getBlock()), req.getClientName()), result -> {
            HdfsProtos.LocatedBlockProto res = PBHelperClient.convertLocatedBlock((LocatedBlock)result);
            return ClientNamenodeProtocolProtos.UpdateBlockForPipelineResponseProto.newBuilder().setBlock(res).build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.UpdatePipelineResponseProto updatePipeline(RpcController controller, ClientNamenodeProtocolProtos.UpdatePipelineRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            List newNodes = req.getNewNodesList();
            ProtocolStringList newStorageIDs = req.getStorageIDsList();
            this.server.updatePipeline(req.getClientName(), PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getOldBlock()), PBHelperClient.convert((HdfsProtos.ExtendedBlockProto)req.getNewBlock()), PBHelperClient.convert((HdfsProtos.DatanodeIDProto[])newNodes.toArray(new HdfsProtos.DatanodeIDProto[newNodes.size()])), newStorageIDs.toArray(new String[newStorageIDs.size()]));
            return null;
        }, result -> VOID_UPDATEPIPELINE_RESPONSE);
        return null;
    }

    public SecurityProtos.GetDelegationTokenResponseProto getDelegationToken(RpcController controller, SecurityProtos.GetDelegationTokenRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getDelegationToken(new Text(req.getRenewer())), token -> {
            SecurityProtos.GetDelegationTokenResponseProto.Builder rspBuilder = SecurityProtos.GetDelegationTokenResponseProto.newBuilder();
            if (token != null) {
                rspBuilder.setToken(PBHelperClient.convert((Token)token));
            }
            return rspBuilder.build();
        });
        return null;
    }

    public SecurityProtos.RenewDelegationTokenResponseProto renewDelegationToken(RpcController controller, SecurityProtos.RenewDelegationTokenRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.renewDelegationToken((Token<DelegationTokenIdentifier>)PBHelperClient.convertDelegationToken((SecurityProtos.TokenProto)req.getToken())), result -> SecurityProtos.RenewDelegationTokenResponseProto.newBuilder().setNewExpiryTime(result.longValue()).build());
        return null;
    }

    public SecurityProtos.CancelDelegationTokenResponseProto cancelDelegationToken(RpcController controller, SecurityProtos.CancelDelegationTokenRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.cancelDelegationToken((Token<DelegationTokenIdentifier>)PBHelperClient.convertDelegationToken((SecurityProtos.TokenProto)req.getToken()));
            return null;
        }, result -> VOID_CANCELDELEGATIONTOKEN_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.SetBalancerBandwidthResponseProto setBalancerBandwidth(RpcController controller, ClientNamenodeProtocolProtos.SetBalancerBandwidthRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.setBalancerBandwidth(req.getBandwidth());
            return null;
        }, result -> VOID_SETBALANCERBANDWIDTH_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto getDataEncryptionKey(RpcController controller, ClientNamenodeProtocolProtos.GetDataEncryptionKeyRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getDataEncryptionKey, encryptionKey -> {
            ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetDataEncryptionKeyResponseProto.newBuilder();
            if (encryptionKey != null) {
                builder.setDataEncryptionKey(PBHelperClient.convert((DataEncryptionKey)encryptionKey));
            }
            return builder.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.CreateSnapshotResponseProto createSnapshot(RpcController controller, ClientNamenodeProtocolProtos.CreateSnapshotRequestProto req) throws ServiceException {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.createSnapshot(req.getSnapshotRoot(), req.hasSnapshotName() ? req.getSnapshotName() : null), snapshotPath -> {
            ClientNamenodeProtocolProtos.CreateSnapshotResponseProto.Builder builder = ClientNamenodeProtocolProtos.CreateSnapshotResponseProto.newBuilder();
            if (snapshotPath != null) {
                builder.setSnapshotPath(snapshotPath);
            }
            return builder.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.DeleteSnapshotResponseProto deleteSnapshot(RpcController controller, ClientNamenodeProtocolProtos.DeleteSnapshotRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.deleteSnapshot(req.getSnapshotRoot(), req.getSnapshotName());
            return null;
        }, result -> VOID_DELETE_SNAPSHOT_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.AllowSnapshotResponseProto allowSnapshot(RpcController controller, ClientNamenodeProtocolProtos.AllowSnapshotRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.allowSnapshot(req.getSnapshotRoot());
            return null;
        }, result -> VOID_ALLOW_SNAPSHOT_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.DisallowSnapshotResponseProto disallowSnapshot(RpcController controller, ClientNamenodeProtocolProtos.DisallowSnapshotRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.disallowSnapshot(req.getSnapshotRoot());
            return null;
        }, result -> VOID_DISALLOW_SNAPSHOT_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.RenameSnapshotResponseProto renameSnapshot(RpcController controller, ClientNamenodeProtocolProtos.RenameSnapshotRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.renameSnapshot(request.getSnapshotRoot(), request.getSnapshotOldName(), request.getSnapshotNewName());
            return null;
        }, result -> VOID_RENAME_SNAPSHOT_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.GetSnapshottableDirListingResponseProto getSnapshottableDirListing(RpcController controller, ClientNamenodeProtocolProtos.GetSnapshottableDirListingRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getSnapshottableDirListing, result -> {
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetSnapshottableDirListingResponseProto.newBuilder().setSnapshottableDirList(PBHelperClient.convert((SnapshottableDirectoryStatus[])result)).build();
            }
            return NULL_GET_SNAPSHOTTABLE_DIR_LISTING_RESPONSE;
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetSnapshotListingResponseProto getSnapshotListing(RpcController controller, ClientNamenodeProtocolProtos.GetSnapshotListingRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getSnapshotListing(request.getSnapshotRoot()), result -> {
            if (result != null) {
                return ClientNamenodeProtocolProtos.GetSnapshotListingResponseProto.newBuilder().setSnapshotList(PBHelperClient.convert((SnapshotStatus[])result)).build();
            }
            return NULL_GET_SNAPSHOT_LISTING_RESPONSE;
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetSnapshotDiffReportResponseProto getSnapshotDiffReport(RpcController controller, ClientNamenodeProtocolProtos.GetSnapshotDiffReportRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getSnapshotDiffReport(request.getSnapshotRoot(), request.getFromSnapshot(), request.getToSnapshot()), report -> ClientNamenodeProtocolProtos.GetSnapshotDiffReportResponseProto.newBuilder().setDiffReport(PBHelperClient.convert((SnapshotDiffReport)report)).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.GetSnapshotDiffReportListingResponseProto getSnapshotDiffReportListing(RpcController controller, ClientNamenodeProtocolProtos.GetSnapshotDiffReportListingRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getSnapshotDiffReportListing(request.getSnapshotRoot(), request.getFromSnapshot(), request.getToSnapshot(), request.getCursor().getStartPath().toByteArray(), request.getCursor().getIndex()), report -> ClientNamenodeProtocolProtos.GetSnapshotDiffReportListingResponseProto.newBuilder().setDiffReport(PBHelperClient.convert((SnapshotDiffReportListing)report)).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.IsFileClosedResponseProto isFileClosed(RpcController controller, ClientNamenodeProtocolProtos.IsFileClosedRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.isFileClosed(request.getSrc()), result -> ClientNamenodeProtocolProtos.IsFileClosedResponseProto.newBuilder().setResult(result.booleanValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.AddCacheDirectiveResponseProto addCacheDirective(RpcController controller, ClientNamenodeProtocolProtos.AddCacheDirectiveRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.addCacheDirective(PBHelperClient.convert((ClientNamenodeProtocolProtos.CacheDirectiveInfoProto)request.getInfo()), PBHelperClient.convertCacheFlags((int)request.getCacheFlags())), id -> ClientNamenodeProtocolProtos.AddCacheDirectiveResponseProto.newBuilder().setId(id.longValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.ModifyCacheDirectiveResponseProto modifyCacheDirective(RpcController controller, ClientNamenodeProtocolProtos.ModifyCacheDirectiveRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.modifyCacheDirective(PBHelperClient.convert((ClientNamenodeProtocolProtos.CacheDirectiveInfoProto)request.getInfo()), PBHelperClient.convertCacheFlags((int)request.getCacheFlags()));
            return null;
        }, result -> ClientNamenodeProtocolProtos.ModifyCacheDirectiveResponseProto.newBuilder().build());
        return null;
    }

    public ClientNamenodeProtocolProtos.RemoveCacheDirectiveResponseProto removeCacheDirective(RpcController controller, ClientNamenodeProtocolProtos.RemoveCacheDirectiveRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.removeCacheDirective(request.getId());
            return null;
        }, result -> ClientNamenodeProtocolProtos.RemoveCacheDirectiveResponseProto.newBuilder().build());
        return null;
    }

    public ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto listCacheDirectives(RpcController controller, ClientNamenodeProtocolProtos.ListCacheDirectivesRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            CacheDirectiveInfo filter = PBHelperClient.convert((ClientNamenodeProtocolProtos.CacheDirectiveInfoProto)request.getFilter());
            return this.server.listCacheDirectives(request.getPrevId(), filter);
        }, entries -> {
            ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto.Builder builder = ClientNamenodeProtocolProtos.ListCacheDirectivesResponseProto.newBuilder();
            builder.setHasMore(entries.hasMore());
            int n = entries.size();
            for (int i = 0; i < n; ++i) {
                builder.addElements(PBHelperClient.convert((CacheDirectiveEntry)((CacheDirectiveEntry)entries.get(i))));
            }
            return builder.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.AddCachePoolResponseProto addCachePool(RpcController controller, ClientNamenodeProtocolProtos.AddCachePoolRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.addCachePool(PBHelperClient.convert((ClientNamenodeProtocolProtos.CachePoolInfoProto)request.getInfo()));
            return null;
        }, result -> ClientNamenodeProtocolProtos.AddCachePoolResponseProto.newBuilder().build());
        return null;
    }

    public ClientNamenodeProtocolProtos.ModifyCachePoolResponseProto modifyCachePool(RpcController controller, ClientNamenodeProtocolProtos.ModifyCachePoolRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.modifyCachePool(PBHelperClient.convert((ClientNamenodeProtocolProtos.CachePoolInfoProto)request.getInfo()));
            return null;
        }, result -> ClientNamenodeProtocolProtos.ModifyCachePoolResponseProto.newBuilder().build());
        return null;
    }

    public ClientNamenodeProtocolProtos.RemoveCachePoolResponseProto removeCachePool(RpcController controller, ClientNamenodeProtocolProtos.RemoveCachePoolRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.removeCachePool(request.getPoolName());
            return null;
        }, result -> ClientNamenodeProtocolProtos.RemoveCachePoolResponseProto.newBuilder().build());
        return null;
    }

    public ClientNamenodeProtocolProtos.ListCachePoolsResponseProto listCachePools(RpcController controller, ClientNamenodeProtocolProtos.ListCachePoolsRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.listCachePools(request.getPrevPoolName()), entries -> {
            ClientNamenodeProtocolProtos.ListCachePoolsResponseProto.Builder responseBuilder = ClientNamenodeProtocolProtos.ListCachePoolsResponseProto.newBuilder();
            responseBuilder.setHasMore(entries.hasMore());
            int n = entries.size();
            for (int i = 0; i < n; ++i) {
                responseBuilder.addEntries(PBHelperClient.convert((CachePoolEntry)((CachePoolEntry)entries.get(i))));
            }
            return responseBuilder.build();
        });
        return null;
    }

    public AclProtos.ModifyAclEntriesResponseProto modifyAclEntries(RpcController controller, AclProtos.ModifyAclEntriesRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.modifyAclEntries(req.getSrc(), PBHelperClient.convertAclEntry((List)req.getAclSpecList()));
            return null;
        }, vo -> VOID_MODIFYACLENTRIES_RESPONSE);
        return null;
    }

    public AclProtos.RemoveAclEntriesResponseProto removeAclEntries(RpcController controller, AclProtos.RemoveAclEntriesRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.removeAclEntries(req.getSrc(), PBHelperClient.convertAclEntry((List)req.getAclSpecList()));
            return null;
        }, vo -> VOID_REMOVEACLENTRIES_RESPONSE);
        return null;
    }

    public AclProtos.RemoveDefaultAclResponseProto removeDefaultAcl(RpcController controller, AclProtos.RemoveDefaultAclRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.removeDefaultAcl(req.getSrc());
            return null;
        }, vo -> VOID_REMOVEDEFAULTACL_RESPONSE);
        return null;
    }

    public AclProtos.RemoveAclResponseProto removeAcl(RpcController controller, AclProtos.RemoveAclRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.removeAcl(req.getSrc());
            return null;
        }, vo -> VOID_REMOVEACL_RESPONSE);
        return null;
    }

    public AclProtos.SetAclResponseProto setAcl(RpcController controller, AclProtos.SetAclRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.setAcl(req.getSrc(), PBHelperClient.convertAclEntry((List)req.getAclSpecList()));
            return null;
        }, vo -> VOID_SETACL_RESPONSE);
        return null;
    }

    public AclProtos.GetAclStatusResponseProto getAclStatus(RpcController controller, AclProtos.GetAclStatusRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getAclStatus(req.getSrc()), PBHelperClient::convert);
        return null;
    }

    public EncryptionZonesProtos.CreateEncryptionZoneResponseProto createEncryptionZone(RpcController controller, EncryptionZonesProtos.CreateEncryptionZoneRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.createEncryptionZone(req.getSrc(), req.getKeyName());
            return null;
        }, vo -> EncryptionZonesProtos.CreateEncryptionZoneResponseProto.newBuilder().build());
        return null;
    }

    public EncryptionZonesProtos.GetEZForPathResponseProto getEZForPath(RpcController controller, EncryptionZonesProtos.GetEZForPathRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getEZForPath(req.getSrc()), ret -> {
            EncryptionZonesProtos.GetEZForPathResponseProto.Builder builder = EncryptionZonesProtos.GetEZForPathResponseProto.newBuilder();
            if (ret != null) {
                builder.setZone(PBHelperClient.convert((EncryptionZone)ret));
            }
            return builder.build();
        });
        return null;
    }

    public EncryptionZonesProtos.ListEncryptionZonesResponseProto listEncryptionZones(RpcController controller, EncryptionZonesProtos.ListEncryptionZonesRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.listEncryptionZones(req.getId()), entries -> {
            EncryptionZonesProtos.ListEncryptionZonesResponseProto.Builder builder = EncryptionZonesProtos.ListEncryptionZonesResponseProto.newBuilder();
            builder.setHasMore(entries.hasMore());
            for (int i = 0; i < entries.size(); ++i) {
                builder.addZones(PBHelperClient.convert((EncryptionZone)((EncryptionZone)entries.get(i))));
            }
            return builder.build();
        });
        return null;
    }

    public EncryptionZonesProtos.ReencryptEncryptionZoneResponseProto reencryptEncryptionZone(RpcController controller, EncryptionZonesProtos.ReencryptEncryptionZoneRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.reencryptEncryptionZone(req.getZone(), PBHelperClient.convert((EncryptionZonesProtos.ReencryptActionProto)req.getAction()));
            return null;
        }, vo -> EncryptionZonesProtos.ReencryptEncryptionZoneResponseProto.newBuilder().build());
        return null;
    }

    public EncryptionZonesProtos.ListReencryptionStatusResponseProto listReencryptionStatus(RpcController controller, EncryptionZonesProtos.ListReencryptionStatusRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.listReencryptionStatus(req.getId()), entries -> {
            EncryptionZonesProtos.ListReencryptionStatusResponseProto.Builder builder = EncryptionZonesProtos.ListReencryptionStatusResponseProto.newBuilder();
            builder.setHasMore(entries.hasMore());
            for (int i = 0; i < entries.size(); ++i) {
                builder.addStatuses(PBHelperClient.convert((ZoneReencryptionStatus)((ZoneReencryptionStatus)entries.get(i))));
            }
            return builder.build();
        });
        return null;
    }

    public ErasureCodingProtos.SetErasureCodingPolicyResponseProto setErasureCodingPolicy(RpcController controller, ErasureCodingProtos.SetErasureCodingPolicyRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            String ecPolicyName = req.hasEcPolicyName() ? req.getEcPolicyName() : null;
            this.server.setErasureCodingPolicy(req.getSrc(), ecPolicyName);
            return null;
        }, vo -> ErasureCodingProtos.SetErasureCodingPolicyResponseProto.newBuilder().build());
        return null;
    }

    public ErasureCodingProtos.UnsetErasureCodingPolicyResponseProto unsetErasureCodingPolicy(RpcController controller, ErasureCodingProtos.UnsetErasureCodingPolicyRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.unsetErasureCodingPolicy(req.getSrc());
            return null;
        }, vo -> ErasureCodingProtos.UnsetErasureCodingPolicyResponseProto.newBuilder().build());
        return null;
    }

    public ErasureCodingProtos.GetECTopologyResultForPoliciesResponseProto getECTopologyResultForPolicies(RpcController controller, ErasureCodingProtos.GetECTopologyResultForPoliciesRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            ProtocolStringList policies = req.getPoliciesList();
            return this.server.getECTopologyResultForPolicies((String[])policies.toArray((Object[])((String[])policies.toArray((Object[])new String[policies.size()]))));
        }, result -> {
            ErasureCodingProtos.GetECTopologyResultForPoliciesResponseProto.Builder builder = ErasureCodingProtos.GetECTopologyResultForPoliciesResponseProto.newBuilder();
            builder.setResponse(PBHelperClient.convertECTopologyVerifierResult((ECTopologyVerifierResult)result));
            return builder.build();
        });
        return null;
    }

    public XAttrProtos.SetXAttrResponseProto setXAttr(RpcController controller, XAttrProtos.SetXAttrRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.setXAttr(req.getSrc(), PBHelperClient.convertXAttr((XAttrProtos.XAttrProto)req.getXAttr()), PBHelperClient.convert((int)req.getFlag()));
            return null;
        }, vo -> VOID_SETXATTR_RESPONSE);
        return null;
    }

    public XAttrProtos.GetXAttrsResponseProto getXAttrs(RpcController controller, XAttrProtos.GetXAttrsRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getXAttrs(req.getSrc(), PBHelperClient.convertXAttrs((List)req.getXAttrsList())), PBHelperClient::convertXAttrsResponse);
        return null;
    }

    public XAttrProtos.ListXAttrsResponseProto listXAttrs(RpcController controller, XAttrProtos.ListXAttrsRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.listXAttrs(req.getSrc()), PBHelperClient::convertListXAttrsResponse);
        return null;
    }

    public XAttrProtos.RemoveXAttrResponseProto removeXAttr(RpcController controller, XAttrProtos.RemoveXAttrRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.removeXAttr(req.getSrc(), PBHelperClient.convertXAttr((XAttrProtos.XAttrProto)req.getXAttr()));
            return null;
        }, vo -> VOID_REMOVEXATTR_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.CheckAccessResponseProto checkAccess(RpcController controller, ClientNamenodeProtocolProtos.CheckAccessRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.checkAccess(req.getPath(), PBHelperClient.convert((AclProtos.AclEntryProto.FsActionProto)req.getMode()));
            return null;
        }, vo -> VOID_CHECKACCESS_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.SetStoragePolicyResponseProto setStoragePolicy(RpcController controller, ClientNamenodeProtocolProtos.SetStoragePolicyRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.setStoragePolicy(request.getSrc(), request.getPolicyName());
            return null;
        }, vo -> VOID_SET_STORAGE_POLICY_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.UnsetStoragePolicyResponseProto unsetStoragePolicy(RpcController controller, ClientNamenodeProtocolProtos.UnsetStoragePolicyRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.unsetStoragePolicy(request.getSrc());
            return null;
        }, vo -> VOID_UNSET_STORAGE_POLICY_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.GetStoragePolicyResponseProto getStoragePolicy(RpcController controller, ClientNamenodeProtocolProtos.GetStoragePolicyRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getStoragePolicy(request.getPath()), result -> {
            HdfsProtos.BlockStoragePolicyProto policy = PBHelperClient.convert((BlockStoragePolicy)result);
            return ClientNamenodeProtocolProtos.GetStoragePolicyResponseProto.newBuilder().setStoragePolicy(policy).build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetStoragePoliciesResponseProto getStoragePolicies(RpcController controller, ClientNamenodeProtocolProtos.GetStoragePoliciesRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getStoragePolicies, policies -> {
            ClientNamenodeProtocolProtos.GetStoragePoliciesResponseProto.Builder builder = ClientNamenodeProtocolProtos.GetStoragePoliciesResponseProto.newBuilder();
            if (policies == null) {
                return builder.build();
            }
            for (BlockStoragePolicy policy : policies) {
                builder.addPolicies(PBHelperClient.convert((BlockStoragePolicy)policy));
            }
            return builder.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetCurrentEditLogTxidResponseProto getCurrentEditLogTxid(RpcController controller, ClientNamenodeProtocolProtos.GetCurrentEditLogTxidRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getCurrentEditLogTxid, result -> ClientNamenodeProtocolProtos.GetCurrentEditLogTxidResponseProto.newBuilder().setTxid(result.longValue()).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.GetEditsFromTxidResponseProto getEditsFromTxid(RpcController controller, ClientNamenodeProtocolProtos.GetEditsFromTxidRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getEditsFromTxid(req.getTxid()), PBHelperClient::convertEditsResponse);
        return null;
    }

    public ErasureCodingProtos.GetErasureCodingPoliciesResponseProto getErasureCodingPolicies(RpcController controller, ErasureCodingProtos.GetErasureCodingPoliciesRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getErasureCodingPolicies, ecpInfos -> {
            ErasureCodingProtos.GetErasureCodingPoliciesResponseProto.Builder resBuilder = ErasureCodingProtos.GetErasureCodingPoliciesResponseProto.newBuilder();
            for (ErasureCodingPolicyInfo info : ecpInfos) {
                resBuilder.addEcPolicies(PBHelperClient.convertErasureCodingPolicy((ErasureCodingPolicyInfo)info));
            }
            return resBuilder.build();
        });
        return null;
    }

    public ErasureCodingProtos.GetErasureCodingCodecsResponseProto getErasureCodingCodecs(RpcController controller, ErasureCodingProtos.GetErasureCodingCodecsRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getErasureCodingCodecs, codecs -> {
            ErasureCodingProtos.GetErasureCodingCodecsResponseProto.Builder resBuilder = ErasureCodingProtos.GetErasureCodingCodecsResponseProto.newBuilder();
            for (Map.Entry codec : codecs.entrySet()) {
                resBuilder.addCodec(PBHelperClient.convertErasureCodingCodec((String)((String)codec.getKey()), (String)((String)codec.getValue())));
            }
            return resBuilder.build();
        });
        return null;
    }

    public ErasureCodingProtos.AddErasureCodingPoliciesResponseProto addErasureCodingPolicies(RpcController controller, ErasureCodingProtos.AddErasureCodingPoliciesRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            ErasureCodingPolicy[] policies = (ErasureCodingPolicy[])request.getEcPoliciesList().stream().map(PBHelperClient::convertErasureCodingPolicy).toArray(ErasureCodingPolicy[]::new);
            return this.server.addErasureCodingPolicies(policies);
        }, result -> {
            List responseProtos = Arrays.stream(result).map(PBHelperClient::convertAddErasureCodingPolicyResponse).collect(Collectors.toList());
            ErasureCodingProtos.AddErasureCodingPoliciesResponseProto response = ErasureCodingProtos.AddErasureCodingPoliciesResponseProto.newBuilder().addAllResponses(responseProtos).build();
            return response;
        });
        return null;
    }

    public ErasureCodingProtos.RemoveErasureCodingPolicyResponseProto removeErasureCodingPolicy(RpcController controller, ErasureCodingProtos.RemoveErasureCodingPolicyRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.removeErasureCodingPolicy(request.getEcPolicyName());
            return null;
        }, vo -> ErasureCodingProtos.RemoveErasureCodingPolicyResponseProto.newBuilder().build());
        return null;
    }

    public ErasureCodingProtos.EnableErasureCodingPolicyResponseProto enableErasureCodingPolicy(RpcController controller, ErasureCodingProtos.EnableErasureCodingPolicyRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.enableErasureCodingPolicy(request.getEcPolicyName());
            return null;
        }, vo -> ErasureCodingProtos.EnableErasureCodingPolicyResponseProto.newBuilder().build());
        return null;
    }

    public ErasureCodingProtos.DisableErasureCodingPolicyResponseProto disableErasureCodingPolicy(RpcController controller, ErasureCodingProtos.DisableErasureCodingPolicyRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.disableErasureCodingPolicy(request.getEcPolicyName());
            return null;
        }, vo -> ErasureCodingProtos.DisableErasureCodingPolicyResponseProto.newBuilder().build());
        return null;
    }

    public ErasureCodingProtos.GetErasureCodingPolicyResponseProto getErasureCodingPolicy(RpcController controller, ErasureCodingProtos.GetErasureCodingPolicyRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getErasureCodingPolicy(request.getSrc()), ecPolicy -> {
            ErasureCodingProtos.GetErasureCodingPolicyResponseProto.Builder builder = ErasureCodingProtos.GetErasureCodingPolicyResponseProto.newBuilder();
            if (ecPolicy != null) {
                builder.setEcPolicy(PBHelperClient.convertErasureCodingPolicy((ErasureCodingPolicy)ecPolicy));
            }
            return builder.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetQuotaUsageResponseProto getQuotaUsage(RpcController controller, ClientNamenodeProtocolProtos.GetQuotaUsageRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getQuotaUsage(req.getPath()), result -> ClientNamenodeProtocolProtos.GetQuotaUsageResponseProto.newBuilder().setUsage(PBHelperClient.convert((QuotaUsage)result)).build());
        return null;
    }

    public ClientNamenodeProtocolProtos.ListOpenFilesResponseProto listOpenFiles(RpcController controller, ClientNamenodeProtocolProtos.ListOpenFilesRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            EnumSet openFilesTypes = PBHelperClient.convertOpenFileTypes((List)req.getTypesList());
            return this.server.listOpenFiles(req.getId(), openFilesTypes, req.getPath());
        }, entries -> {
            ClientNamenodeProtocolProtos.ListOpenFilesResponseProto.Builder builder = ClientNamenodeProtocolProtos.ListOpenFilesResponseProto.newBuilder();
            builder.setHasMore(entries.hasMore());
            for (int i = 0; i < entries.size(); ++i) {
                builder.addEntries(PBHelperClient.convert((OpenFileEntry)((OpenFileEntry)entries.get(i))));
            }
            builder.addAllTypes((Iterable)req.getTypesList());
            return builder.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.MsyncResponseProto msync(RpcController controller, ClientNamenodeProtocolProtos.MsyncRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.msync();
            return null;
        }, vo -> ClientNamenodeProtocolProtos.MsyncResponseProto.newBuilder().build());
        return null;
    }

    public ClientNamenodeProtocolProtos.SatisfyStoragePolicyResponseProto satisfyStoragePolicy(RpcController controller, ClientNamenodeProtocolProtos.SatisfyStoragePolicyRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> {
            this.server.satisfyStoragePolicy(request.getSrc());
            return null;
        }, vo -> VOID_SATISFYSTORAGEPOLICY_RESPONSE);
        return null;
    }

    public ClientNamenodeProtocolProtos.HAServiceStateResponseProto getHAServiceState(RpcController controller, ClientNamenodeProtocolProtos.HAServiceStateRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getHAServiceState, state -> {
            HAServiceProtocolProtos.HAServiceStateProto retState = switch (state) {
                case HAServiceProtocol.HAServiceState.ACTIVE -> HAServiceProtocolProtos.HAServiceStateProto.ACTIVE;
                case HAServiceProtocol.HAServiceState.STANDBY -> HAServiceProtocolProtos.HAServiceStateProto.STANDBY;
                case HAServiceProtocol.HAServiceState.OBSERVER -> HAServiceProtocolProtos.HAServiceStateProto.OBSERVER;
                default -> HAServiceProtocolProtos.HAServiceStateProto.INITIALIZING;
            };
            ClientNamenodeProtocolProtos.HAServiceStateResponseProto.Builder builder = ClientNamenodeProtocolProtos.HAServiceStateResponseProto.newBuilder();
            builder.setState(retState);
            return builder.build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetSlowDatanodeReportResponseProto getSlowDatanodeReport(RpcController controller, ClientNamenodeProtocolProtos.GetSlowDatanodeReportRequestProto request) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(this.server::getSlowDatanodeReport, res -> {
            List result = PBHelperClient.convert((DatanodeInfo[])res);
            return ClientNamenodeProtocolProtos.GetSlowDatanodeReportResponseProto.newBuilder().addAllDatanodeInfoProto((Iterable)result).build();
        });
        return null;
    }

    public ClientNamenodeProtocolProtos.GetEnclosingRootResponseProto getEnclosingRoot(RpcController controller, ClientNamenodeProtocolProtos.GetEnclosingRootRequestProto req) {
        AsyncRpcProtocolPBUtil.asyncRouterServer(() -> this.server.getEnclosingRoot(req.getFilename()), enclosingRootPath -> ClientNamenodeProtocolProtos.GetEnclosingRootResponseProto.newBuilder().setEnclosingRootPath(enclosingRootPath.toUri().toString()).build());
        return null;
    }
}

