/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import org.apache.hadoop.hdfs.server.federation.router.ThreadLocalContext;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.ApplyFunction;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.Async;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.ProtobufRpcEngine2;
import org.apache.hadoop.ipc.ProtobufRpcEngineCallback2;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.ipc.internal.ShadedProtobufHelper;
import org.apache.hadoop.thirdparty.protobuf.Message;
import org.apache.hadoop.util.concurrent.AsyncGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AsyncRpcProtocolPBUtil {
    public static final Logger LOG = LoggerFactory.getLogger(AsyncRpcProtocolPBUtil.class);
    private static Executor asyncResponderExecutor;

    private AsyncRpcProtocolPBUtil() {
    }

    public static <T, R> R asyncIpcClient(ShadedProtobufHelper.IpcCall<T> call, ApplyFunction<T, R> response, Class<R> clazz) throws IOException {
        ShadedProtobufHelper.ipc(call);
        AsyncGet asyncReqMessage = ProtobufRpcEngine2.getAsyncReturnMessage();
        CompletableFuture responseFuture = Client.getResponseFuture();
        ThreadLocalContext threadLocalContext = new ThreadLocalContext();
        AsyncUtil.asyncCompleteWith(responseFuture.handleAsync((result, e) -> {
            threadLocalContext.transfer();
            if (e != null) {
                throw Async.warpCompletionException(e);
            }
            try {
                Object res = asyncReqMessage.get(-1L, null);
                LOG.debug("Async IPC Request, Call={}, CallerContext={}, Result={}", new Object[]{Server.getCurCall().get(), CallerContext.getCurrent(), res});
                return response.apply(res);
            }
            catch (Exception ex) {
                throw Async.warpCompletionException(ex);
            }
        }, asyncResponderExecutor));
        return AsyncUtil.asyncReturn(clazz);
    }

    public static <T> void asyncRouterServer(ServerReq<T> req, ServerRes<T> res) {
        ProtobufRpcEngineCallback2 callback = ProtobufRpcEngine2.Server.registerForDeferredResponse2();
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        ((CompletableFuture)completableFuture.thenCompose(o -> {
            try {
                req.req();
                return AsyncUtil.getAsyncUtilCompletableFuture();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        })).handle((result, e) -> {
            LOG.debug("Async response, callback: {}, CallerContext: {}, result: [{}], exception: [{}]", new Object[]{callback, CallerContext.getCurrent(), result, e});
            if (e == null) {
                Message value = null;
                try {
                    value = res.res(result);
                }
                catch (Exception re) {
                    callback.error((Throwable)re);
                    return null;
                }
                callback.setResponse(value);
            } else {
                callback.error(e.getCause());
            }
            return null;
        });
    }

    public static void setAsyncResponderExecutor(Executor asyncResponderExecutor) {
        AsyncRpcProtocolPBUtil.asyncResponderExecutor = asyncResponderExecutor;
    }

    @FunctionalInterface
    static interface ServerReq<T> {
        public T req() throws Exception;
    }

    @FunctionalInterface
    static interface ServerRes<T> {
        public Message res(T var1) throws Exception;
    }
}

