/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreSerializer;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MockStateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.hdfs.server.federation.store.records.StateStoreVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRouterState {
    private static final String ADDRESS = "address";
    private static final String VERSION = "version";
    private static final String COMPILE_INFO = "compileInfo";
    private static final long START_TIME = 100L;
    private static final long DATE_MODIFIED = 200L;
    private static final long DATE_CREATED = 300L;
    private static final long FILE_RESOLVER_VERSION = 500L;
    private static final RouterServiceState STATE = RouterServiceState.RUNNING;

    private RouterState generateRecord() {
        RouterState record = RouterState.newInstance((String)ADDRESS, (long)100L, (RouterServiceState)STATE);
        record.setVersion(VERSION);
        record.setCompileInfo(COMPILE_INFO);
        record.setDateCreated(300L);
        record.setDateModified(200L);
        StateStoreVersion version = StateStoreVersion.newInstance();
        version.setMountTableVersion(500L);
        record.setStateStoreVersion(version);
        return record;
    }

    private void validateRecord(RouterState record) throws IOException {
        Assertions.assertEquals((Object)ADDRESS, (Object)record.getAddress());
        Assertions.assertEquals((long)100L, (long)record.getDateStarted());
        Assertions.assertEquals((Object)STATE, (Object)record.getStatus());
        Assertions.assertEquals((Object)COMPILE_INFO, (Object)record.getCompileInfo());
        Assertions.assertEquals((Object)VERSION, (Object)record.getVersion());
        StateStoreVersion version = record.getStateStoreVersion();
        Assertions.assertEquals((long)500L, (long)version.getMountTableVersion());
    }

    @Test
    public void testGetterSetter() throws IOException {
        RouterState record = this.generateRecord();
        this.validateRecord(record);
    }

    @Test
    public void testSerialization() throws IOException {
        RouterState record = this.generateRecord();
        StateStoreSerializer serializer = StateStoreSerializer.getSerializer();
        String serializedString = serializer.serializeString((BaseRecord)record);
        RouterState newRecord = (RouterState)serializer.deserialize(serializedString, RouterState.class);
        this.validateRecord(newRecord);
    }

    @Test
    public void testStateStoreResilience() throws Exception {
        StateStoreService service = new StateStoreService();
        Configuration conf = new Configuration();
        conf.setClass("dfs.federation.router.store.driver.class", MockStateStoreDriver.class, StateStoreDriver.class);
        conf.setBoolean("dfs.federation.router.metrics.enable", false);
        service.init(conf);
        MockStateStoreDriver driver = (MockStateStoreDriver)service.getDriver();
        driver.clearAll();
        driver.put((BaseRecord)MembershipState.newInstance((String)"routerId", (String)"ns1", (String)"ns1-ha1", (String)"cluster1", (String)"block1", (String)"rpc1", (String)"service1", (String)"lifeline1", (String)"https", (String)"nn01", (FederationNamenodeServiceState)FederationNamenodeServiceState.ACTIVE, (boolean)false), false, false);
        driver.put((BaseRecord)MembershipState.newInstance((String)"routerId", (String)"ns1", (String)"ns1-ha2", (String)"cluster1", (String)"block1", (String)"rpc2", (String)"service2", (String)"lifeline2", (String)"https", (String)"nn02", (FederationNamenodeServiceState)FederationNamenodeServiceState.STANDBY, (boolean)false), false, false);
        service.loadDriver();
        MembershipNamenodeResolver resolver = new MembershipNamenodeResolver(conf, service);
        service.refreshCaches(true);
        List result = resolver.getNamenodesForBlockPoolId("block1");
        Assertions.assertEquals((int)2, (int)result.size());
        driver.setGiveErrors(true);
        long previousUpdate = service.getCacheUpdateTime();
        service.refreshCaches(true);
        Assertions.assertEquals((long)previousUpdate, (long)service.getCacheUpdateTime());
        result = resolver.getNamenodesForBlockPoolId("block1");
        Assertions.assertEquals((int)2, (int)result.size());
        service.stop();
    }
}

