/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreSerializer;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMountTable {
    private static final String SRC = "/test";
    private static final String DST_NS_0 = "ns0";
    private static final String DST_NS_1 = "ns1";
    private static final String DST_PATH_0 = "/path1";
    private static final String DST_PATH_1 = "/path/path2";
    private static final List<RemoteLocation> DST = new LinkedList<RemoteLocation>();
    private static final Map<String, String> DST_MAP;
    private static final long DATE_CREATED = 100L;
    private static final long DATE_MOD = 200L;
    private static final long NS_COUNT = 1L;
    private static final long NS_QUOTA = 5L;
    private static final long SS_COUNT = 10L;
    private static final long SS_QUOTA = 100L;
    private static final RouterQuotaUsage QUOTA;

    @Test
    public void testGetterSetter() throws IOException {
        MountTable record = MountTable.newInstance((String)SRC, DST_MAP);
        this.validateDestinations(record);
        Assertions.assertEquals((Object)SRC, (Object)record.getSourcePath());
        Assertions.assertEquals(DST, (Object)record.getDestinations());
        Assertions.assertTrue((boolean)true);
        Assertions.assertTrue((boolean)true);
        RouterQuotaUsage quota = record.getQuota();
        Assertions.assertEquals((long)0L, (long)quota.getFileAndDirectoryCount());
        Assertions.assertEquals((long)-1L, (long)quota.getQuota());
        Assertions.assertEquals((long)0L, (long)quota.getSpaceConsumed());
        Assertions.assertEquals((long)-1L, (long)quota.getSpaceQuota());
        MountTable record2 = MountTable.newInstance((String)SRC, DST_MAP, (long)100L, (long)200L);
        this.validateDestinations(record2);
        Assertions.assertEquals((Object)SRC, (Object)record2.getSourcePath());
        Assertions.assertEquals(DST, (Object)record2.getDestinations());
        Assertions.assertEquals((long)100L, (long)record2.getDateCreated());
        Assertions.assertEquals((long)200L, (long)record2.getDateModified());
        Assertions.assertFalse((boolean)record.isReadOnly());
        Assertions.assertEquals((Object)DestinationOrder.HASH, (Object)record.getDestOrder());
    }

    @Test
    public void testSerialization() throws IOException {
        this.testSerialization(DestinationOrder.RANDOM);
        this.testSerialization(DestinationOrder.HASH);
        this.testSerialization(DestinationOrder.LOCAL);
    }

    private void testSerialization(DestinationOrder order) throws IOException {
        MountTable record = MountTable.newInstance((String)SRC, DST_MAP, (long)100L, (long)200L);
        record.setReadOnly(true);
        record.setDestOrder(order);
        record.setQuota(QUOTA);
        StateStoreSerializer serializer = StateStoreSerializer.getSerializer();
        String serializedString = serializer.serializeString((BaseRecord)record);
        MountTable record2 = (MountTable)serializer.deserialize(serializedString, MountTable.class);
        this.validateDestinations(record2);
        Assertions.assertEquals((Object)SRC, (Object)record2.getSourcePath());
        Assertions.assertEquals(DST, (Object)record2.getDestinations());
        Assertions.assertEquals((long)100L, (long)record2.getDateCreated());
        Assertions.assertEquals((long)200L, (long)record2.getDateModified());
        Assertions.assertTrue((boolean)record2.isReadOnly());
        Assertions.assertEquals((Object)order, (Object)record2.getDestOrder());
        RouterQuotaUsage quotaGet = record2.getQuota();
        Assertions.assertEquals((long)1L, (long)quotaGet.getFileAndDirectoryCount());
        Assertions.assertEquals((long)5L, (long)quotaGet.getQuota());
        Assertions.assertEquals((long)10L, (long)quotaGet.getSpaceConsumed());
        Assertions.assertEquals((long)100L, (long)quotaGet.getSpaceQuota());
    }

    @Test
    public void testReadOnly() throws IOException {
        LinkedHashMap<String, String> dest = new LinkedHashMap<String, String>();
        dest.put(DST_NS_0, DST_PATH_0);
        dest.put(DST_NS_1, DST_PATH_1);
        MountTable record1 = MountTable.newInstance((String)SRC, dest);
        record1.setReadOnly(true);
        this.validateDestinations(record1);
        Assertions.assertEquals((Object)SRC, (Object)record1.getSourcePath());
        Assertions.assertEquals(DST, (Object)record1.getDestinations());
        Assertions.assertTrue((boolean)true);
        Assertions.assertTrue((boolean)true);
        Assertions.assertTrue((boolean)record1.isReadOnly());
        MountTable record2 = MountTable.newInstance((String)SRC, DST_MAP, (long)100L, (long)200L);
        record2.setReadOnly(true);
        this.validateDestinations(record2);
        Assertions.assertEquals((Object)SRC, (Object)record2.getSourcePath());
        Assertions.assertEquals(DST, (Object)record2.getDestinations());
        Assertions.assertEquals((long)100L, (long)record2.getDateCreated());
        Assertions.assertEquals((long)200L, (long)record2.getDateModified());
        Assertions.assertTrue((boolean)record2.isReadOnly());
    }

    @Test
    public void testFaultTolerant() throws IOException {
        LinkedHashMap<String, String> dest = new LinkedHashMap<String, String>();
        dest.put(DST_NS_0, DST_PATH_0);
        dest.put(DST_NS_1, DST_PATH_1);
        MountTable record0 = MountTable.newInstance((String)SRC, dest);
        Assertions.assertFalse((boolean)record0.isFaultTolerant());
        MountTable record1 = MountTable.newInstance((String)SRC, dest);
        Assertions.assertFalse((boolean)record1.isFaultTolerant());
        Assertions.assertEquals((Object)record0, (Object)record1);
        record1.setFaultTolerant(true);
        Assertions.assertTrue((boolean)record1.isFaultTolerant());
        Assertions.assertNotEquals((Object)record0, (Object)record1);
    }

    @Test
    public void testOrder() throws IOException {
        this.testOrder(DestinationOrder.HASH);
        this.testOrder(DestinationOrder.LOCAL);
        this.testOrder(DestinationOrder.RANDOM);
    }

    private void testOrder(DestinationOrder order) throws IOException {
        MountTable record = MountTable.newInstance((String)SRC, DST_MAP, (long)100L, (long)200L);
        record.setDestOrder(order);
        this.validateDestinations(record);
        Assertions.assertEquals((Object)SRC, (Object)record.getSourcePath());
        Assertions.assertEquals(DST, (Object)record.getDestinations());
        Assertions.assertEquals((long)100L, (long)record.getDateCreated());
        Assertions.assertEquals((long)200L, (long)record.getDateModified());
        Assertions.assertEquals((Object)order, (Object)record.getDestOrder());
    }

    private void validateDestinations(MountTable record) {
        Assertions.assertEquals((Object)SRC, (Object)record.getSourcePath());
        Assertions.assertEquals((int)2, (int)record.getDestinations().size());
        RemoteLocation location1 = (RemoteLocation)record.getDestinations().get(0);
        Assertions.assertEquals((Object)DST_NS_0, (Object)location1.getNameserviceId());
        Assertions.assertEquals((Object)DST_PATH_0, (Object)location1.getDest());
        RemoteLocation location2 = (RemoteLocation)record.getDestinations().get(1);
        Assertions.assertEquals((Object)DST_NS_1, (Object)location2.getNameserviceId());
        Assertions.assertEquals((Object)DST_PATH_1, (Object)location2.getDest());
    }

    @Test
    public void testQuota() throws IOException {
        MountTable record = MountTable.newInstance((String)SRC, DST_MAP);
        record.setQuota(QUOTA);
        this.validateDestinations(record);
        Assertions.assertEquals((Object)SRC, (Object)record.getSourcePath());
        Assertions.assertEquals(DST, (Object)record.getDestinations());
        Assertions.assertTrue((boolean)true);
        Assertions.assertTrue((boolean)true);
        RouterQuotaUsage quotaGet = record.getQuota();
        Assertions.assertEquals((long)1L, (long)quotaGet.getFileAndDirectoryCount());
        Assertions.assertEquals((long)5L, (long)quotaGet.getQuota());
        Assertions.assertEquals((long)10L, (long)quotaGet.getSpaceConsumed());
        Assertions.assertEquals((long)100L, (long)quotaGet.getSpaceQuota());
    }

    @Test
    public void testValidation() throws IOException {
        HashMap<String, String> destinations = new HashMap<String, String>();
        destinations.put(DST_NS_0, "/testValidate-dest");
        try {
            MountTable.newInstance((String)"testValidate", destinations);
            Assertions.fail((String)"Mount table entry should be created failed.");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid entry, all mount points must start with / ", (Throwable)e);
        }
        destinations.clear();
        destinations.put(DST_NS_0, "testValidate-dest");
        try {
            MountTable.newInstance((String)"/testValidate", destinations);
            Assertions.fail((String)"Mount table entry should be created failed.");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid entry, all destination must start with / ", (Throwable)e);
        }
        destinations.clear();
        destinations.put("", "/testValidate-dest");
        try {
            MountTable.newInstance((String)"/testValidate", destinations);
            Assertions.fail((String)"Mount table entry should be created failed.");
        }
        catch (Exception e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid entry, invalid destination nameservice ", (Throwable)e);
        }
        destinations.clear();
        destinations.put(DST_NS_0, "/testValidate-dest");
        MountTable record = MountTable.newInstance((String)"/testValidate", destinations);
        Assertions.assertNotNull((Object)record);
    }

    static {
        DST.add(new RemoteLocation(DST_NS_0, DST_PATH_0, SRC));
        DST.add(new RemoteLocation(DST_NS_1, DST_PATH_1, SRC));
        DST_MAP = new LinkedHashMap<String, String>();
        DST_MAP.put(DST_NS_0, DST_PATH_0);
        DST_MAP.put(DST_NS_1, DST_PATH_1);
        QUOTA = new RouterQuotaUsage.Builder().fileAndDirectoryCount(1L).quota(5L).spaceConsumed(10L).spaceQuota(100L).build();
    }
}

