/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.driver.TestStateStoreDriverBase;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreZooKeeperImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.DisabledNameservice;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.util.Time;
import org.apache.zookeeper.CreateMode;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestStateStoreZK
extends TestStateStoreDriverBase {
    private static TestingServer curatorTestingServer;
    private static CuratorFramework curatorFramework;
    private static String baseZNode;

    @BeforeAll
    public static void setupCluster() throws Exception {
        curatorTestingServer = new TestingServer();
        curatorTestingServer.start();
        String connectString = curatorTestingServer.getConnectString();
        curatorFramework = CuratorFrameworkFactory.builder().connectString(connectString).retryPolicy((RetryPolicy)new RetryNTimes(100, 100)).build();
        curatorFramework.start();
        Configuration conf = FederationStateStoreTestUtils.getStateStoreConfiguration(StateStoreZooKeeperImpl.class);
        conf.set("dfs.federation.router.store.driver.zk.address", connectString);
        conf.setLong("dfs.federation.router.store.connection.test", TimeUnit.HOURS.toMillis(1L));
        conf.setInt("dfs.federation.router.store.driver.zk.async.max.threads", 10);
        baseZNode = conf.get("dfs.federation.router.store.driver.zk.parent-path", "/hdfs-federation");
        TestStateStoreZK.getStateStore(conf);
    }

    @AfterAll
    public static void tearDownCluster() {
        curatorFramework.close();
        try {
            curatorTestingServer.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @BeforeEach
    public void startup() throws IOException {
        TestStateStoreZK.removeAll(this.getStateStoreDriver());
        StateStoreZooKeeperImpl stateStoreZooKeeper = (StateStoreZooKeeperImpl)this.getStateStoreDriver();
        stateStoreZooKeeper.setEnableConcurrent(false);
    }

    private <T extends BaseRecord> String generateFakeZNode(Class<T> recordClass) throws IOException {
        String nodeName = StateStoreUtils.getRecordName(recordClass);
        String primaryKey = "test";
        if (nodeName != null) {
            return baseZNode + "/" + nodeName + "/" + primaryKey;
        }
        return null;
    }

    private void testGetNullRecord(StateStoreDriver driver) throws Exception {
        this.testGetNullRecord(driver, MembershipState.class);
        this.testGetNullRecord(driver, MountTable.class);
        this.testGetNullRecord(driver, RouterState.class);
        this.testGetNullRecord(driver, DisabledNameservice.class);
    }

    private <T extends BaseRecord> void testGetNullRecord(StateStoreDriver driver, Class<T> recordClass) throws Exception {
        driver.removeAll(recordClass);
        String znode = this.generateFakeZNode(recordClass);
        Assertions.assertNull((Object)curatorFramework.checkExists().forPath(znode));
        ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)curatorFramework.create().withMode(CreateMode.PERSISTENT)).withACL(null)).forPath(znode, null);
        Assertions.assertNotNull((Object)curatorFramework.checkExists().forPath(znode));
        driver.get(recordClass);
        Assertions.assertNull((Object)curatorFramework.checkExists().forPath(znode));
    }

    @Test
    public void testAsyncPerformance() throws Exception {
        StateStoreZooKeeperImpl stateStoreDriver = (StateStoreZooKeeperImpl)this.getStateStoreDriver();
        ArrayList<MountTable> insertList = new ArrayList<MountTable>();
        for (int i = 0; i < 1000; ++i) {
            MountTable newRecord = this.generateFakeRecord(MountTable.class);
            insertList.add(newRecord);
        }
        long startSyncPut = Time.now();
        stateStoreDriver.putAll(insertList, true, false);
        long endSyncPut = Time.now();
        long startSyncRemove = Time.now();
        for (MountTable entry : insertList.subList(0, 5)) {
            stateStoreDriver.remove((BaseRecord)entry);
        }
        long endSyncRemove = Time.now();
        stateStoreDriver.removeAll(MembershipState.class);
        stateStoreDriver.setEnableConcurrent(true);
        long startAsyncPut = Time.now();
        stateStoreDriver.putAll(insertList, true, false);
        long endAsyncPut = Time.now();
        long startAsyncRemove = Time.now();
        stateStoreDriver.removeMultiple(insertList.subList(0, 5));
        long endAsyncRemove = Time.now();
        Assertions.assertTrue((endSyncPut - startSyncPut > endAsyncPut - startAsyncPut ? 1 : 0) != 0);
        Assertions.assertTrue((endSyncRemove - startSyncRemove > endAsyncRemove - startAsyncRemove ? 1 : 0) != 0);
    }

    @Test
    public void testGetNullRecord() throws Exception {
        StateStoreZooKeeperImpl stateStoreDriver = (StateStoreZooKeeperImpl)this.getStateStoreDriver();
        this.testGetNullRecord((StateStoreDriver)stateStoreDriver);
        stateStoreDriver.setEnableConcurrent(true);
        this.testGetNullRecord((StateStoreDriver)stateStoreDriver);
    }

    @Test
    public void testInsert() throws IllegalArgumentException, IllegalAccessException, IOException {
        StateStoreZooKeeperImpl stateStoreDriver = (StateStoreZooKeeperImpl)this.getStateStoreDriver();
        this.testInsert((StateStoreDriver)stateStoreDriver);
        stateStoreDriver.setEnableConcurrent(true);
        this.testInsert((StateStoreDriver)stateStoreDriver);
    }

    @Test
    public void testUpdate() throws IllegalArgumentException, ReflectiveOperationException, IOException, SecurityException {
        StateStoreZooKeeperImpl stateStoreDriver = (StateStoreZooKeeperImpl)this.getStateStoreDriver();
        this.testPut((StateStoreDriver)stateStoreDriver);
        stateStoreDriver.setEnableConcurrent(true);
        this.testPut((StateStoreDriver)stateStoreDriver);
    }

    @Test
    public void testDelete() throws IllegalArgumentException, IllegalAccessException, IOException {
        StateStoreZooKeeperImpl stateStoreDriver = (StateStoreZooKeeperImpl)this.getStateStoreDriver();
        this.testRemove((StateStoreDriver)stateStoreDriver);
        stateStoreDriver.setEnableConcurrent(true);
        this.testRemove((StateStoreDriver)stateStoreDriver);
    }

    @Test
    public void testFetchErrors() throws IllegalArgumentException, IllegalAccessException, IOException {
        StateStoreZooKeeperImpl stateStoreDriver = (StateStoreZooKeeperImpl)this.getStateStoreDriver();
        this.testFetchErrors((StateStoreDriver)stateStoreDriver);
        stateStoreDriver.setEnableConcurrent(true);
        this.testFetchErrors((StateStoreDriver)stateStoreDriver);
    }

    @Test
    public void testCacheLoadMetrics() throws IOException {
        this.getStateStoreService().getMetrics().setCacheLoading("MountTable", -1L);
        long curMountTableLoadNum = this.getMountTableCacheLoadSamples(this.getStateStoreDriver());
        this.getStateStoreService().refreshCaches(true);
        this.getStateStoreService().refreshCaches(true);
        this.getStateStoreService().refreshCaches(true);
        this.testCacheLoadMetrics(this.getStateStoreDriver(), curMountTableLoadNum + 3L, -1.0);
    }
}

