/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreDriver;
import org.apache.hadoop.hdfs.server.federation.store.driver.TestStateStoreDriverBase;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileBaseImpl;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileSystemImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TestStateStoreFileSystem
extends TestStateStoreDriverBase {
    private static MiniDFSCluster dfsCluster;
    private String numFsAsyncThreads;

    public void initTestStateStoreFileSystem(String pNumFsAsyncThreads) throws Exception {
        this.numFsAsyncThreads = pNumFsAsyncThreads;
        TestStateStoreFileSystem.setupCluster(this.numFsAsyncThreads);
        TestStateStoreFileSystem.removeAll(this.getStateStoreDriver());
    }

    private static void setupCluster(String numFsAsyncThreads) throws Exception {
        Configuration conf = FederationStateStoreTestUtils.getStateStoreConfiguration(StateStoreFileSystemImpl.class);
        conf.set("dfs.federation.router.store.driver.fs.path", "/hdfs-federation/");
        conf.setInt("dfs.federation.router.store.driver.fs.async.threads", Integer.parseInt(numFsAsyncThreads));
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder(conf);
        builder.numDataNodes(1);
        dfsCluster = builder.build();
        dfsCluster.waitClusterUp();
        TestStateStoreFileSystem.getStateStore(conf);
    }

    public static List<String[]> data() {
        return Arrays.asList({"20"}, {"0"});
    }

    public void startup() throws Exception {
        TestStateStoreFileSystem.setupCluster(this.numFsAsyncThreads);
        TestStateStoreFileSystem.removeAll(this.getStateStoreDriver());
    }

    @AfterEach
    public void tearDown() throws Exception {
        TestStateStoreFileSystem.tearDownCluster();
        if (dfsCluster != null) {
            dfsCluster.shutdown();
            dfsCluster = null;
        }
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testInsert(String pNumFsAsyncThreads) throws Exception {
        this.initTestStateStoreFileSystem(pNumFsAsyncThreads);
        this.testInsert(this.getStateStoreDriver());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testUpdate(String pNumFsAsyncThreads) throws Exception {
        this.initTestStateStoreFileSystem(pNumFsAsyncThreads);
        this.testPut(this.getStateStoreDriver());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testDelete(String pNumFsAsyncThreads) throws Exception {
        this.initTestStateStoreFileSystem(pNumFsAsyncThreads);
        this.testRemove(this.getStateStoreDriver());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testFetchErrors(String pNumFsAsyncThreads) throws Exception {
        this.initTestStateStoreFileSystem(pNumFsAsyncThreads);
        this.testFetchErrors(this.getStateStoreDriver());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testMetrics(String pNumFsAsyncThreads) throws Exception {
        this.initTestStateStoreFileSystem(pNumFsAsyncThreads);
        this.testMetrics(this.getStateStoreDriver());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testInsertWithErrorDuringWrite(String pNumFsAsyncThreads) throws Exception {
        this.initTestStateStoreFileSystem(pNumFsAsyncThreads);
        StateStoreFileBaseImpl driver = (StateStoreFileBaseImpl)Mockito.spy((Object)((StateStoreFileBaseImpl)this.getStateStoreDriver()));
        ((StateStoreFileBaseImpl)Mockito.doAnswer(a -> {
            BufferedWriter writer = (BufferedWriter)a.callRealMethod();
            BufferedWriter spyWriter = (BufferedWriter)Mockito.spy((Object)writer);
            ((BufferedWriter)Mockito.doThrow(IOException.class).when((Object)spyWriter)).write((String)Mockito.any(String.class));
            return spyWriter;
        }).when((Object)driver)).getWriter((String)Mockito.any());
        this.testInsertWithErrorDuringWrite((StateStoreDriver)driver, MembershipState.class);
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testCacheLoadMetrics(String pNumFsAsyncThreads) throws Exception {
        this.initTestStateStoreFileSystem(pNumFsAsyncThreads);
        this.getStateStoreService().getMetrics().setCacheLoading("MountTable", -1L);
        long curMountTableLoadNum = this.getMountTableCacheLoadSamples(this.getStateStoreDriver());
        this.getStateStoreService().refreshCaches(true);
        this.getStateStoreService().refreshCaches(true);
        this.testCacheLoadMetrics(this.getStateStoreDriver(), curMountTableLoadNum + 2L, -1.0);
    }
}

