/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.TestStateStoreDriverBase;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileImpl;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestStateStoreFile
extends TestStateStoreDriverBase {
    private String numFileAsyncThreads;

    public void initTestStateStoreFile(String pBumFileAsyncThreads) throws Exception {
        this.numFileAsyncThreads = pBumFileAsyncThreads;
        TestStateStoreFile.setupCluster(this.numFileAsyncThreads);
        TestStateStoreFile.removeAll(this.getStateStoreDriver());
    }

    public static List<String[]> data() {
        return Arrays.asList({"20"}, {"0"});
    }

    private static void setupCluster(String numFsAsyncThreads) throws Exception {
        Configuration conf = FederationStateStoreTestUtils.getStateStoreConfiguration(StateStoreFileImpl.class);
        conf.setInt("dfs.federation.router.store.driver.file.async.threads", Integer.parseInt(numFsAsyncThreads));
        TestStateStoreFile.getStateStore(conf);
    }

    public void startup() throws Exception {
        TestStateStoreFile.setupCluster(this.numFileAsyncThreads);
        TestStateStoreFile.removeAll(this.getStateStoreDriver());
    }

    @AfterEach
    public void tearDown() throws Exception {
        TestStateStoreFile.tearDownCluster();
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testInsert(String pBumFileAsyncThreads) throws Exception {
        this.initTestStateStoreFile(pBumFileAsyncThreads);
        this.testInsert(this.getStateStoreDriver());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testUpdate(String pBumFileAsyncThreads) throws Exception {
        this.initTestStateStoreFile(pBumFileAsyncThreads);
        this.testPut(this.getStateStoreDriver());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testDelete(String pBumFileAsyncThreads) throws Exception {
        this.initTestStateStoreFile(pBumFileAsyncThreads);
        this.testRemove(this.getStateStoreDriver());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testFetchErrors(String pBumFileAsyncThreads) throws Exception {
        this.initTestStateStoreFile(pBumFileAsyncThreads);
        this.testFetchErrors(this.getStateStoreDriver());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testMetrics(String pBumFileAsyncThreads) throws Exception {
        this.initTestStateStoreFile(pBumFileAsyncThreads);
        this.testMetrics(this.getStateStoreDriver());
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    public void testCacheLoadMetrics(String pBumFileAsyncThreads) throws Exception {
        this.initTestStateStoreFile(pBumFileAsyncThreads);
        this.getStateStoreService().getMetrics().setCacheLoading("MountTable", -1L);
        long curMountTableLoadNum = this.getMountTableCacheLoadSamples(this.getStateStoreDriver());
        this.getStateStoreService().refreshCaches(true);
        this.testCacheLoadMetrics(this.getStateStoreDriver(), curMountTableLoadNum + 1L, -1.0);
    }
}

