/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.router.FederationUtil;
import org.apache.hadoop.hdfs.server.federation.router.RouterServiceState;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.RouterStore;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUnavailableException;
import org.apache.hadoop.hdfs.server.federation.store.TestStateStoreBase;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetRouterRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RouterHeartbeatRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestStateStoreRouterState
extends TestStateStoreBase {
    private static RouterStore routerStore;

    @BeforeAll
    public static void create() {
        TestStateStoreRouterState.getConf().setTimeDuration("dfs.federation.router.store.router.expiration", 2L, TimeUnit.SECONDS);
        TestStateStoreRouterState.getConf().setTimeDuration("dfs.federation.router.store.router.expiration.deletion", 2L, TimeUnit.SECONDS);
    }

    @BeforeEach
    public void setup() throws IOException, InterruptedException {
        if (routerStore == null) {
            routerStore = (RouterStore)TestStateStoreRouterState.getStateStore().getRegisteredRecordStore(RouterStore.class);
        }
        Assertions.assertTrue((boolean)FederationStateStoreTestUtils.clearRecords(TestStateStoreRouterState.getStateStore(), RouterState.class));
    }

    @Test
    public void testStateStoreDisconnected() throws Exception {
        TestStateStoreRouterState.getStateStore().closeDriver();
        Assertions.assertEquals((Object)false, (Object)TestStateStoreRouterState.getStateStore().isDriverReady());
        GetRouterRegistrationRequest getSingleRequest = GetRouterRegistrationRequest.newInstance();
        FederationTestUtils.verifyException(routerStore, "getRouterRegistration", StateStoreUnavailableException.class, new Class[]{GetRouterRegistrationRequest.class}, new Object[]{getSingleRequest});
        GetRouterRegistrationsRequest getRequest = GetRouterRegistrationsRequest.newInstance();
        routerStore.loadCache(true);
        FederationTestUtils.verifyException(routerStore, "getRouterRegistrations", StateStoreUnavailableException.class, new Class[]{GetRouterRegistrationsRequest.class}, new Object[]{getRequest});
        RouterHeartbeatRequest hbRequest = RouterHeartbeatRequest.newInstance((RouterState)RouterState.newInstance((String)"test", (long)0L, (RouterServiceState)RouterServiceState.UNINITIALIZED));
        FederationTestUtils.verifyException(routerStore, "routerHeartbeat", StateStoreUnavailableException.class, new Class[]{RouterHeartbeatRequest.class}, new Object[]{hbRequest});
    }

    @Test
    public void testUpdateRouterStatus() throws IllegalStateException, IOException {
        long dateStarted = Time.now();
        String address = "testaddress";
        RouterHeartbeatRequest request = RouterHeartbeatRequest.newInstance((RouterState)RouterState.newInstance((String)address, (long)dateStarted, (RouterServiceState)RouterServiceState.RUNNING));
        Assertions.assertTrue((boolean)routerStore.routerHeartbeat(request).getStatus());
        GetRouterRegistrationRequest getRequest = GetRouterRegistrationRequest.newInstance((String)address);
        RouterState record = routerStore.getRouterRegistration(getRequest).getRouter();
        Assertions.assertNotNull((Object)record);
        Assertions.assertEquals((Object)RouterServiceState.RUNNING, (Object)record.getStatus());
        Assertions.assertEquals((Object)address, (Object)record.getAddress());
        Assertions.assertEquals((Object)FederationUtil.getCompileInfo(), (Object)record.getCompileInfo());
        Assertions.assertFalse((boolean)record.getVersion().isEmpty());
    }

    @Test
    public void testRouterStateExpiredAndDeletion() throws IOException, InterruptedException, TimeoutException {
        long dateStarted = Time.now();
        String address = "testaddress";
        RouterHeartbeatRequest request = RouterHeartbeatRequest.newInstance((RouterState)RouterState.newInstance((String)address, (long)dateStarted, (RouterServiceState)RouterServiceState.RUNNING));
        Assertions.assertTrue((boolean)routerStore.routerHeartbeat(request).getStatus());
        GetRouterRegistrationRequest getRequest = GetRouterRegistrationRequest.newInstance((String)address);
        RouterState record = routerStore.getRouterRegistration(getRequest).getRouter();
        Assertions.assertNotNull((Object)record);
        GenericTestUtils.waitFor(() -> {
            try {
                RouterState routerState = routerStore.getRouterRegistration(getRequest).getRouter();
                return routerState.getStatus() == RouterServiceState.EXPIRED;
            }
            catch (IOException e) {
                return false;
            }
        }, (long)100L, (long)3000L);
        Assertions.assertTrue((boolean)routerStore.routerHeartbeat(request).getStatus());
        RouterState r = routerStore.getRouterRegistration(getRequest).getRouter();
        Assertions.assertEquals((Object)RouterServiceState.RUNNING, (Object)r.getStatus());
        GenericTestUtils.waitFor(() -> {
            try {
                RouterState routerState = routerStore.getRouterRegistration(getRequest).getRouter();
                return routerState.getStatus() == RouterServiceState.EXPIRED;
            }
            catch (IOException e) {
                return false;
            }
        }, (long)100L, (long)3000L);
        GenericTestUtils.waitFor(() -> {
            try {
                RouterState routerState = routerStore.getRouterRegistration(getRequest).getRouter();
                return routerState.getStatus() == null;
            }
            catch (IOException e) {
                return false;
            }
        }, (long)100L, (long)3000L);
    }

    @Test
    public void testGetAllRouterStates() throws StateStoreUnavailableException, IOException {
        RouterHeartbeatRequest heartbeatRequest1 = RouterHeartbeatRequest.newInstance((RouterState)RouterState.newInstance((String)"testaddress1", (long)Time.now(), (RouterServiceState)RouterServiceState.RUNNING));
        Assertions.assertTrue((boolean)routerStore.routerHeartbeat(heartbeatRequest1).getStatus());
        RouterHeartbeatRequest heartbeatRequest2 = RouterHeartbeatRequest.newInstance((RouterState)RouterState.newInstance((String)"testaddress2", (long)Time.now(), (RouterServiceState)RouterServiceState.RUNNING));
        Assertions.assertTrue((boolean)routerStore.routerHeartbeat(heartbeatRequest2).getStatus());
        routerStore.loadCache(true);
        GetRouterRegistrationsRequest request = GetRouterRegistrationsRequest.newInstance();
        List entries = routerStore.getRouterRegistrations(request).getRouters();
        Assertions.assertEquals((int)2, (int)entries.size());
        Collections.sort(entries);
        Assertions.assertEquals((Object)"testaddress1", (Object)((RouterState)entries.get(0)).getAddress());
        Assertions.assertEquals((Object)"testaddress2", (Object)((RouterState)entries.get(1)).getAddress());
        Assertions.assertEquals((Object)RouterServiceState.RUNNING, (Object)((RouterState)entries.get(0)).getStatus());
        Assertions.assertEquals((Object)RouterServiceState.RUNNING, (Object)((RouterState)entries.get(1)).getStatus());
    }
}

