/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.hdfs.server.federation.store.DisabledNameserviceStore;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.TestStateStoreBase;
import org.apache.hadoop.hdfs.server.federation.store.records.DisabledNameservice;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestStateStoreDisabledNameservice
extends TestStateStoreBase {
    private static DisabledNameserviceStore disabledStore;

    @BeforeEach
    public void setup() throws IOException, InterruptedException {
        disabledStore = (DisabledNameserviceStore)TestStateStoreDisabledNameservice.getStateStore().getRegisteredRecordStore(DisabledNameserviceStore.class);
        Assertions.assertTrue((boolean)FederationStateStoreTestUtils.clearRecords(TestStateStoreDisabledNameservice.getStateStore(), DisabledNameservice.class));
    }

    @Test
    public void testDisableNameservice() throws IOException {
        Set disabledNameservices = disabledStore.getDisabledNameservices();
        Assertions.assertEquals((int)0, (int)disabledNameservices.size());
        disabledStore.disableNameservice("ns0");
        disabledStore.disableNameservice("ns1");
        disabledStore.loadCache(true);
        disabledNameservices = disabledStore.getDisabledNameservices();
        Assertions.assertEquals((int)2, (int)disabledNameservices.size());
        Assertions.assertTrue((disabledNameservices.contains("ns0") && disabledNameservices.contains("ns1") ? 1 : 0) != 0);
        disabledStore.enableNameservice("ns0");
        disabledStore.loadCache(true);
        disabledNameservices = disabledStore.getDisabledNameservices();
        Assertions.assertEquals((int)1, (int)disabledNameservices.size());
        Assertions.assertTrue((boolean)disabledNameservices.contains("ns1"));
    }
}

