/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreService;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;

public class TestStateStoreBase {
    private static StateStoreService stateStore;
    private static Configuration conf;

    protected static StateStoreService getStateStore() {
        return stateStore;
    }

    protected static Configuration getConf() {
        return conf;
    }

    @BeforeAll
    public static void createBase() throws IOException, InterruptedException {
        conf = FederationStateStoreTestUtils.getStateStoreConfiguration();
        conf.setLong("dfs.federation.router.store.connection.test", TimeUnit.HOURS.toMillis(1L));
    }

    @AfterAll
    public static void destroyBase() throws Exception {
        if (stateStore != null) {
            stateStore.stop();
            stateStore.close();
            stateStore = null;
        }
    }

    @BeforeEach
    public void setupBase() throws IOException, InterruptedException, InstantiationException, IllegalAccessException {
        if (stateStore == null) {
            stateStore = FederationStateStoreTestUtils.newStateStore(conf);
            Assertions.assertNotNull((Object)stateStore);
        }
        stateStore.loadDriver();
        FederationStateStoreTestUtils.waitStateStore(stateStore, TimeUnit.SECONDS.toMillis(10L));
    }
}

