/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.router.RouterHDFSContract;
import org.apache.hadoop.fs.contract.router.SecurityConfUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.metrics.RouterMBean;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.security.RouterSecurityManager;
import org.apache.hadoop.hdfs.server.federation.router.security.token.ZKDelegationTokenSecretManagerImpl;
import org.apache.hadoop.hdfs.server.federation.security.MockDelegationTokenSecretManager;
import org.apache.hadoop.hdfs.server.federation.security.MockNotRunningSecretManager;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.Metrics2Util;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterSecurityManager {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterSecurityManager.class);
    private static RouterSecurityManager securityManager = null;

    @BeforeAll
    public static void createMockSecretManager() throws IOException {
        MockDelegationTokenSecretManager mockDelegationTokenSecretManager = new MockDelegationTokenSecretManager(100L, 100L, 100L, 100L);
        mockDelegationTokenSecretManager.startThreads();
        securityManager = new RouterSecurityManager((AbstractDelegationTokenSecretManager)mockDelegationTokenSecretManager);
        DefaultMetricsSystem.setMiniClusterMode((boolean)true);
    }

    private Router initializeAndStartRouter(Configuration configuration) {
        Router router = new Router();
        router.init(configuration);
        router.start();
        return router;
    }

    @Test
    public void testCreateSecretManagerUsingReflection() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("dfs.federation.router.secret.manager.class", MockDelegationTokenSecretManager.class.getName());
        conf.set("hadoop.security.authentication", UserGroupInformation.AuthenticationMethod.KERBEROS.name());
        RouterSecurityManager routerSecurityManager = new RouterSecurityManager((Configuration)conf);
        AbstractDelegationTokenSecretManager secretManager = routerSecurityManager.getSecretManager();
        Assertions.assertNotNull((Object)secretManager);
        Assertions.assertTrue((boolean)secretManager.isRunning());
        routerSecurityManager.stop();
        Assertions.assertFalse((boolean)secretManager.isRunning());
    }

    @Test
    public void testDelegationTokens() throws IOException {
        UserGroupInformation.reset();
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createUserForTesting((String)"router", (String[])TestRouterSecurityManager.getUserGroupForTesting()));
        Token token = securityManager.getDelegationToken(new Text("some_renewer"));
        Assertions.assertNotNull((Object)token);
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createUserForTesting((String)"some_renewer", (String[])TestRouterSecurityManager.getUserGroupForTesting()));
        long updatedExpirationTime = securityManager.renewDelegationToken(token);
        Assertions.assertTrue((updatedExpirationTime <= ((DelegationTokenIdentifier)token.decodeIdentifier()).getMaxDate() ? 1 : 0) != 0);
        securityManager.cancelDelegationToken(token);
        Assertions.assertThrows(SecretManager.InvalidToken.class, () -> securityManager.renewDelegationToken(token));
    }

    @Test
    public void testDelgationTokenTopOwners() throws Exception {
        UserGroupInformation.reset();
        UserGroupInformation user = UserGroupInformation.createUserForTesting((String)"abc", (String[])new String[]{"router_group"});
        UserGroupInformation.setLoginUser((UserGroupInformation)user);
        Token dt = securityManager.getDelegationToken(new Text("abc"));
        List topOwners = securityManager.getSecretManager().getTopTokenRealOwners(2);
        Assertions.assertEquals((int)1, (int)topOwners.size());
        Assertions.assertEquals((Object)"abc", (Object)((Metrics2Util.NameValuePair)topOwners.get(0)).getName());
        Assertions.assertEquals((long)1L, (long)((Metrics2Util.NameValuePair)topOwners.get(0)).getValue());
        securityManager.renewDelegationToken(dt);
        topOwners = securityManager.getSecretManager().getTopTokenRealOwners(2);
        Assertions.assertEquals((int)1, (int)topOwners.size());
        Assertions.assertEquals((Object)"abc", (Object)((Metrics2Util.NameValuePair)topOwners.get(0)).getName());
        Assertions.assertEquals((long)1L, (long)((Metrics2Util.NameValuePair)topOwners.get(0)).getValue());
        securityManager.cancelDelegationToken(dt);
        topOwners = securityManager.getSecretManager().getTopTokenRealOwners(2);
        Assertions.assertEquals((int)0, (int)topOwners.size());
        UserGroupInformation routerUser = UserGroupInformation.createRemoteUser((String)"router");
        UserGroupInformation proxyUser = UserGroupInformation.createProxyUserForTesting((String)"abc", (UserGroupInformation)routerUser, (String[])new String[]{"router_group"});
        UserGroupInformation.setLoginUser((UserGroupInformation)proxyUser);
        Token proxyDT = securityManager.getDelegationToken(new Text("router"));
        topOwners = securityManager.getSecretManager().getTopTokenRealOwners(2);
        Assertions.assertEquals((int)1, (int)topOwners.size());
        Assertions.assertEquals((Object)"router", (Object)((Metrics2Util.NameValuePair)topOwners.get(0)).getName());
        Assertions.assertEquals((long)1L, (long)((Metrics2Util.NameValuePair)topOwners.get(0)).getValue());
        UserGroupInformation.setLoginUser((UserGroupInformation)routerUser);
        securityManager.renewDelegationToken(proxyDT);
        topOwners = securityManager.getSecretManager().getTopTokenRealOwners(2);
        Assertions.assertEquals((int)1, (int)topOwners.size());
        Assertions.assertEquals((Object)"router", (Object)((Metrics2Util.NameValuePair)topOwners.get(0)).getName());
        Assertions.assertEquals((long)1L, (long)((Metrics2Util.NameValuePair)topOwners.get(0)).getValue());
        securityManager.cancelDelegationToken(proxyDT);
        topOwners = securityManager.getSecretManager().getTopTokenRealOwners(2);
        Assertions.assertEquals((int)0, (int)topOwners.size());
        securityManager.getDelegationToken(new Text("router"));
        securityManager.getDelegationToken(new Text("router"));
        UserGroupInformation.setLoginUser((UserGroupInformation)user);
        securityManager.getDelegationToken(new Text("router"));
        topOwners = securityManager.getSecretManager().getTopTokenRealOwners(2);
        Assertions.assertEquals((int)2, (int)topOwners.size());
        Assertions.assertEquals((Object)"router", (Object)((Metrics2Util.NameValuePair)topOwners.get(0)).getName());
        Assertions.assertEquals((long)2L, (long)((Metrics2Util.NameValuePair)topOwners.get(0)).getValue());
        Assertions.assertEquals((Object)"abc", (Object)((Metrics2Util.NameValuePair)topOwners.get(1)).getName());
        Assertions.assertEquals((long)1L, (long)((Metrics2Util.NameValuePair)topOwners.get(1)).getValue());
    }

    @Test
    public void testVerifyToken() throws IOException {
        UserGroupInformation.reset();
        UserGroupInformation.setLoginUser((UserGroupInformation)UserGroupInformation.createUserForTesting((String)"router", (String[])TestRouterSecurityManager.getUserGroupForTesting()));
        Token token = securityManager.getDelegationToken(new Text("some_renewer"));
        Assertions.assertNotNull((Object)token);
        securityManager.verifyToken((DelegationTokenIdentifier)token.decodeIdentifier(), token.getPassword());
        String exceptionCause = "password doesn't match";
        SecretManager.InvalidToken exception = (SecretManager.InvalidToken)Assertions.assertThrows(SecretManager.InvalidToken.class, () -> securityManager.verifyToken((DelegationTokenIdentifier)token.decodeIdentifier(), new byte[10]));
        Assertions.assertTrue((boolean)exception.getMessage().contains(exceptionCause));
    }

    @Test
    public void testCreateCredentials() throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().build();
        conf.addResource(routerConf);
        Router router = this.initializeAndStartRouter(conf);
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"router", (String[])TestRouterSecurityManager.getUserGroupForTesting());
        Credentials creds = RouterSecurityManager.createCredentials((Router)router, (UserGroupInformation)ugi, (String)"some_renewer");
        for (Token token : creds.getAllTokens()) {
            Assertions.assertNotNull((Object)token);
            Assertions.assertEquals((Object)"HDFS_DELEGATION_TOKEN", (Object)token.getKind().toString());
            DelegationTokenIdentifier identifier = (DelegationTokenIdentifier)token.decodeIdentifier();
            Assertions.assertNotNull((Object)identifier);
            String owner = identifier.getOwner().toString();
            String host = Path.WINDOWS ? "127.0.0.1" : "localhost";
            String expectedOwner = "router/" + host + "@EXAMPLE.COM";
            Assertions.assertEquals((Object)expectedOwner, (Object)owner);
            Assertions.assertEquals((Object)"some_renewer", (Object)identifier.getRenewer().toString());
        }
        RouterHDFSContract.destroyCluster();
    }

    private static String[] getUserGroupForTesting() {
        String[] groupsForTesting = new String[]{"router_group"};
        return groupsForTesting;
    }

    @Test
    public void testGetTopTokenRealOwners() throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().build();
        conf.addResource(routerConf);
        Router router = this.initializeAndStartRouter(conf);
        UserGroupInformation ugi = UserGroupInformation.createUserForTesting((String)"router", (String[])TestRouterSecurityManager.getUserGroupForTesting());
        RouterSecurityManager.createCredentials((Router)router, (UserGroupInformation)ugi, (String)"some_renewer");
        String host = Path.WINDOWS ? "127.0.0.1" : "localhost";
        String expectedOwner = "router/" + host + "@EXAMPLE.COM";
        RouterMBean bean = FederationTestUtils.getBean("Hadoop:service=Router,name=Router", RouterMBean.class);
        String topTokenRealOwners = bean.getTopTokenRealOwners();
        JsonNode topTokenRealOwnersList = new ObjectMapper().readTree(topTokenRealOwners);
        Assertions.assertEquals((Object)expectedOwner, (Object)topTokenRealOwnersList.get(0).get("name").asText(), (String)("The key:name contains incorrect value " + topTokenRealOwners));
        RouterHDFSContract.destroyCluster();
    }

    @Test
    public void testWithoutSecretManager() throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        conf.set("dfs.federation.router.secret.manager.class", ZKDelegationTokenSecretManagerImpl.class.getName());
        Router router = new Router();
        LambdaTestUtils.intercept(ServiceStateException.class, (String)"Failed to create SecretManager", () -> router.init(conf));
    }

    @Test
    public void testNotRunningSecretManager() throws Exception {
        Configuration conf = SecurityConfUtil.initSecurity();
        conf.set("dfs.federation.router.secret.manager.class", MockNotRunningSecretManager.class.getName());
        Router router = new Router();
        LambdaTestUtils.intercept(ServiceStateException.class, (String)"Failed to create SecretManager", () -> router.init(conf));
    }
}

