/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncClass;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.BaseClass;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.SyncClass;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAsyncUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TestAsyncUtil.class);
    private static final long TIME_CONSUMING = 100L;
    private BaseClass baseClass;
    private boolean enableAsync;

    public void setUp(ExecutionMode mode) {
        if (mode.equals((Object)ExecutionMode.ASYNC)) {
            this.baseClass = new AsyncClass(100L);
            this.enableAsync = true;
        } else {
            this.baseClass = new SyncClass(100L);
        }
    }

    @AfterEach
    public void after() {
        this.baseClass = null;
        this.enableAsync = false;
    }

    @EnumSource(value=ExecutionMode.class)
    @ParameterizedTest
    public void testApply(ExecutionMode mode) throws Exception {
        this.setUp(mode);
        long start = Time.monotonicNow();
        String result = this.baseClass.applyMethod(1);
        long cost = Time.monotonicNow() - start;
        LOG.info("[{}] main thread cost: {} ms", (Object)mode, (Object)cost);
        this.checkResult("applyMethod[1]", result, 100L, cost);
    }

    @EnumSource(value=ExecutionMode.class)
    @ParameterizedTest
    public void testApplyException(ExecutionMode mode) throws Exception {
        this.setUp(mode);
        this.checkException(() -> this.baseClass.applyMethod(2, true), IOException.class, "input 2 exception");
        this.checkException(() -> this.baseClass.applyMethod(3, true), RuntimeException.class, "input 3 exception");
    }

    @EnumSource(value=ExecutionMode.class)
    @ParameterizedTest
    public void testExceptionMethod(ExecutionMode mode) throws Exception {
        this.setUp(mode);
        this.checkException(() -> this.baseClass.exceptionMethod(2), IOException.class, "input 2 exception");
        this.checkException(() -> this.baseClass.exceptionMethod(3), RuntimeException.class, "input 3 exception");
        long start = Time.monotonicNow();
        String result = this.baseClass.exceptionMethod(1);
        long cost = Time.monotonicNow() - start;
        LOG.info("[{}] main thread cost: {} ms", (Object)mode, (Object)cost);
        this.checkResult("applyMethod[1]", result, 100L, cost);
    }

    @EnumSource(value=ExecutionMode.class)
    @ParameterizedTest
    public void testApplyThenApplyMethod(ExecutionMode mode) throws Exception {
        this.setUp(mode);
        long start = Time.monotonicNow();
        String result = this.baseClass.applyThenApplyMethod(1);
        long cost = Time.monotonicNow() - start;
        this.checkResult("[2]", result, 100L, cost);
        LOG.info("[{}] main thread cost: {} ms", (Object)mode, (Object)cost);
        start = Time.monotonicNow();
        result = this.baseClass.applyThenApplyMethod(3);
        cost = Time.monotonicNow() - start;
        this.checkResult("[3]", result, 100L, cost);
        LOG.info("[{}] main thread cost: {} ms", (Object)mode, (Object)cost);
    }

    @EnumSource(value=ExecutionMode.class)
    @ParameterizedTest
    public void testCatchThenApplyMethod(ExecutionMode mode) throws Exception {
        this.setUp(mode);
        long start = Time.monotonicNow();
        String result = this.baseClass.applyCatchThenApplyMethod(2);
        long cost = Time.monotonicNow() - start;
        this.checkResult("applyMethod[1]", result, 100L, cost);
        LOG.info("[{}] main thread cost: {} ms", (Object)mode, (Object)cost);
        start = Time.monotonicNow();
        result = this.baseClass.applyCatchThenApplyMethod(0);
        cost = Time.monotonicNow() - start;
        this.checkResult("[0]", result, 100L, cost);
        LOG.info("[{}] main thread cost: {} ms", (Object)mode, (Object)cost);
    }

    @EnumSource(value=ExecutionMode.class)
    @ParameterizedTest
    public void testCatchFinallyMethod(ExecutionMode mode) throws Exception {
        this.setUp(mode);
        ArrayList<String> resource = new ArrayList<String>();
        resource.add("resource1");
        this.checkException(() -> this.baseClass.applyCatchFinallyMethod(2, resource), IOException.class, "input 2 exception");
        Assertions.assertTrue((resource.size() == 0 ? 1 : 0) != 0);
        long start = Time.monotonicNow();
        String result = this.baseClass.applyCatchFinallyMethod(0, resource);
        long cost = Time.monotonicNow() - start;
        this.checkResult("[0]", result, 100L, cost);
        Assertions.assertTrue((resource.size() == 0 ? 1 : 0) != 0);
        LOG.info("[{}] main thread cost: {} ms", (Object)mode, (Object)cost);
    }

    @EnumSource(value=ExecutionMode.class)
    @ParameterizedTest
    public void testForEach(ExecutionMode mode) throws Exception {
        this.setUp(mode);
        long start = Time.monotonicNow();
        String result = this.baseClass.forEachMethod(Arrays.asList(1, 2, 3));
        long cost = Time.monotonicNow() - start;
        LOG.info("[{}] main thread cost: {} ms", (Object)mode, (Object)cost);
        this.checkResult("forEach[1],forEach[2],forEach[3],", result, 100L, cost);
    }

    @EnumSource(value=ExecutionMode.class)
    @ParameterizedTest
    public void testForEachBreak(ExecutionMode mode) throws Exception {
        this.setUp(mode);
        long start = Time.monotonicNow();
        String result = this.baseClass.forEachBreakMethod(Arrays.asList(1, 2, 3));
        long cost = Time.monotonicNow() - start;
        LOG.info("[{}] main thread cost: {} ms", (Object)mode, (Object)cost);
        this.checkResult("forEach[1],", result, 100L, cost);
    }

    @EnumSource(value=ExecutionMode.class)
    @ParameterizedTest
    public void testForEachBreakByException(ExecutionMode mode) throws Exception {
        this.setUp(mode);
        long start = Time.monotonicNow();
        String result = this.baseClass.forEachBreakByExceptionMethod(Arrays.asList(1, 2, 3));
        long cost = Time.monotonicNow() - start;
        LOG.info("[{}] main thread cost: {} ms", (Object)mode, (Object)cost);
        this.checkResult("forEach[1],java.io.IOException: input 2 exception,", result, 100L, cost);
    }

    @EnumSource(value=ExecutionMode.class)
    @ParameterizedTest
    public void testCurrentMethod(ExecutionMode mode) throws Exception {
        this.setUp(mode);
        long start = Time.monotonicNow();
        String result = this.baseClass.currentMethod(Arrays.asList(1, 2, 3));
        long cost = Time.monotonicNow() - start;
        LOG.info("[{}] main thread cost: {} ms", (Object)mode, (Object)cost);
        this.checkResult("[1],java.io.IOException: input 2 exception,java.lang.RuntimeException: input 3 exception,", result, 100L, cost);
    }

    private void checkResult(String result, String actualResult, long cost, long actualCost) throws Exception {
        if (this.enableAsync) {
            Assertions.assertNull((Object)actualResult);
            actualResult = (String)AsyncUtil.syncReturn(String.class);
            Assertions.assertNotNull((Object)actualResult);
            Assertions.assertTrue((actualCost < cost ? 1 : 0) != 0);
        } else {
            Assertions.assertFalse((actualCost < cost ? 1 : 0) != 0);
        }
        Assertions.assertEquals((Object)result, (Object)actualResult);
    }

    private <E extends Throwable> void checkException(Callable<String> eval, Class<E> clazz, String contained) throws Exception {
        if (this.enableAsync) {
            LambdaTestUtils.intercept(clazz, (String)contained, () -> {
                eval.call();
                return (String)AsyncUtil.syncReturn(String.class);
            });
        } else {
            LambdaTestUtils.intercept(clazz, (String)contained, () -> {
                String res = (String)eval.call();
                return res;
            });
        }
    }

    public static enum ExecutionMode {
        SYNC,
        ASYNC;

    }
}

