/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.BaseClass;

public class SyncClass
implements BaseClass {
    private long timeConsuming;

    public SyncClass(long timeConsuming) {
        this.timeConsuming = timeConsuming;
    }

    @Override
    public String applyMethod(int input) {
        String res = this.timeConsumingMethod(input);
        return "applyMethod" + res;
    }

    @Override
    public String applyMethod(int input, boolean canException) throws IOException {
        String res = this.timeConsumingMethod(input);
        if (canException) {
            if (res.equals("[2]")) {
                throw new IOException("input 2 exception");
            }
            if (res.equals("[3]")) {
                throw new RuntimeException("input 3 exception");
            }
        }
        return res;
    }

    @Override
    public String exceptionMethod(int input) throws IOException {
        if (input == 2) {
            throw new IOException("input 2 exception");
        }
        if (input == 3) {
            throw new RuntimeException("input 3 exception");
        }
        return this.applyMethod(input);
    }

    @Override
    public String forEachMethod(List<Integer> list) {
        StringBuilder result = new StringBuilder();
        for (int input : list) {
            String res = this.timeConsumingMethod(input);
            result.append("forEach" + res + ",");
        }
        return result.toString();
    }

    @Override
    public String forEachBreakMethod(List<Integer> list) {
        int input;
        String res;
        StringBuilder result = new StringBuilder();
        Iterator<Integer> iterator = list.iterator();
        while (iterator.hasNext() && !(res = this.timeConsumingMethod(input = iterator.next().intValue())).equals("[2]")) {
            result.append("forEach" + res + ",");
        }
        return result.toString();
    }

    @Override
    public String forEachBreakByExceptionMethod(List<Integer> list) {
        StringBuilder result = new StringBuilder();
        for (int input : list) {
            try {
                String res = this.applyMethod(input, true);
                result.append("forEach" + res + ",");
            }
            catch (IOException e) {
                result.append(e + ",");
            }
            catch (RuntimeException e) {
                break;
            }
        }
        return result.toString();
    }

    @Override
    public String applyThenApplyMethod(int input) {
        String res = this.timeConsumingMethod(input);
        if (res.equals("[1]")) {
            res = this.timeConsumingMethod(2);
        }
        return res;
    }

    @Override
    public String applyCatchThenApplyMethod(int input) {
        String res = null;
        try {
            res = this.applyMethod(input, true);
        }
        catch (IOException e) {
            res = this.applyMethod(1);
        }
        return res;
    }

    @Override
    public String applyCatchFinallyMethod(int input, List<String> resource) throws IOException {
        String res = null;
        try {
            res = this.applyMethod(input, true);
        }
        catch (IOException e) {
            throw new IOException("Catch " + e.getMessage());
        }
        finally {
            resource.clear();
        }
        return res;
    }

    @Override
    public String currentMethod(List<Integer> list) {
        ExecutorService executor = this.getExecutorService();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (int input : list) {
            Future future = executor.submit(() -> this.applyMethod(input, true));
            futures.add(future);
        }
        StringBuilder result = new StringBuilder();
        for (Future future : futures) {
            try {
                String res = (String)future.get();
                result.append(res + ",");
            }
            catch (Exception e) {
                result.append(e.getMessage() + ",");
            }
        }
        return result.toString();
    }

    public String timeConsumingMethod(int input) {
        try {
            Thread.sleep(this.timeConsuming);
            return "[" + input + "]";
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return "Error:" + e.getMessage();
        }
    }

    private ExecutorService getExecutorService() {
        return Executors.newFixedThreadPool(2, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
    }
}

