/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async.utils;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.ApplyFunction;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.Async;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncApplyFunction;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncCatchFunction;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.CatchFunction;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.SyncClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClass
extends SyncClass {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncClass.class);
    private ExecutorService executorService = Executors.newFixedThreadPool(1, r -> {
        Thread asyncWork = new Thread(r);
        asyncWork.setDaemon(true);
        asyncWork.setName(ASYNC_WORKER);
        return asyncWork;
    });
    private static final String ASYNC_WORKER = "Async Worker";

    public AsyncClass(long timeConsuming) {
        super(timeConsuming);
    }

    @Override
    public String applyMethod(int input) {
        this.timeConsumingMethod(input);
        AsyncUtil.asyncApply(res -> "applyMethod" + res);
        return (String)AsyncUtil.asyncReturn(String.class);
    }

    @Override
    public String applyMethod(int input, boolean canException) {
        this.timeConsumingMethod(input);
        AsyncUtil.asyncApply(res -> {
            if (canException) {
                if (res.equals("[2]")) {
                    throw new IOException("input 2 exception");
                }
                if (res.equals("[3]")) {
                    throw new RuntimeException("input 3 exception");
                }
            }
            return res;
        });
        return (String)AsyncUtil.asyncReturn(String.class);
    }

    @Override
    public String exceptionMethod(int input) {
        if (input == 2) {
            AsyncUtil.asyncThrowException((Throwable)new IOException("input 2 exception"));
            return null;
        }
        if (input == 3) {
            AsyncUtil.asyncThrowException((Throwable)new RuntimeException("input 3 exception"));
            return null;
        }
        return this.applyMethod(input);
    }

    @Override
    public String forEachMethod(List<Integer> list) {
        StringBuilder result = new StringBuilder();
        AsyncUtil.asyncForEach(list.iterator(), (forEach, input) -> {
            this.timeConsumingMethod((int)input);
            AsyncUtil.asyncApply(res -> {
                result.append("forEach" + res + ",");
                return result.toString();
            });
        });
        return (String)AsyncUtil.asyncReturn(String.class);
    }

    @Override
    public String forEachBreakMethod(List<Integer> list) {
        StringBuilder result = new StringBuilder();
        AsyncUtil.asyncForEach(list.iterator(), (forEach, input) -> {
            this.timeConsumingMethod((int)input);
            AsyncUtil.asyncApply(res -> {
                if (res.equals("[2]")) {
                    forEach.breakNow();
                } else {
                    result.append("forEach" + res + ",");
                }
                return result.toString();
            });
        });
        return (String)AsyncUtil.asyncReturn(String.class);
    }

    @Override
    public String forEachBreakByExceptionMethod(List<Integer> list) {
        StringBuilder result = new StringBuilder();
        AsyncUtil.asyncForEach(list.iterator(), (forEach, input) -> {
            AsyncUtil.asyncTry(() -> {
                this.applyMethod((int)input, true);
                AsyncUtil.asyncApply(res -> {
                    result.append("forEach" + res + ",");
                    return result.toString();
                });
            });
            AsyncUtil.asyncCatch((res, e) -> {
                if (e instanceof IOException) {
                    result.append(e + ",");
                } else if (e instanceof RuntimeException) {
                    forEach.breakNow();
                }
                return result.toString();
            }, Exception.class);
        });
        return (String)AsyncUtil.asyncReturn(String.class);
    }

    @Override
    public String applyThenApplyMethod(int input) {
        this.timeConsumingMethod(input);
        AsyncUtil.asyncApply((ApplyFunction)((AsyncApplyFunction)res -> {
            if (res.equals("[1]")) {
                this.timeConsumingMethod(2);
            } else {
                AsyncUtil.asyncComplete((Object)res);
            }
        }));
        return (String)AsyncUtil.asyncReturn(String.class);
    }

    @Override
    public String applyCatchThenApplyMethod(int input) {
        AsyncUtil.asyncTry(() -> this.applyMethod(input, true));
        AsyncUtil.asyncCatch((CatchFunction)((AsyncCatchFunction)(res, ioe) -> this.applyMethod(1)), IOException.class);
        return (String)AsyncUtil.asyncReturn(String.class);
    }

    @Override
    public String applyCatchFinallyMethod(int input, List<String> resource) {
        AsyncUtil.asyncTry(() -> this.applyMethod(input, true));
        AsyncUtil.asyncCatch((res, e) -> {
            throw new IOException("Catch " + e.getMessage());
        }, IOException.class);
        AsyncUtil.asyncFinally(res -> {
            resource.clear();
            return res;
        });
        return (String)AsyncUtil.asyncReturn(String.class);
    }

    @Override
    public String currentMethod(List<Integer> list) {
        AsyncUtil.asyncCurrent(list, input -> this.applyMethod((int)input, true), futures -> {
            StringBuilder result = new StringBuilder();
            for (CompletableFuture future : futures) {
                try {
                    String res = (String)future.get();
                    result.append(res + ",");
                }
                catch (Exception e) {
                    result.append(e.getMessage() + ",");
                }
            }
            return result.toString();
        });
        return (String)AsyncUtil.asyncReturn(String.class);
    }

    @Override
    public String timeConsumingMethod(int input) {
        CompletableFuture<Object> result = CompletableFuture.supplyAsync(() -> {
            LOG.info("[{} thread] invoke consumingMethod for parameter: {}", (Object)Thread.currentThread().getName(), (Object)input);
            return AsyncClass.super.timeConsumingMethod(input);
        }, this.executorService);
        Async.CUR_COMPLETABLE_FUTURE.set(result);
        return null;
    }
}

