/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncProtocolTestBase;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncStoragePolicy;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterAsyncStoragePolicy
extends RouterAsyncProtocolTestBase {
    private final String testfilePath = "/testdir/testAsyncStoragePolicy.file";
    private RouterAsyncStoragePolicy asyncStoragePolicy;

    @BeforeEach
    public void setup() throws IOException {
        this.asyncStoragePolicy = new RouterAsyncStoragePolicy(this.getRouterAsyncRpcServer());
        FSDataOutputStream fsDataOutputStream = this.getRouterFs().create(new Path("/testdir/testAsyncStoragePolicy.file"), true);
        fsDataOutputStream.write(new byte[1024]);
        fsDataOutputStream.close();
    }

    @Test
    public void testRouterAsyncStoragePolicy() throws Exception {
        Object[] storagePolicies = TestRouterAsyncStoragePolicy.getCluster().getNamenodes().get(0).getClient().getStoragePolicies();
        this.asyncStoragePolicy.getStoragePolicies();
        Object[] storagePoliciesAsync = (BlockStoragePolicy[])AsyncUtil.syncReturn(BlockStoragePolicy[].class);
        Assertions.assertArrayEquals((Object[])storagePolicies, (Object[])storagePoliciesAsync);
        this.asyncStoragePolicy.getStoragePolicy("/testdir/testAsyncStoragePolicy.file");
        BlockStoragePolicy blockStoragePolicy1 = (BlockStoragePolicy)AsyncUtil.syncReturn(BlockStoragePolicy.class);
        this.asyncStoragePolicy.setStoragePolicy("/testdir/testAsyncStoragePolicy.file", "COLD");
        AsyncUtil.syncReturn(null);
        this.asyncStoragePolicy.getStoragePolicy("/testdir/testAsyncStoragePolicy.file");
        BlockStoragePolicy blockStoragePolicy2 = (BlockStoragePolicy)AsyncUtil.syncReturn(BlockStoragePolicy.class);
        Assertions.assertNotEquals((Object)blockStoragePolicy1, (Object)blockStoragePolicy2);
        Assertions.assertEquals((Object)"COLD", (Object)blockStoragePolicy2.getName());
    }
}

