/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.protocol.SnapshotStatus;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncProtocolTestBase;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncSnapshot;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterAsyncSnapshot
extends RouterAsyncProtocolTestBase {
    private final String testFile = "/testdir/testSnapshot.file";
    private FileSystem routerFs;
    private RouterAsyncSnapshot asyncSnapshot;

    @BeforeEach
    public void setup() throws IOException {
        this.routerFs = this.getRouterFs();
        this.asyncSnapshot = new RouterAsyncSnapshot(this.getRouterAsyncRpcServer());
        FSDataOutputStream fsDataOutputStream = this.routerFs.create(new Path("/testdir/testSnapshot.file"), true);
        fsDataOutputStream.write(new byte[1024]);
        fsDataOutputStream.close();
    }

    @Test
    public void testRouterAsyncSnapshot() throws Exception {
        this.asyncSnapshot.allowSnapshot("/testdir");
        AsyncUtil.syncReturn(null);
        this.asyncSnapshot.createSnapshot("/testdir", "testdirSnapshot");
        String snapshotName = (String)AsyncUtil.syncReturn(String.class);
        Assertions.assertEquals((Object)"/testdir/.snapshot/testdirSnapshot", (Object)snapshotName);
        this.asyncSnapshot.getSnapshottableDirListing();
        SnapshottableDirectoryStatus[] snapshottableDirectoryStatuses = (SnapshottableDirectoryStatus[])AsyncUtil.syncReturn(SnapshottableDirectoryStatus[].class);
        Assertions.assertEquals((int)1, (int)snapshottableDirectoryStatuses.length);
        this.asyncSnapshot.getSnapshotListing("/testdir");
        SnapshotStatus[] snapshotStatuses = (SnapshotStatus[])AsyncUtil.syncReturn(SnapshotStatus[].class);
        Assertions.assertEquals((int)1, (int)snapshotStatuses.length);
        FSDataOutputStream fsDataOutputStream = this.routerFs.append(new Path("/testdir/testSnapshot.file"), true);
        fsDataOutputStream.write(new byte[1024]);
        fsDataOutputStream.close();
        this.asyncSnapshot.createSnapshot("/testdir", "testdirSnapshot1");
        snapshotName = (String)AsyncUtil.syncReturn(String.class);
        Assertions.assertEquals((Object)"/testdir/.snapshot/testdirSnapshot1", (Object)snapshotName);
        this.asyncSnapshot.getSnapshotDiffReport("/testdir", "testdirSnapshot", "testdirSnapshot1");
        SnapshotDiffReport snapshotDiffReport = (SnapshotDiffReport)AsyncUtil.syncReturn(SnapshotDiffReport.class);
        Assertions.assertEquals((Object)SnapshotDiffReport.DiffType.MODIFY, (Object)((SnapshotDiffReport.DiffReportEntry)snapshotDiffReport.getDiffList().get(0)).getType());
        this.asyncSnapshot.getSnapshotDiffReportListing("/testdir", "testdirSnapshot", "testdirSnapshot1", new byte[0], -1);
        SnapshotDiffReportListing snapshotDiffReportListing = (SnapshotDiffReportListing)AsyncUtil.syncReturn(SnapshotDiffReportListing.class);
        Assertions.assertEquals((int)1, (int)snapshotDiffReportListing.getModifyList().size());
        LambdaTestUtils.intercept(SnapshotException.class, () -> {
            this.asyncSnapshot.disallowSnapshot("/testdir");
            AsyncUtil.syncReturn(null);
        });
        this.asyncSnapshot.renameSnapshot("/testdir", "testdirSnapshot1", "testdirSnapshot2");
        AsyncUtil.syncReturn(null);
        LambdaTestUtils.intercept(SnapshotException.class, (String)"Cannot delete snapshot testdirSnapshot1 from path /testdir", () -> {
            this.asyncSnapshot.deleteSnapshot("/testdir", "testdirSnapshot1");
            AsyncUtil.syncReturn(null);
        });
        this.asyncSnapshot.deleteSnapshot("/testdir", "testdirSnapshot2");
        AsyncUtil.syncReturn(null);
        this.asyncSnapshot.deleteSnapshot("/testdir", "testdirSnapshot");
        AsyncUtil.syncReturn(null);
        this.asyncSnapshot.disallowSnapshot("/testdir");
        AsyncUtil.syncReturn(null);
    }
}

