/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRouterAsyncRpcWhenNamenodeFailover {
    private StateStoreDFSCluster cluster;

    private void setupCluster(boolean ha) throws Exception {
        this.cluster = new StateStoreDFSCluster(ha, 2);
        Configuration routerConf = new RouterConfigBuilder().stateStore().metrics().admin().rpc().heartbeat().build();
        routerConf.setBoolean("dfs.federation.router.async.rpc.enable", true);
        this.cluster.addRouterOverrides(routerConf);
        this.cluster.startCluster();
        this.cluster.startRouters();
        this.cluster.waitClusterUp();
    }

    @Test
    public void testGetFileInfoWhenNsFailover() throws Exception {
        this.setupCluster(true);
        Configuration conf = this.cluster.getRouterClientConf();
        conf.setInt("dfs.client.retry.max.attempts", 2);
        DFSClient routerClient = new DFSClient(new URI("hdfs://fed"), conf);
        FederationTestUtils.transitionClusterNSToActive(this.cluster, 0);
        String basePath = "/ARR/testGetFileInfo";
        routerClient.mkdirs(basePath);
        DirectoryListing directoryListing = routerClient.listPaths("/ARR", new byte[0]);
        Assertions.assertEquals((int)1, (int)directoryListing.getPartialListing().length);
        FederationTestUtils.transitionClusterNSToStandby(this.cluster);
        Assertions.assertThrows(IOException.class, () -> {
            HdfsFileStatus fileInfo = routerClient.getFileInfo(basePath + "1");
        });
    }
}

