/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.federation.router.async.RouterAsyncProtocolTestBase;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterAsyncRpcServer
extends RouterAsyncProtocolTestBase {
    private RouterRpcServer asyncRouterRpcServer;

    @BeforeEach
    public void setup() throws IOException {
        this.asyncRouterRpcServer = this.getRouterAsyncRpcServer();
    }

    @Test
    public void testInvokeAtAvailableNsAsync() throws Exception {
        RemoteMethod method = new RemoteMethod("getStoragePolicies");
        this.asyncRouterRpcServer.invokeAtAvailableNsAsync(method, BlockStoragePolicy[].class);
        BlockStoragePolicy[] storagePolicies = (BlockStoragePolicy[])AsyncUtil.syncReturn(BlockStoragePolicy[].class);
        Assertions.assertEquals((int)8, (int)storagePolicies.length);
    }

    @Test
    public void testGetCreateLocationAsync() throws Exception {
        List locations = this.asyncRouterRpcServer.getLocationsForPath("/testdir", true);
        this.asyncRouterRpcServer.getCreateLocationAsync("/testdir", locations);
        RemoteLocation remoteLocation = (RemoteLocation)AsyncUtil.syncReturn(RemoteLocation.class);
        Assertions.assertNotNull((Object)remoteLocation);
        Assertions.assertEquals((Object)TestRouterAsyncRpcServer.getNs0(), (Object)remoteLocation.getNameserviceId());
    }

    @Test
    public void testGetDatanodeReportAsync() throws Exception {
        this.asyncRouterRpcServer.getDatanodeReportAsync(HdfsConstants.DatanodeReportType.ALL, true, 0L);
        DatanodeInfo[] datanodeInfos = (DatanodeInfo[])AsyncUtil.syncReturn(DatanodeInfo[].class);
        Assertions.assertEquals((int)3, (int)datanodeInfos.length);
        this.asyncRouterRpcServer.getDatanodeStorageReportMapAsync(HdfsConstants.DatanodeReportType.ALL);
        Map map = (Map)AsyncUtil.syncReturn(Map.class);
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((int)3, (int)((DatanodeStorageReport[])map.get(TestRouterAsyncRpcServer.getNs0())).length);
        Object[] slowDatanodeReport1 = this.asyncRouterRpcServer.getSlowDatanodeReport(true, 0L);
        this.asyncRouterRpcServer.getSlowDatanodeReportAsync(true, 0L);
        Object[] slowDatanodeReport2 = (DatanodeInfo[])AsyncUtil.syncReturn(DatanodeInfo[].class);
        Assertions.assertArrayEquals((Object[])slowDatanodeReport1, (Object[])slowDatanodeReport2);
    }
}

