/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.fairness.RouterAsyncRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.fairness.RouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.router.TestRouterRpcMultiDestination;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestRouterAsyncRpcMultiDestination
extends TestRouterRpcMultiDestination {
    @BeforeAll
    public static void globalSetUp() throws Exception {
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().build();
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        routerConf.setBoolean("dfs.federation.router.async.rpc.enable", true);
        routerConf.setClass("dfs.federation.router.fairness.policy.controller.class", RouterAsyncRpcFairnessPolicyController.class, RouterRpcFairnessPolicyController.class);
        TestRouterAsyncRpcMultiDestination.setUp(routerConf);
    }

    @Override
    @Test
    public void testgetGroupsForUser() throws Exception {
        MiniRouterDFSCluster.RouterContext rndRouter = super.getRouterContext();
        Object[] group = new String[]{"bar", "group2"};
        UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"bar", "group2"});
        rndRouter.getRouter().getRpcServer().getGroupsForUser("user");
        Object[] result = (String[])AsyncUtil.syncReturn(String[].class);
        Assertions.assertArrayEquals((Object[])group, (Object[])result);
    }

    @Override
    @Test
    public void testConcurrentCallExecutorInitial() {
        MiniRouterDFSCluster.RouterContext rndRouter = super.getRouterContext();
        Assertions.assertNull((Object)rndRouter.getRouterRpcClient().getExecutorService());
    }
}

