/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.fairness.RouterAsyncRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.fairness.RouterRpcFairnessPolicyController;
import org.apache.hadoop.hdfs.server.federation.router.TestRouterRpc;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestRouterAsyncRpc
extends TestRouterRpc {
    private static MiniRouterDFSCluster cluster;
    private MiniRouterDFSCluster.RouterContext rndRouter;

    @BeforeAll
    public static void globalSetUp() throws Exception {
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().build();
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        routerConf.setBoolean("dfs.federation.router.async.rpc.enable", true);
        routerConf.setClass("dfs.federation.router.fairness.policy.controller.class", RouterAsyncRpcFairnessPolicyController.class, RouterRpcFairnessPolicyController.class);
        routerConf.setInt("dfs.federation.router.async.rpc.handler.count", 2);
        TestRouterAsyncRpc.setUp(routerConf);
    }

    @Override
    @BeforeEach
    public void testSetup() throws Exception {
        super.testSetup();
        cluster = super.getCluster();
        this.rndRouter = cluster.getRandomRouter();
    }

    @Override
    @Test
    public void testgetGroupsForUser() throws Exception {
        Object[] group = new String[]{"bar", "group2"};
        UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"bar", "group2"});
        this.rndRouter.getRouter().getRpcServer().getGroupsForUser("user");
        Object[] result = (String[])AsyncUtil.syncReturn(String[].class);
        Assertions.assertArrayEquals((Object[])group, (Object[])result);
    }

    @Override
    @Test
    public void testConcurrentCallExecutorInitial() {
        Assertions.assertNull((Object)this.rndRouter.getRouterRpcClient().getExecutorService());
    }

    @Test
    public void testGetDelegationTokenAsyncRpc() throws Exception {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        Assertions.assertDoesNotThrow(() -> this.rndRouter.getFileSystem().getDelegationToken(ugi.getShortUserName()));
    }
}

