/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router.async;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableManager;
import org.apache.hadoop.hdfs.server.federation.resolver.MountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.MultipleDestinationMountTableResolver;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.resolver.order.LocalResolver;
import org.apache.hadoop.hdfs.server.federation.router.RemoteMethod;
import org.apache.hadoop.hdfs.server.federation.router.RouterClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterClientProtocol;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.router.TestRouterRPCMultipleDestinationMountTableResolver;
import org.apache.hadoop.hdfs.server.federation.router.async.utils.AsyncUtil;
import org.apache.hadoop.hdfs.server.federation.store.protocol.RemoveMountTableEntryRequest;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterAsyncRPCMultipleDestinationMountTableResolver
extends TestRouterRPCMultipleDestinationMountTableResolver {
    public static final Logger LOG = LoggerFactory.getLogger(TestRouterAsyncRPCMultipleDestinationMountTableResolver.class);

    @BeforeAll
    public static void setUp() throws Exception {
        cluster = new StateStoreDFSCluster(false, 3, MultipleDestinationMountTableResolver.class);
        Configuration routerConf = new RouterConfigBuilder().stateStore().admin().quota().rpc().build();
        routerConf.setBoolean("dfs.federation.router.async.rpc.enable", true);
        Configuration hdfsConf = new Configuration(false);
        hdfsConf.setBoolean("dfs.namenode.acls.enabled", true);
        cluster.addRouterOverrides(routerConf);
        cluster.addNamenodeOverrides(hdfsConf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        routerContext = cluster.getRandomRouter();
        resolver = (MountTableResolver)routerContext.getRouter().getSubclusterResolver();
        nnFs0 = (DistributedFileSystem)cluster.getNamenode(cluster.getNameservices().get(0), null).getFileSystem();
        nnFs1 = (DistributedFileSystem)cluster.getNamenode(cluster.getNameservices().get(1), null).getFileSystem();
        nnFs2 = (DistributedFileSystem)cluster.getNamenode(cluster.getNameservices().get(2), null).getFileSystem();
        routerFs = (DistributedFileSystem)routerContext.getFileSystem();
        rpcServer = routerContext.getRouter().getRpcServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalResolverGetDatanodesSubcluster() throws IOException {
        String testPath = "/testLocalResolverGetDatanodesSubcluster";
        Path path = new Path(testPath);
        HashMap<String, String> destMap = new HashMap<String, String>();
        destMap.put("ns0", testPath);
        destMap.put("ns1", testPath);
        nnFs0.mkdirs(path);
        nnFs1.mkdirs(path);
        MountTable addEntry = MountTable.newInstance((String)testPath, destMap);
        addEntry.setQuota(new RouterQuotaUsage.Builder().build());
        addEntry.setDestOrder(DestinationOrder.LOCAL);
        Assertions.assertTrue((boolean)this.addMountTable(addEntry));
        Map datanodesSubcluster = null;
        try {
            MultipleDestinationMountTableResolver resolver = (MultipleDestinationMountTableResolver)routerContext.getRouter().getSubclusterResolver();
            LocalResolver localResolver = (LocalResolver)resolver.getOrderedResolver(DestinationOrder.LOCAL);
            datanodesSubcluster = localResolver.getDatanodesSubcluster();
        }
        catch (Exception e) {
            LOG.info("Exception occurs when testLocalResolverGetDatanodesSubcluster.", (Throwable)e);
        }
        finally {
            RouterClient client = routerContext.getAdminClient();
            MountTableManager mountTableManager = client.getMountTableManager();
            RemoveMountTableEntryRequest req2 = RemoveMountTableEntryRequest.newInstance((String)testPath);
            mountTableManager.removeMountTableEntry(req2);
            nnFs0.delete(new Path(testPath), true);
            nnFs1.delete(new Path(testPath), true);
        }
        Assertions.assertNotNull((Object)datanodesSubcluster);
        Assertions.assertFalse((boolean)datanodesSubcluster.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    public void testInvokeAtAvailableNs() throws IOException {
        Path path = new Path("/testInvokeAtAvailableNs");
        HashMap<String, String> destMap = new HashMap<String, String>();
        destMap.put("ns0", "/testInvokeAtAvailableNs");
        destMap.put("ns1", "/testInvokeAtAvailableNs");
        nnFs0.mkdirs(path);
        nnFs1.mkdirs(path);
        MountTable addEntry = MountTable.newInstance((String)"/testInvokeAtAvailableNs", destMap);
        addEntry.setQuota(new RouterQuotaUsage.Builder().build());
        addEntry.setDestOrder(DestinationOrder.RANDOM);
        addEntry.setFaultTolerant(true);
        Assertions.assertTrue((boolean)this.addMountTable(addEntry));
        MiniDFSCluster dfsCluster = cluster.getCluster();
        dfsCluster.shutdownNameNode(0);
        dfsCluster.shutdownNameNode(1);
        try {
            RemoteMethod method = new RemoteMethod("getServerDefaults");
            FsServerDefaults serverDefaults = null;
            rpcServer.invokeAtAvailableNsAsync(method, FsServerDefaults.class);
            try {
                serverDefaults = (FsServerDefaults)AsyncUtil.syncReturn(FsServerDefaults.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Assertions.assertNotNull((Object)serverDefaults);
        }
        finally {
            dfsCluster.restartNameNode(0);
            dfsCluster.restartNameNode(1);
        }
    }

    @Override
    @Test
    public void testIsMultiDestDir() throws Exception {
        RouterClientProtocol client = routerContext.getRouter().getRpcServer().getClientProtocolModule();
        this.setupOrderMountPath(DestinationOrder.HASH_ALL);
        client.isMultiDestDirectory("/mount/dir");
        Assertions.assertTrue((boolean)((Boolean)AsyncUtil.syncReturn(Boolean.TYPE)));
        client.isMultiDestDirectory("/mount/nodir");
        Assertions.assertFalse((boolean)((Boolean)AsyncUtil.syncReturn(Boolean.TYPE)));
        client.isMultiDestDirectory("/mount/dir/file");
        Assertions.assertFalse((boolean)((Boolean)AsyncUtil.syncReturn(Boolean.TYPE)));
        routerFs.createSymlink(new Path("/mount/dir/file"), new Path("/mount/dir/link"), true);
        client.isMultiDestDirectory("/mount/dir/link");
        Assertions.assertFalse((boolean)((Boolean)AsyncUtil.syncReturn(Boolean.TYPE)));
        routerFs.createSymlink(new Path("/mount/dir/dir"), new Path("/mount/dir/linkDir"), true);
        client.isMultiDestDirectory("/mount/dir/linkDir");
        Assertions.assertFalse((boolean)((Boolean)AsyncUtil.syncReturn(Boolean.TYPE)));
        this.resetTestEnvironment();
        this.setupOrderMountPath(DestinationOrder.HASH);
        client.isMultiDestDirectory("/mount/dir");
        Assertions.assertFalse((boolean)((Boolean)AsyncUtil.syncReturn(Boolean.TYPE)));
    }
}

